
# Re-setting Error Processors SBC LA Polygon ------------------------------

# Some nodes stopped running due to a space error, and this resulted in errors usually placed in both processes running on the node. Therefore, in order to assess which process caused the error, we re-set the jobs  to continue running them. If when we re-run and another error occurs then if a process continues past the original point of error then it was not the process that caused the space error and we remove the error in IrregSBCErrRemovalProcs_final.R and let it continue running. The other process if it does have another error in the same position would be allowed to continue running with the error remaining as it was the grid-mesh combination that resulted in the error. However, in some cases the processes progress past the point of error and continue running with no issue.

# Note: this no space on disk error was due to an incorrect assignment of the temp directory on the compute nodes in Balena for the INLA function to run. After these initial space errors were re-set and re-run, this was noticed and the temporary directory was corrected within my simulation code. Therefore, any of the processes that continued to have errors after these re-sets were labelled as space errors and were later re-run with 16 processors on the node available.

# This code re-sets the processes, by re-creating the output and copying and pasting the pre-error results into the new output to save.
# The procs <- c() assignments are left included as an example, and to illustrate which processes came across this error.

# Author: Nadeen Khaleel


# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))


# Re-setting Errors -------------------------------------------------------

# Assign the processes that had issues in order to remove the error: note that most of these come in pairs as a ndoe failure usually placed errors in both processes.
# procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40) # the original errors
# procs <- 8
procs <- c(21,22)

for (ii in 1:length(procs)){
  total.nodes = 20 # how many nodes am I using?
  Nprocs.vec = rep(2,20) # vector where each element contains the number of processors for a particular node
  Nprocs.total = 40 # total number of processors across ALL nodes (/jobs)
  N = 1000 # how many simulations?
  L = 100
  sim = 0 # start new or re-starting at last saved simulation?
  
  # procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40) # 06/06/2021 - No space on disk errors, so re-set although for Job 4 Proc 8 and Job 18 Proc 36, there were no errors
  # procs <- 8
  procs <- c(21,22)
  paste("# ",1:length(procs),sep="",collapse=" ")
  k.ind <- ii
  k <- procs[k.ind]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  sink(paste0("ReSettingErrorForNode",this.node,"Proc",k,"_1006.txt")) # In some of the .txt outputs, the date (e.g. 1006.txt) was not included, but as these errors occurred after the other processes had been re-set, we wanted to distinguish between them.
  
  # Load up the old files with the errors
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_SPACEERROR2.rda") # or _SPACEERROR.rda if from the first round of errors occurring
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)
  
  
  Nprocs <- Nprocs.vec[this.node]
  
  cs <- c(0,cumsum(Nprocs.vec))
  ind.procs <- (cs[this.node]+1):(cs[(this.node+1)])
  
  ind.procs
  
  
  M.it.total <- rep(N%/%Nprocs.total,length=Nprocs.total)
  if (N%%Nprocs.total!=0){M.it.total[1:(N%%Nprocs.total)] <- M.it.total[1:(N%%Nprocs.total)] + 1}
  
  library(spatstat)
  
  window.file <- "X:/Maths/ResearchProjects/TRSmith/TRSmith2/MCMC_INLA/Grid_Mesh/IrregPolLGCP/IrregPolLGCPCode/WindowsIrregPolLGCP.rda"
  quad.file <- "X:/Maths/ResearchProjects/TRSmith/TRSmith2/MCMC_INLA/Grid_Mesh/IrregPolLGCP/IrregPolLGCPCode/QuadratsIrregPolLGCP.rda"
  
  load(quad.file)
  
  pred <- FALSE
  
  # Saving the output
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  print(save.file)
  
  load(window.file)
  x.range <- diff(lacity_win.proj$xrange)
  y.range <- diff(lacity_win.proj$yrange)
  
  
  grid_cellsxvec <- ceiling(x.range/(1e3*c(5,2,1,0.5)))
  grid_cellsyvec <- ceiling(y.range/(1e3*c(5,2,1,0.5)))
  
  disc.full <- unname(cbind(grid_cellsxvec,grid_cellsyvec))
  param <- c("Beta0","Beta1","Beta2","Sigma","Rho")
  N.gridx <- disc.full[,1]; N.gridy <- disc.full[,2]; mesh.edge <- apply(cbind(abs((W$xrange[2]-W$xrange[1]))/N.gridx,abs((W$yrange[2]-W$yrange[1]))/N.gridy), 1, max)
  N.g <- length(N.gridx); N.m <- length(mesh.edge); N.p <- length(param)
  
  grid.ind <- paste0("Grid",N.gridx,N.gridy); mesh.ind <- paste0("Mesh",signif(mesh.edge,2));
  
  # Locations for the prediction, currently on the finest resolution, but can be altered accordingly, maybe on the finest, but an in between?
  l.dat <- length(quad.list)
  final.loc.ind <- l.dat
  
  N.f <- sapply(1:length(quad.list),function(i){quad.list[[i]]$n})
  
  if (sim==0){
    p.length <- 1
    
    # Grid-Mesh List Creation 
    gm <- vector(mode="list",length=N.g*N.m)
    names(gm) <- paste0(rep(paste0("Grid",N.gridx,N.gridy),each=N.m),rep(paste0("Mesh",signif(mesh.edge,2)),N.g))
    rank.list <- list()
    rank.list$ranks.param <- data.frame(matrix(rep(NA,N.p*M.it.total[k]),ncol=N.p))
    names(rank.list$ranks.param) <- param
    rank.list$ranks.mf <- data.frame(matrix(rep(NA,N.f[final.loc.ind]*M.it.total[k]),ncol=N.f[final.loc.ind]))
    names(rank.list$ranks.mf) <- paste0("loc",1:N.f[final.loc.ind])
    gm <- lapply(gm,function(x){x <- rank.list})
    if (pred==FALSE){
      for (i in 1:N.g){
        for (j in 1:N.m){
          gm.ind <- (i-1)*N.m + j
          gm[[gm.ind]]$ranks.mf <- data.frame(matrix(rep(NA,N.f[i]*M.it.total[k]),ncol=N.f[i]))
          names(gm[[gm.ind]]$ranks.mf) <- paste0("loc",1:N.f[i])
        }
      }
    }
    
    # Final Data list
    list.grid <- vector(mode="list",length=N.g)
    names(list.grid) <- grid.ind
    list.mesh <- vector(mode="list",length=N.m)
    names(list.mesh) <- mesh.ind
    list.param <- vector(mode="list",length=3)
    names(list.param) <- c("est.df","run.df","mess.ls")
    list.param$est.df <- data.frame(beta0=rep(NA,M.it.total[k]),beta0.sd=rep(NA,M.it.total[k]),beta0.cil=rep(NA,M.it.total[k]),beta0.ciu=rep(NA,M.it.total[k]),beta1=rep(NA,M.it.total[k]),beta1.sd=rep(NA,M.it.total[k]),beta1.cil=rep(NA,M.it.total[k]),beta1.ciu=rep(NA,M.it.total[k]),beta2=rep(NA,M.it.total[k]),beta2.sd=rep(NA,M.it.total[k]),beta2.cil=rep(NA,M.it.total[k]),beta2.ciu=rep(NA,M.it.total[k]),sigma=rep(NA,M.it.total[k]),sigma.sd=rep(NA,M.it.total[k]),sigma.cil=rep(NA,M.it.total[k]),sigma.ciu=rep(NA,M.it.total[k]),sigma.mode=rep(NA,M.it.total[k]),rho=rep(NA,M.it.total[k]),rho.sd=rep(NA,M.it.total[k]),rho.cil=rep(NA,M.it.total[k]),rho.ciu=rep(NA,M.it.total[k]),rho.mode=rep(NA,M.it.total[k]))
    # list.param$run.df <- list(time=rep(NA,M.it.total[k]),cpo=vector(mode="list",length=M.it.total[k]),waic=rep(NA,M.it.total[k]),dic=rep(NA,M.it.total[k]))
    list.param$run.df <- list(time=rep(NA,M.it.total[k]),waic=rep(NA,M.it.total[k]),dic=rep(NA,M.it.total[k]))
    list.param$mess.ls <- list(error=rep(NA,M.it.total[k]),warning=rep(NA,M.it.total[k]),FFT=rep(NA,M.it.total[k]),message=vector(mode="list",length=M.it.total[k]))
    
    list.meshparam <- lapply(list.mesh,function(x){x <- list.param})
    run.out <- lapply(list.grid,function(x){x <- list.meshparam})
    
    true.theta <- data.frame(beta0=rep(NA,M.it.total[k]),beta1=rep(NA,M.it.total[k]),beta2=rep(NA,M.it.total[k]),sigma=rep(NA,M.it.total[k]),rho=rep(NA,M.it.total[k]))
    
    grid.start.ind <- 1
    mesh.start.ind <- 1
    
    data.err.tracker <- data.frame(matrix(vector(), ncol = (length(param)+4), nrow = 0))
    colnames(data.err.tracker) <- c("proc","iter","seed.init","type.err","beta0","beta1","beta2","sigma","rho")
    seed.vec <- rep(NA,M.it.total[k])
  } else{
    load(save.file)
    
    nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
    p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
    
    gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
    s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
    e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
    s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
    ds <- diff(s)
    if (sum(ds)!=0){
      w <- which(ds!=0,arr.ind = T)
      grid.start.ind <- unname(w)[2]
      mesh.start.ind <- unname(w)[1] + 1
    } else if (sum(diff(t(s))!=0)){
      w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
      grid.start.ind <- unname(w)[1,1] + 1
      mesh.start.ind <- unname(w)[1,2]
    } else {
      grid.start.ind <- 1
      mesh.start.ind <- 1
    }
  } 
  
  
  
  
  # Start Replacing Completed Runs in to New List ---------------------------
  
  dim(run.out[[1]][[1]]$est.df)
  dim(run.out.old[[1]][[1]]$est.df)
  
  length(run.out[[1]][[1]]$run.df)
  length(run.out.old[[1]][[1]]$run.df)
  
  length(run.out[[1]][[1]]$mess.ls$error)
  length(run.out.old[[1]][[1]]$mess.ls$error)
  
  length(run.out[[1]][[1]]$mess.ls$FFT)
  length(run.out.old[[1]][[1]]$mess.ls$FFT)
  
  length(run.out[[1]][[1]]$mess.ls$warning)
  length(run.out.old[[1]][[1]]$mess.ls$warning)
  
  length(run.out[[1]][[1]]$mess.ls$message)
  length(run.out.old[[1]][[1]]$mess.ls$message)
  
  for (i in 1:16){
    print(names(gm.old)[i])
    print(names(gm)[i])
    print(dim(gm.old[[i]]$ranks.param))
    print(dim(gm[[i]]$ranks.param))
    print(dim(gm.old[[i]]$ranks.mf))
    print(dim(gm[[i]]$ranks.mf))
  }
  
  
  replacement.max <- rep(NA,length(procs))
  rep.vec <- rep(0,16)
  for (ii in 1:4){
    for (jj in 1:4){
      rep.vec[(ii-1)*4 + jj] <- sum(!is.na(run.out.old[[ii]][[jj]]$est.df$beta0)) + sum(!is.na(run.out.old[[ii]][[jj]]$mess.ls$error))
    }
  }
  replacement.max <- min(rep.vec)
  
  # For these, want to re-start the run even though it is 16/16 (G4M4) so re-set up to previous
  if (sum(diff(rep.vec))==0){
    replacement.max <- replacement.max - 1
  }
  
  print(k.ind)
  print(k)
  print(save.file)
  print(old.file)
  print(this.node)
  print(replacement.max)
  
  
  if (replacement.max==0){
    save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
  } else {
    for (i in 1:replacement.max){
      print(paste0("iteration ",i," out of ",replacement.max))
      for (j in 1:4){ # grid
        print(paste0("Grid ",j))
        for (l in 1:4){ # mesh
          print(paste0("Mesh ",l))
          
          ind <- (j-1)*N.m + l
          print(paste0("Index ",ind))
          
          # theta values
          seed.vec[i] <- seed.vec.old[i]
          true.theta[i,] <- true.theta.old[i,]
          
          # run.out
          ## run.df
          run.out[[j]][[l]]$run.df$time[i] <- run.out.old[[j]][[l]]$run.df$time[i]
          # run.out[[j]][[l]]$run.df$cpo[[i]] <- run.out.old[[j]][[l]]$run.df$cpo[[i]] # Need to tell inla to calculate this
          run.out[[j]][[l]]$run.df$waic[i] <- run.out.old[[j]][[l]]$run.df$waic[i] # Need to tell inla to calculate this too!
          run.out[[j]][[l]]$run.df$dic[i] <- run.out.old[[j]][[l]]$run.df$dic[i] # Need to tell inla to calculate this too!
          
          ## est.df
          ### Posterior Mean
          run.out[[j]][[l]]$est.df$beta0[i] <- run.out.old[[j]][[l]]$est.df$beta0[i]
          run.out[[j]][[l]]$est.df$beta1[i] <- run.out.old[[j]][[l]]$est.df$beta1[i]
          run.out[[j]][[l]]$est.df$beta2[i] <- run.out.old[[j]][[l]]$est.df$beta2[i]
          run.out[[j]][[l]]$est.df$sigma[i] <- run.out.old[[j]][[l]]$est.df$sigma[i]
          run.out[[j]][[l]]$est.df$rho[i] <- run.out.old[[j]][[l]]$est.df$rho[i]
          ### Posterior SD
          run.out[[j]][[l]]$est.df$beta0.sd[i] <- run.out.old[[j]][[l]]$est.df$beta0.sd[i]
          run.out[[j]][[l]]$est.df$beta1.sd[i] <- run.out.old[[j]][[l]]$est.df$beta1.sd[i]
          run.out[[j]][[l]]$est.df$beta2.sd[i] <- run.out.old[[j]][[l]]$est.df$beta2.sd[i]
          run.out[[j]][[l]]$est.df$sigma.sd[i] <- run.out.old[[j]][[l]]$est.df$sigma.sd[i]
          run.out[[j]][[l]]$est.df$rho.sd[i] <- run.out.old[[j]][[l]]$est.df$rho.sd[i]
          ### Mode for Sigma and Rho
          run.out[[j]][[l]]$est.df$sigma.mode[i] <- run.out.old[[j]][[l]]$est.df$sigma.mode[i]
          run.out[[j]][[l]]$est.df$rho.mode[i] <- run.out.old[[j]][[l]]$est.df$rho.mode[i]
          ### Posterior 2.5%
          run.out[[j]][[l]]$est.df$beta0.cil[i] <- run.out.old[[j]][[l]]$est.df$beta0.cil[i]
          run.out[[j]][[l]]$est.df$beta1.cil[i] <- run.out.old[[j]][[l]]$est.df$beta1.cil[i]
          run.out[[j]][[l]]$est.df$beta2.cil[i] <- run.out.old[[j]][[l]]$est.df$beta2.cil[i]
          run.out[[j]][[l]]$est.df$sigma.cil[i] <- run.out.old[[j]][[l]]$est.df$sigma.cil[i]
          run.out[[j]][[l]]$est.df$rho.cil[i] <- run.out.old[[j]][[l]]$est.df$rho.cil[i]
          ### Posterior 97.5%
          run.out[[j]][[l]]$est.df$beta0.ciu[i] <- run.out.old[[j]][[l]]$est.df$beta0.ciu[i]
          run.out[[j]][[l]]$est.df$beta1.ciu[i] <- run.out.old[[j]][[l]]$est.df$beta1.ciu[i]
          run.out[[j]][[l]]$est.df$beta2.ciu[i] <- run.out.old[[j]][[l]]$est.df$beta2.ciu[i]
          run.out[[j]][[l]]$est.df$sigma.ciu[i] <- run.out.old[[j]][[l]]$est.df$sigma.ciu[i]
          run.out[[j]][[l]]$est.df$rho.ciu[i] <-  run.out.old[[j]][[l]]$est.df$rho.ciu[i]
          
          ## mess.ls
          ### "Error"
          run.out[[j]][[l]]$mess.ls$error[i] <- run.out.old[[j]][[l]]$mess.ls$error[i]
          
          ### "FFT"
          run.out[[j]][[l]]$mess.ls$FFT[i] <- run.out.old[[j]][[l]]$mess.ls$FFT[i]
          
          # gm
          gm[[ind]]$ranks.param[i,1] <- gm.old[[ind]]$ranks.param[i,1]
          gm[[ind]]$ranks.param[i,2] <- gm.old[[ind]]$ranks.param[i,2]
          gm[[ind]]$ranks.param[i,3] <- gm.old[[ind]]$ranks.param[i,3]
          gm[[ind]]$ranks.param[i,4] <- gm.old[[ind]]$ranks.param[i,4]
          gm[[ind]]$ranks.param[i,5] <- gm.old[[ind]]$ranks.param[i,5]
          
          gm[[ind]]$ranks.mf[i,] <- gm.old[[ind]]$ranks.mf[i,]
          
        }
        save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
      }
      save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
    }
  }
  
  save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
  
  

# Check Between Old and New Output ----------------------------------------

  # CHECK!!
  
  for (i in 1:4){
    for (j in 1:4){
      lm <- length(run.out[[i]][[j]]$mess.ls$message)
      print(lm)
      print(sum(sapply(1:lm,function(l){is.null(run.out.old[[i]][[j]]$mess.ls$message[[l]])})))
      print(sum(sapply(1:lm,function(l){is.null(run.out[[i]][[j]]$mess.ls$message[[l]])})))
    }
  }
  
  for (i in 1:4){
    for (j in 1:4){
      lm <- length(run.out[[i]][[j]]$mess.ls$FFT)
      print(lm)
      lm2 <- length(run.out[[i]][[j]]$mess.ls$error)
      print(lm2)
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$error)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$error)))
    }
  }
  
  ################################
  
  # CHECKS ####
  
  sum(true.theta[1:replacement.max,]-true.theta.old[1:replacement.max,])
  sum(seed.vec[1:replacement.max]-seed.vec.old[1:replacement.max])
  
  data.err.tracker
  data.err.tracker.old
  
  for (jj in 1:4){
    for (ll in 1:4){
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,])))
    }
  }
  
  for (jj in 1:4){
    for (ll in 1:4){
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max])))
    }
  }
  
  for (jj in 1:4){
    for (ll in 1:4){
      ind <- (jj-1)*N.m + ll
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,])))
    }
  }
  
  for (jj in 1:4){
    for (ll in 1:4){
      ind <- (jj-1)*N.m + ll
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,])))
    }
  }
  
  
  sink()
  
  rm(list=ls())
  
}


# More Checks Between Old and New Data ------------------------------------
# Double check pre- and post- reset of the outputs to see if there was any incorrect item saved.

# procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40)
# procs <- 8
procs <- c(21,22)

# sink("DoubleCheckingAllRe-Sets.txt")
# sink("DoubleCheckingProc8Re-Sets.txt")
sink("DoubleCheckingProc11Re-Sets.txt") # this should be Node11Re-Sets..., as it is processes 21 and 22, or Proc21and22Re-Sets...
for (ii in 1:length(procs)){
  
  k.ind <- ii # 3 # 4 # 5 # 6 # 7 # 8 # 9 # 10 # 11 # 12 # 13 # 14 # 15 # 16 # 17 # 18 # 19 # 20 # 21 # 22 # 23 # 24
  k <- procs[k.ind]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  print(paste0("Process ",k))
  
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_SPACEERROR2.rda") # or _SPACEERROR.rda
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)
  
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  load(save.file)
  
  replacement.max <- rep(NA,length(procs))
  rep.vec <- rep(0,16)
  for (ii in 1:4){
    for (jj in 1:4){
      rep.vec[(ii-1)*4 + jj] <- sum(!is.na(run.out.old[[ii]][[jj]]$est.df$beta0)) + sum(!is.na(run.out.old[[ii]][[jj]]$mess.ls$error))
    }
  }
  replacement.max <- min(rep.vec)
  replacement.max
  
  # For these, want to re-start the run even though it is 16/16 so re-set up to previous
  
  if (sum(diff(rep.vec))==0){
    replacement.max <- replacement.max - 1
  }
  print("Replacement Maximum")
  print(replacement.max)
  
  print("Names gm")
  print(names(gm.old))
  print(names(gm))
  
  print(sum(names(gm.old)==names(gm)))
  print(sum(names(gm.old)!=names(gm)))
  
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length Message")
      lm <- length(run.out[[i]][[j]]$mess.ls$message)
      print(lm)
      print("Null Messages Counts")
      print(sum(sapply(1:lm,function(l){is.null(run.out.old[[i]][[j]]$mess.ls$message[[l]])})))
      print(sum(sapply(1:lm,function(l){is.null(run.out[[i]][[j]]$mess.ls$message[[l]])})))
    }
  }
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length FFT")
      lm <- length(run.out[[i]][[j]]$mess.ls$FFT)
      print(lm)
      print("Length Error")
      lm2 <- length(run.out[[i]][[j]]$mess.ls$error)
      print(lm2)
      print("FFT Count")
      print(sum((run.out.old[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print(sum((run.out[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print("Warnings Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$warning)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$warning)))
      print("Errors Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$error)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$error)))
    }
  }
  
  #######
  
  # CHECKS ####
  
  print("Compare true.theta and seed.vec")
  print(sum(true.theta[1:replacement.max,]-true.theta.old[1:replacement.max,]))
  print(max(abs(true.theta[1:replacement.max,]-true.theta.old[1:replacement.max,])))
  print(sum(seed.vec[1:replacement.max]-seed.vec.old[1:replacement.max]))
  print(max(abs(seed.vec[1:replacement.max]-seed.vec.old[1:replacement.max])))
  
  print("data.err.tracker comparison")
  print(data.err.tracker)
  print(data.err.tracker.old)
  
  print("Sum and Max-Abs Different and sum is.na in est.df")
  for (jj in 1:4){
    for (ll in 1:4){
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(is.na(run.out[[jj]][[ll]]$est.df)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(!is.na(run.out[[jj]][[ll]]$est.df)))
    }
  }
  
  print("Sum and Max-Abs difference in FFT")
  for (jj in 1:4){
    for (ll in 1:4){
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(!is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
    }
  }
  
  N.g <- 4; N.m <- 4
  
  print("Sum and Max-Abs difference in ranks.param")
  for (jj in 1:4){
    for (ll in 1:4){
      ind <- (jj-1)*N.m + ll
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.param)))
      print(sum(is.na(gm[[ind]]$ranks.param)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.param)))
      print(sum(!is.na(gm[[ind]]$ranks.param)))
    }
  }
  
  print("Sum and Max-Abs difference in ranks.mf")
  for (jj in 1:4){
    for (ll in 1:4){
      ind <- (jj-1)*N.m + ll
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(is.na(gm[[ind]]$ranks.mf)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(!is.na(gm[[ind]]$ranks.mf)))
    }
  }
  
  for (i in 1:16){
    print(paste0("Dimension gm.old ", i))
    print(dim(gm.old[[i]]$ranks.param))
    print(dim(gm.old[[i]]$ranks.mf))
    print(paste0("Dimension gm ", i))
    print(dim(gm[[i]]$ranks.param))
    print(dim(gm[[i]]$ranks.mf))
  }
  
  
  
}

sink()

rm(list=ls())


# Checking Old and New Starting Positions ---------------------------------
# Double check the pre- and post-reset starting points

# PREVIOUS

# sink("CheckingStartingPositionsOldandNew070621.txt")
# sink("CheckingStartingPositionsOldandNewProc8070621.txt")
sink("CheckingStartingPositionsOldandNewProc11100621.txt")

print("Error Versions")

# procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40)
# procs <- 8
procs <- c(21,22)

N.g <- 4
N.m <- 4

restart.mat.orig <- matrix(rep(NA,3*length(procs)),ncol=length(procs))
for (i in procs){
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_SPACEERROR2.rda")) # or _SPACEERROR.rda
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  ii <- which(procs==i)
  restart.mat.orig[1,ii] <- p.length
  restart.mat.orig[2,ii] <- grid.start.ind
  restart.mat.orig[3,ii] <- mesh.start.ind
  
  print(paste0("Run ",i))
  print(paste0("p.length = ",p.length))
  print(paste0("Grid start = ", grid.start.ind," and Mesh start = ",mesh.start.ind))
}



###############################################
# NEW

print("Reset Versions)")
# procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40) # 06/06/2021 - No space on disk errors, so re-set although for Job 4 Proc 8 and Job 18 Proc 36, there were no errors
# procs <- 8
procs <- c(21,22)

N.g <- 4
N.m <- 4
restart.mat <- matrix(rep(NA,3*length(procs)),ncol=length(procs))
for (i in procs){
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,".rda"))
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  ii <- which(procs==i)
  restart.mat[1,ii] <- p.length
  restart.mat[2,ii] <- grid.start.ind
  restart.mat[3,ii] <- mesh.start.ind
  
  print(paste0("Run ",i))
  print(paste0("p.length = ",p.length))
  print(paste0("Grid start = ", grid.start.ind," and Mesh start = ",mesh.start.ind))
}

print("Old and New Restart")
rbind(restart.mat.orig,restart.mat)
print("Old and New p.length")
rbind(restart.mat.orig[1,],restart.mat[1,])

sink()

rm(list=ls())

# procs <- c(1,2,3,4,5,6,7,9,10,11,12,17,18,19,20,27,28,29,30,31,32,35,39,40)
# procs <- 8
procs <- c(21,22)

for (i in procs){
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_SPACEERROR2.rda") # all errors after 04/06/2021
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,".rda"))
  
  print(sum(names(run.out.old)!=names(run.out)))
  print(sum(names(run.out.old[[1]])!=names(run.out[[1]])))
  print(sum(names(run.out.old[[2]])!=names(run.out[[2]])))
  print(sum(names(run.out.old[[3]])!=names(run.out[[3]])))
  print(sum(names(run.out.old[[4]])!=names(run.out[[4]])))
  
}

rm(list=ls())
