
# Time Error Addition SBC LA Polygon --------------------------------------

# This R script takes in the processes that I have highlighted as having exceeded a run limit and therefore I will place an error in the particular grid and mesh combination slot for the specific simulation iteration. These will be given as "TIME ERROR K" where k is not present for the first time error, and then k=2,...,8 as necessary. There is allso the TIME ERROR 2 SKIP where the presence of a time error for a coarser mesh (e.g. mesh 3) indicates that there may also be a time error for the finer mesh (mesh 4), and so to avoid having to manually stop and start the process again, I will pre-emptively place a TIME ERROR in place so that this grid and mesh resolution will be skipped and we can come back later when we re-run all of the time errors.

# Additionally, there was a typo where TIME ERROR 4 was placed for processes 5 and 14 when it should have been TIME ERROR 5 and so we also have code included to change TIME ERROR 4 to TIME ERROR 5.

# Author: Nadeen Khaleel


# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

# Addition of Time Errors -------------------------------------------------

# Select the processes we want to include the time error for. Below I have kept all of the different values of procs <- c() that I have used from TIME ERROR 1 to TIME ERROR 8.
# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3 19/06 TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06 TIME ERROR 4
# procs <- c(5,14) # 22/06 TIME ERROR 5
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR 8 (21-3-1 and 21-4-1)


for (ii in 1:length(procs)){
  total.nodes = 20 # how many nodes am I using?
  Nprocs.vec = rep(2,20) # vector where each element contains the number of processors for a particular node
  Nprocs.total = 40 # total number of processors across ALL nodes (/jobs)
  N = 1000 # how many simulations?
  L = 100
  sim = 0 # start new or re-starting at last saved simulation?
  
  # procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
  # procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
  # procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
  # procs <- 38 # TIME ERROR 3
  # procs <- c(5,16,30,38) # 21/06
  # procs <- c(5,14) # 22/06
  # procs <- c(5,19) # 24/06
  procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8
  
  paste("# ",1:length(procs),sep="",collapse=" ")
  k.ind <- ii
  k <- procs[k.ind]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  sink(paste0("AddingTimingErrorForProc",k,"Error8.txt"))
  
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR1.rda")
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR2SKIP.rda") # on 16/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR3.rda") # on 19/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR4.rda") # on 21/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR5.rda") # on 22/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR6.rda") # on 24/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR7.rda") # on 25/06
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR8.rda") # on 25/06
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  
  
  # Saving the output
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  print(save.file)
  
  N.g <- 4; N.m <- 4
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out.old[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out.old),function(i){e.s(run.out.old[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  
  p.rep <- p.length
  grid.rep <- grid.start.ind
  mesh.rep <- mesh.start.ind
  
  
  print(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$error[p.rep])
  
  print("Sum FFT not NA")
  print(sum(!is.na(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$FFT)))
  print("est.df for p.rep not NA")
  print(sum(!is.na(run.out.old[[grid.rep]][[mesh.rep]]$est.df[p.rep,])))
  print("gm NA")
  iind <- (grid.rep-1)*N.m + mesh.rep
  print(sum(!is.na(gm[[iind]]$ranks.param[p.rep,])))
  print(sum(!is.na(gm[[iind]]$ranks.mf[p.rep,])))
  
  print("FFT NAs")
  print(sum(is.na(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$FFT)))
  print("est.df for p.rep NA")
  print(sum(is.na(run.out.old[[grid.rep]][[mesh.rep]]$est.df[p.rep,])))
  
  # Replaces ERROR
  run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$error[p.rep] <- "TIME ERROR 8" # Change number of time error label as necessary
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length.new <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out.old[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out.old),function(i){e.s(run.out.old[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind.new <- unname(w)[2]
    mesh.start.ind.new <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind.new <- unname(w)[1,1] + 1
    mesh.start.ind.new <- unname(w)[1,2]
  } else {
    grid.start.ind.new <- 1
    mesh.start.ind.new <- 1
  }
  
  print("Old Settings)")
  print(p.length)
  print(grid.start.ind)
  print(mesh.start.ind)
  
  print("New Settings")
  print(p.length.new)
  print(grid.start.ind.new)
  print(mesh.start.ind.new)
  
  run.out <- run.out.old
  
  save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
  
  sink()
  
}

sink()
rm(list=ls())

#


# Check Old and New Outputs -----------------------------------------------
# Double check pre- and post-error addition outputs to check that the only difference is the addition of the errors.

# Which processes need time errors
# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06
# procs <- c(5,14) # 22/06
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8

sink("DoubleCheckingTimingErrorAddError8.txt") # Change as required dependent on the time error under consideration
for (ii in 1:length(procs)){
  
  k.ind <- ii
  k <- procs[k.ind]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  print(paste0("Process ",k))
  
  # We have labelled the outputs for the processes with the relevant suffix of the time error.
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR1.rda")
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR2SKIP.rda") # on 16/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR3.rda") # on 16/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR4.rda") # on 21/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR5.rda") # on 22/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR6.rda") # on 24/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR7.rda") # on 25/06
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR8.rda") # on 25/06
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)
  
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  load(save.file)
  
  N.g <- 4; N.m <- 4
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  
  
  print("Names gm")
  print(names(gm.old))
  print(names(gm))
  
  print(sum(names(gm.old)==names(gm)))
  print(sum(names(gm.old)!=names(gm)))
  
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length Message")
      lm <- length(run.out[[i]][[j]]$mess.ls$message)
      print(lm)
      print("Null Messages Counts")
      print(sum(sapply(1:lm,function(l){is.null(run.out.old[[i]][[j]]$mess.ls$message[[l]])})))
      print(sum(sapply(1:lm,function(l){is.null(run.out[[i]][[j]]$mess.ls$message[[l]])})))
    }
  }
  
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length FFT")
      lm <- length(run.out[[i]][[j]]$mess.ls$FFT)
      print(lm)
      print("Length Error")
      lm2 <- length(run.out[[i]][[j]]$mess.ls$error)
      print(lm2)
      print("FFT Count")
      print(sum((run.out.old[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print(sum((run.out[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print("Warnings Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$warning)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$warning)))
      print("Errors Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$error)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$error)))
    }
  }
  
  #######
  
  
  # CHECKS ####
  
  if (grid.start.ind==1&mesh.start.ind==1){ # for time error addition
    p.check <- p.length - 1
  } else {
    p.check <- p.length
  }
  
  print("Compare true.theta and seed.vec")
  print(sum(true.theta[1:p.check,]-true.theta.old[1:p.check,]))
  print(max(abs(true.theta[1:p.check,]-true.theta.old[1:p.check,])))
  print(sum(seed.vec[1:p.check]-seed.vec.old[1:p.check]))
  print(max(abs(seed.vec[1:p.check]-seed.vec.old[1:p.check])))
  
  print("data.err.tracker comparison")
  print(data.err.tracker)
  print(data.err.tracker.old)
  
  print("Sum and Max-Abs Different and sum is.na in est.df")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(is.na(run.out[[jj]][[ll]]$est.df)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(!is.na(run.out[[jj]][[ll]]$est.df)))
    }
  }
  
  print("Sum and Max-Abs difference in FFT")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(!is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
    }
  }
  
  N.g <- 4; N.m <- 4
  
  print("Sum and Max-Abs difference in ranks.param")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.param)))
      print(sum(is.na(gm[[ind]]$ranks.param)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.param)))
      print(sum(!is.na(gm[[ind]]$ranks.param)))
    }
  }
  
  print("Sum and Max-Abs difference in ranks.mf")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(is.na(gm[[ind]]$ranks.mf)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(!is.na(gm[[ind]]$ranks.mf)))
    }
  }
  
  for (i in 1:16){
    print(paste0("Dimension gm.old ", i))
    print(dim(gm.old[[i]]$ranks.param))
    print(dim(gm.old[[i]]$ranks.mf))
    print(paste0("Dimension gm ", i))
    print(dim(gm[[i]]$ranks.param))
    print(dim(gm[[i]]$ranks.mf))
  }
  
  
  
}

sink()


# Checking Old and New Starting Positions ---------------------------------
# Check the addition of the time error, process pre- and post- addition to check the start position for the simulations.

# PREVIOUS

sink("CheckingStartingPositionsOldandNewProc160621Error8.txt") # Change name of .txt file accordingly, where 160621 denotes the first time error addition on 16/06, although other time errors appeared up until time error 8 on 25/06.

print("Error Versions")

# Which processes need time errors
# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06
# procs <- c(5,14) # 22/06
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8

N.g <- 4
N.m <- 4

restart.mat.orig <- matrix(rep(NA,3*length(procs)),ncol=length(procs))
for (i in procs){
  # load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR3.rda"))
  # load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR4.rda"))
  # load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR5.rda")) # on 22/06
  # load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR6.rda")) # on 24/06
  # load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR7.rda")) # on 25/06
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR8.rda")) # on 25/06
  
  # p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.gf[,N.f])) + 1
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  ii <- which(procs==i)
  restart.mat.orig[1,ii] <- p.length
  restart.mat.orig[2,ii] <- grid.start.ind
  restart.mat.orig[3,ii] <- mesh.start.ind
  
  print(paste0("Run ",i))
  print(paste0("p.length = ",p.length))
  print(paste0("Grid start = ", grid.start.ind," and Mesh start = ",mesh.start.ind))
}




###############################################
# NEW

print("Reset Versions)")
# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06
# procs <- c(5,14) # 22/06
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8

N.g <- 4
N.m <- 4
restart.mat <- matrix(rep(NA,3*length(procs)),ncol=length(procs))
for (i in procs){
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,".rda"))
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  ii <- which(procs==i)
  restart.mat[1,ii] <- p.length
  restart.mat[2,ii] <- grid.start.ind
  restart.mat[3,ii] <- mesh.start.ind
  
  print(paste0("Run ",i))
  print(paste0("p.length = ",p.length))
  print(paste0("Grid start = ", grid.start.ind," and Mesh start = ",mesh.start.ind))
}

print("Old and New Restart")
rbind(restart.mat.orig,restart.mat)
print("Old and New p.length")
rbind(restart.mat.orig[1,],restart.mat[1,])

sink()

rm(list=ls())

# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06
# procs <- c(5,14) # 22/06
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8

for (i in procs){
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR1.rda")
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR2SKIP.rda") # on 16/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR3.rda") # on 19/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR4.rda") # on 21/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR5.rda") # on 22/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR6.rda") # on 24/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR7.rda") # on 25/06
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",i,"_TIMEERROR8.rda") # on 25/06
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  load(paste0("GridMeshIrregPolLGCPSBCSS",i,".rda"))
  
  print(sum(names(run.out.old)!=names(run.out)))
  print(sum(names(run.out.old[[1]])!=names(run.out[[1]])))
  print(sum(names(run.out.old[[2]])!=names(run.out[[2]])))
  print(sum(names(run.out.old[[3]])!=names(run.out[[3]])))
  print(sum(names(run.out.old[[4]])!=names(run.out[[4]])))
  
}

rm(list=ls())


# Additional Checks Between Old and New Output ----------------------------
# These checks will only be printed to the console not saved to a text file.

# procs <- c(2,5,6,7,9,10,14,16,17,18,19,20,23,27,29,30,32,33,35) # TIME ERROR 1
# procs <- c(8,14,16,18,23,27,33,35) # TIME ERROR 2
# procs <- c(16,18,23,27,33) # TIME ERROR 2 SKIP
# procs <- 38 # TIME ERROR 3
# procs <- c(5,16,30,38) # 21/06
# procs <- c(5,14) # 22/06
# procs <- c(5,19) # 24/06 TIME ERROR 6
procs <- 8 # 25/06 TIME ERROR 7 and TIME ERROR8

for (k in procs){
  print(paste0("Process ",k))
  
  # # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR1.rda")
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR2SKIP.rda") # on 16/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR3.rda") # on 19/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR4.rda") # on 21/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR5.rda") # on 22/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR6.rda") # on 24/06
  # old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR7.rda") # on 25/06
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR8.rda") # on 25/06
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)
  
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  load(save.file)
  
  N.g <- 4; N.m <- 4
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  
  print("Sum and Max-Abs Different and sum is.na in est.df")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,]),na.rm=TRUE))
    }
  }
  
  print("Sum and Max-Abs difference in FFT")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max]),na.rm=TRUE))
      
    }
  }
  
  N.g <- 4; N.m <- 4
  
  print("Sum and Max-Abs difference in ranks.param")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,]),na.rm=TRUE))
      
    }
  }
  
  print("Sum and Max-Abs difference in ranks.mf")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,]),na.rm=TRUE))
    }
  }
  
  
}

rm(list=ls())




# Time Error Typo Correction ----------------------------------------------

# Process 5 and 14 had time error 5, but it was accidentally included as time error 4 instead and so this needs to be corrected and the output double checked.

procs <- c(5,14)
sim <- c(16,24)
grid.ind <- c(4,3)
mesh.ind <- c(2,1)

print(rbind(procs,sim,grid.ind,mesh.ind))

for (ii in 1:length(procs)){
  k <- procs[ii]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  sink(paste0("CorrectingTimeError5TypeForProc",k,".txt"))
  
  print(paste0("Correcting Typo (4 to 5) in Process ", k, " in Simulation ",sim[ii],", Grid ",grid.ind[ii]," and Mesh ",mesh.ind[ii]))
  
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR5Typo.rda")
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  
  
  # Saving the output
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  print(save.file)
  
  N.g <- 4; N.m <- 4
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out.old[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out.old),function(i){e.s(run.out.old[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  
  
  p.rep <- sim[ii]
  grid.rep <- grid.ind[ii]
  mesh.rep <- mesh.ind[ii]
  
  print(p.rep)
  print(grid.rep)
  print(mesh.rep)
  
  
  print(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$error[p.rep])
  
  print("Sum FFT not NA")
  print(sum(!is.na(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$FFT)))
  print("est.df for p.rep not NA")
  print(sum(!is.na(run.out.old[[grid.rep]][[mesh.rep]]$est.df[p.rep,])))
  print("gm NA")
  iind <- (grid.rep-1)*N.m + mesh.rep
  print(sum(!is.na(gm[[iind]]$ranks.param[p.rep,])))
  print(sum(!is.na(gm[[iind]]$ranks.mf[p.rep,])))
  
  print("FFT NAs")
  print(sum(is.na(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$FFT)))
  print("est.df for p.rep NA")
  print(sum(is.na(run.out.old[[grid.rep]][[mesh.rep]]$est.df[p.rep,])))
  
  # Replaces ERROR
  run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$error[p.rep] <- "TIME ERROR 5" #
  
  print(run.out.old[[grid.rep]][[mesh.rep]]$mess.ls$error[p.rep])
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length.new <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out.old[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out.old),function(i){e.s(run.out.old[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind.new <- unname(w)[2]
    mesh.start.ind.new <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind.new <- unname(w)[1,1] + 1
    mesh.start.ind.new <- unname(w)[1,2]
  } else {
    grid.start.ind.new <- 1
    mesh.start.ind.new <- 1
  }
  # }
  
  print("Old Settings)")
  print(p.length)
  print(grid.start.ind)
  print(mesh.start.ind)
  
  print("New Settings")
  print(p.length.new)
  print(grid.start.ind.new)
  print(mesh.start.ind.new)
  
  run.out <- run.out.old
  
  save(run.out,gm,true.theta,data.err.tracker,seed.vec,file=save.file)
  
  sink()
  
}



sink()
rm(list=ls())


# Check Time Error Typo Fix -----------------------------------------------

procs <- c(5,14)

sim <- c(16,24)
grid.ind <- c(4,3)
mesh.ind <- c(2,1)


sink("DoubleCheckingTimeError5TypeFix.txt")
for (ii in 1:length(procs)){
  
  k <- procs[ii]
  this.node <- k%/%2 + as.numeric(k%%2!=0)
  
  print(paste0("Process ",k))
  print(sim[ii])
  print(grid.ind[ii])
  print(mesh.ind[ii])
  
  old.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,"_TIMEERROR5Typo.rda")
  load(old.file)
  run.out.old <- run.out
  rm(run.out)
  gm.old <- gm
  rm(gm)
  true.theta.old <- true.theta
  rm(true.theta)
  seed.vec.old <- seed.vec
  rm(seed.vec)
  data.err.tracker.old <- data.err.tracker
  rm(data.err.tracker)
  
  save.file <- paste0("GridMeshIrregPolLGCPSBCSS",k,".rda")
  load(save.file)
  
  
  print("Old and New Time Errors:")
  print(run.out.old[[grid.ind[ii]]][[mesh.ind[[ii]]]]$mess.ls$error[sim[ii]])
  print(run.out[[grid.ind[ii]]][[mesh.ind[[ii]]]]$mess.ls$error[sim[ii]])
  
  N.g <- 4; N.m <- 4
  
  nn <- dim(gm[[N.g*N.m]]$ranks.mf)[2]
  p.length <- sum(!is.na(gm[[N.g*N.m]]$ranks.mf[,nn])) + sum(!is.na(run.out[[N.g]][[N.m]]$mess.ls$error)) + 1 # no ranks in trad ss
  
  gm.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$ranks.mf[,dim(g[[i]]$ranks.mf)[2]]))})}
  s <- matrix(gm.s(gm),nrow=N.m) # fills in down the columns, so for each grid, fills in row i with mesh i, following the output from e.s below
  e.s <- function(g){sapply(1:length(g),function(i){sum(!is.na(g[[i]]$mess.ls$error))})}
  s <- s + sapply(1:length(run.out),function(i){e.s(run.out[[i]])})
  ds <- diff(s)
  if (sum(ds)!=0){
    w <- which(ds!=0,arr.ind = T)
    grid.start.ind <- unname(w)[2]
    mesh.start.ind <- unname(w)[1] + 1
  } else if (sum(diff(t(s))!=0)){
    w <- which(diff(t(s))!=0,arr.ind=TRUE) # should be easy to extract the common row, then +1 to get the required GRID that needs to begin running...
    grid.start.ind <- unname(w)[1,1] + 1
    mesh.start.ind <- unname(w)[1,2]
  } else {
    grid.start.ind <- 1
    mesh.start.ind <- 1
  }
  
  
  print("Names gm")
  print(names(gm.old))
  print(names(gm))
  
  print(sum(names(gm.old)==names(gm)))
  print(sum(names(gm.old)!=names(gm)))
  
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length Message")
      lm <- length(run.out[[i]][[j]]$mess.ls$message)
      print(lm)
      print("Null Messages Counts")
      print(sum(sapply(1:lm,function(l){is.null(run.out.old[[i]][[j]]$mess.ls$message[[l]])})))
      print(sum(sapply(1:lm,function(l){is.null(run.out[[i]][[j]]$mess.ls$message[[l]])})))
    }
  }
  
  
  for (i in 1:4){
    for (j in 1:4){
      print("Length FFT")
      lm <- length(run.out[[i]][[j]]$mess.ls$FFT)
      print(lm)
      print("Length Error")
      lm2 <- length(run.out[[i]][[j]]$mess.ls$error)
      print(lm2)
      print("FFT Count")
      print(sum((run.out.old[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print(sum((run.out[[i]][[j]]$mess.ls$FFT),na.rm=TRUE))
      print("Warnings Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$warning)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$warning)))
      print("Errors Present")
      print(sum(!is.na(run.out.old[[i]][[j]]$mess.ls$error)))
      print(sum(!is.na(run.out[[i]][[j]]$mess.ls$error)))
    }
  }
  
  
  # CHECKS ####
  
  if (grid.start.ind==1&mesh.start.ind==1){ # for time error addition
    p.check <- p.length - 1
  } else {
    p.check <- p.length
  }
  
  print("Compare true.theta and seed.vec")
  print(sum(true.theta[1:p.check,]-true.theta.old[1:p.check,]))
  print(max(abs(true.theta[1:p.check,]-true.theta.old[1:p.check,])))
  print(sum(seed.vec[1:p.check]-seed.vec.old[1:p.check]))
  print(max(abs(seed.vec[1:p.check]-seed.vec.old[1:p.check])))
  
  print("data.err.tracker comparison")
  print(data.err.tracker)
  print(data.err.tracker.old)
  
  print("Sum and Max-Abs Different and sum is.na in est.df")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$est.df[1:replacement.max,] - run.out.old[[jj]][[ll]]$est.df[1:replacement.max,])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(is.na(run.out[[jj]][[ll]]$est.df)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$est.df)))
      print(sum(!is.na(run.out[[jj]][[ll]]$est.df)))
    }
  }
  
  print("Sum and Max-Abs difference in FFT")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      
      print(sum(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max],na.rm=TRUE))
      print(max(abs(run.out[[jj]][[ll]]$mess.ls$FFT[1:replacement.max] - run.out.old[[jj]][[ll]]$mess.ls$FFT[1:replacement.max])))
      
      print(sum(is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
      
      print(sum(!is.na(run.out.old[[jj]][[ll]]$mess.ls$FFT)))
      print(sum(!is.na(run.out[[jj]][[ll]]$mess.ls$FFT)))
    }
  }
  
  N.g <- 4; N.m <- 4
  
  print("Sum and Max-Abs difference in ranks.param")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.param[1:replacement.max,] - gm.old[[ind]]$ranks.param[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.param)))
      print(sum(is.na(gm[[ind]]$ranks.param)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.param)))
      print(sum(!is.na(gm[[ind]]$ranks.param)))
    }
  }
  
  print("Sum and Max-Abs difference in ranks.mf")
  for (jj in 1:4){
    for (ll in 1:4){
      if (jj <= grid.start.ind&ll<(mesh.start.ind-1)){
        replacement.max <- p.length
      } else {
        replacement.max <- p.length - 1
      }
      ind <- (jj-1)*N.m + ll
      
      print(sum(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,],na.rm=TRUE))
      print(max(abs(gm[[ind]]$ranks.mf[1:replacement.max,] - gm.old[[ind]]$ranks.mf[1:replacement.max,])))
      
      print(sum(is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(is.na(gm[[ind]]$ranks.mf)))
      
      print(sum(!is.na(gm.old[[ind]]$ranks.mf)))
      print(sum(!is.na(gm[[ind]]$ranks.mf)))
    }
  }
  
  for (i in 1:16){
    print(paste0("Dimension gm.old ", i))
    print(dim(gm.old[[i]]$ranks.param))
    print(dim(gm.old[[i]]$ranks.mf))
    print(paste0("Dimension gm ", i))
    print(dim(gm[[i]]$ranks.param))
    print(dim(gm[[i]]$ranks.mf))
  }
  
  
  
}

sink()

rm(list=ls())


# sessionInfo -------------------------------------------------------------

sessionInfo()
