
# Mean Field for Parameter Values that Produced Errors --------------------

# We want to consider the mean field produced from the parameter values that resulted in errors for some grid and mesh combinations in the SBC simulation study. We also consider the dame for those that produced more than 10 FFT warnings when inla was running.

# Author: Nadeen Khaleel

# Setwd and Load Libraries ------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(spatstat)


# SBC Simulation Study ----------------------------------------------------

# SBC: Parameters for Errors ----------------------------------------------
# What parameter values result in errors?

load("../REGPOLLGCP_OUTPUT/GridMeshRegPolLGCPSBCSS.rda")

err.vec <- rep(NA,50)
ii <- sum(!is.na(err.vec))
for (j in 1:4){
  for (l in 1:4){
    if (sum(!is.na(run.out.final[[j]][[l]]$mess.ls$err))!=0){
      err.vec[(ii+1):(ii+sum(!is.na(run.out.final[[j]][[l]]$mess.ls$err)))] <- which(!is.na(run.out.final[[j]][[l]]$mess.ls$err))
      ii <- sum(!is.na(err.vec))
    }
  }
}
err.vec
err.vec.u <- unique(err.vec[!is.na(err.vec)])
err.vec.u
true.theta.err <- true.theta.final[err.vec.u,]

true.theta.err
#       beta0      beta1      beta2      sigma        rho
# 161 5.6170809  2.3093989 -5.8250094 0.54585021  1.8254877
# 248 2.4355301  2.8701465 -3.2410960 1.69529131  0.8031148
# 394 6.6980592 -0.7587876  0.1397281 1.58728528  1.1568528
# 410 5.1884205  3.0261058 -3.4598686 0.79855442  2.3754683
# 728 2.5323118  4.4446914 -2.4113564 0.28220574  3.4507611
# 731 5.4009195  3.1367365  0.7298247 0.14370104  3.7873044
# 757 4.1582356  3.3818481 -5.7070794 0.02073316  6.8241352
# 943 5.1361004  3.3818029 -3.1148013 0.27676220  4.7582168
# 389 1.6445094  4.7078141 -1.6502605 1.02878585  1.6698629
# 857 3.9234286  4.0078501 -2.6475161 0.42165245  1.0850640
# 75  2.8029426  4.6193795  0.2206178 0.15035702  4.6993232
# 241 4.2986711 -3.7778596  0.7231732 2.01780521  0.6469251
# 826 5.1146103  3.8417749 -2.3321815 0.20299257  5.8179450
# 289 3.5147235  3.1818965 -4.2438330 2.25597531  2.9673282
# 533 0.9158253  4.6085138 -7.0756521 0.64105545 11.4216162
# 782 3.2124538  4.1520304  1.8060705 0.82976709  7.3554078
# 681 1.2770312  5.1128864 -3.6488128 0.38892739  1.5836669
# 670 6.2693263  1.2498801 -0.3502704 2.36882266  1.9038927

nrow(true.theta.err)


# SBC: Mean Field for Errors ----------------------------------------------
# What does the mean field look like for the runs which resulted in errors.

load("../REGPOLLGCP_CODE/GridMeshRegPolLGCPSSCov.rda")

max.mu <- rep(NA,nrow(true.theta.err))

for (k in 1:nrow(true.theta.err)){
  theta <- true.theta.err[k,]
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]];
  mu <- beta.0*int.im + beta.1*cov1.im + beta.2*cov2.im
  
  print("Values ",k)
  print(theta)
  print(max(mu$v))
  max.mu[k] <- max(mu$v)
  print(exp(max(mu$v)))
  print(mean(mu$v))
  print(median(mu$v))
  print(sum(mu$v>10)/length(mu$v))
  print(mean(exp(mu$v)))
}
# 

# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 161 5.617081 2.309399 -5.825009 0.5458502 1.825488
# [1] 16.90677
# [1] 22004820
# [1] 3.593496
# [1] 3.583237
# [1] 0.025136
# [1] 6235.104
# [1] "Values "
# beta0    beta1     beta2    sigma       rho
# 248 2.43553 2.870147 -3.241096 1.695291 0.8031148
# [1] 12.08576
# [1] 177329.5
# [1] 2.105886
# [1] 2.10359
# [1] 0.000288
# [1] 107.0841
# [1] "Values "
# beta0      beta1     beta2    sigma      rho
# 394 6.698059 -0.7587876 0.1397281 1.587285 1.156853
# [1] 8.193466
# [1] 3617.238
# [1] 6.393257
# [1] 6.39326
# [1] 0
# [1] 656.8788
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 410 5.188421 3.026106 -3.459869 0.7985544 2.375468
# [1] 15.38285
# [1] 4793893
# [1] 4.81755
# [1] 4.814406
# [1] 0.014752
# [1] 2237.267
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 728 2.532312 4.444691 -2.411356 0.2822057 3.450761
# [1] 16.26494
# [1] 11581780
# [1] 3.447127
# [1] 3.458812
# [1] 0.007824
# [1] 1445.758
# [1] "Values "
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# [1] 14.5743
# [1] 2135690
# [1] 7.375525
# [1] 7.370495
# [1] 0.085136
# [1] 9197.948
# [1] "Values "
# beta0    beta1     beta2      sigma      rho
# 757 4.158236 3.381848 -5.707079 0.02073316 6.824135
# [1] 17.36964
# [1] 34957351
# [1] 2.737843
# [1] 2.737801
# [1] 0.01672
# [1] 4966.934
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 943 5.1361 3.381803 -3.114801 0.2767622 4.758217
# [1] 16.17953
# [1] 10633585
# [1] 5.13251
# [1] 5.134436
# [1] 0.021552
# [1] 3276.441
# [1] "Values "
# beta0    beta1    beta2    sigma      rho
# 389 1.644509 4.707814 -1.65026 1.028786 1.669863
# [1] 15.77015
# [1] 7061352
# [1] 3.107484
# [1] 3.114886
# [1] 0.005664
# [1] 1033.018
# [1] "Values "
# beta0   beta1     beta2     sigma      rho
# 857 3.923429 4.00785 -2.647516 0.4216525 1.085064
# [1] 16.52621
# [1] 15039779
# [1] 4.489726
# [1] 4.497145
# [1] 0.015248
# [1] 2592.45
# [1] "Values "
# beta0    beta1     beta2    sigma      rho
# 75 2.802943 4.619379 0.2206178 0.150357 4.699323
# [1] 16.20638
# [1] 10922942
# [1] 5.244032
# [1] 5.239243
# [1] 0.03856
# [1] 5890.002
# [1] "Values "
# beta0    beta1     beta2    sigma       rho
# 241 4.298671 -3.77786 0.7231732 2.017805 0.6469251
# [1] 11.76248
# [1] 128345.7
# [1] 2.796147
# [1] 2.796425
# [1] 0.000352
# [1] 160.2483
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 826 5.11461 3.841775 -2.332182 0.2029926 5.817945
# [1] 17.09962
# [1] 26685260
# [1] 5.769829
# [1] 5.777159
# [1] 0.038592
# [1] 6198.007
# [1] "Values "
# beta0    beta1     beta2    sigma      rho
# 289 3.514723 3.181896 -4.243833 2.255975 2.967328
# [1] 14.62055
# [1] 2236796
# [1] 2.793633
# [1] 2.792573
# [1] 0.004992
# [1] 736.3619
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 533 0.9158253 4.608514 -7.075652 0.6410554 11.42162
# [1] 18.094
# [1] 72131756
# [1] -0.6363627
# [1] -0.6367128
# [1] 0.007696
# [1] 4529.019
# [1] "Values "
# beta0   beta1    beta2     sigma      rho
# 782 3.212454 4.15203 1.806071 0.8297671 7.355408
# [1] 16.38238
# [1] 13024948
# [1] 6.285313
# [1] 6.281565
# [1] 0.08576
# [1] 16422.9
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 681 1.277031 5.112886 -3.648813 0.3889274 1.583667
# [1] 17.48069
# [1] 39063272
# [1] 1.85117
# [1] 1.858121
# [1] 0.007392
# [1] 2168.167
# [1] "Values "
# beta0   beta1      beta2    sigma      rho
# 670 6.269326 1.24988 -0.3502704 2.368823 1.903893
# [1] 9.978728
# [1] 21562.86
# [1] 6.705752
# [1] 6.706246
# [1] 0
# [1] 1059.75




# mean(max.mu)
# [1] 15.0488

hist(max.mu,breaks=15)

for (k in 1:nrow(true.theta.err)){
  theta <- true.theta.err[k,]
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]];
  mu <- beta.0*int.im + beta.1*cov1.im + beta.2*cov2.im
  
  print(theta)
  print(sum(mu$v))
  print(sum(exp(mu$v)))
}
# beta0    beta1     beta2     sigma      rho
# 161 5.617081 2.309399 -5.825009 0.5458502 1.825488
# [1] 224593.5
# [1] 389693983
# beta0    beta1     beta2    sigma       rho
# 248 2.43553 2.870147 -3.241096 1.695291 0.8031148
# [1] 131617.9
# [1] 6692759
# beta0      beta1     beta2    sigma      rho
# 394 6.698059 -0.7587876 0.1397281 1.587285 1.156853
# [1] 399578.6
# [1] 41054926
# beta0    beta1     beta2     sigma      rho
# 410 5.188421 3.026106 -3.459869 0.7985544 2.375468
# [1] 301096.9
# [1] 139829212
# beta0    beta1     beta2     sigma      rho
# 728 2.532312 4.444691 -2.411356 0.2822057 3.450761
# [1] 215445.5
# [1] 90359862
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# [1] 460970.3
# [1] 574871735
# beta0    beta1     beta2      sigma      rho
# 757 4.158236 3.381848 -5.707079 0.02073316 6.824135
# [1] 171115.2
# [1] 310433356
# beta0    beta1     beta2     sigma      rho
# 943 5.1361 3.381803 -3.114801 0.2767622 4.758217
# [1] 320781.9
# [1] 204777592
# beta0    beta1    beta2    sigma      rho
# 389 1.644509 4.707814 -1.65026 1.028786 1.669863
# [1] 194217.8
# [1] 64563609
# beta0   beta1     beta2     sigma      rho
# 857 3.923429 4.00785 -2.647516 0.4216525 1.085064
# [1] 280607.9
# [1] 162028108
# beta0    beta1     beta2    sigma      rho
# 75 2.802943 4.619379 0.2206178 0.150357 4.699323
# [1] 327752
# [1] 368125113
# beta0    beta1     beta2    sigma       rho
# 241 4.298671 -3.77786 0.7231732 2.017805 0.6469251
# [1] 174759.2
# [1] 10015521
# beta0    beta1     beta2     sigma      rho
# 826 5.11461 3.841775 -2.332182 0.2029926 5.817945
# [1] 360614.3
# [1] 387375465
# beta0    beta1     beta2    sigma      rho
# 289 3.514723 3.181896 -4.243833 2.255975 2.967328
# [1] 174602
# [1] 46022616
# beta0    beta1     beta2     sigma      rho
# 533 0.9158253 4.608514 -7.075652 0.6410554 11.42162
# [1] -39772.67
# [1] 283063683
# beta0   beta1    beta2     sigma      rho
# 782 3.212454 4.15203 1.806071 0.8297671 7.355408
# [1] 392832.1
# [1] 1026431337
# beta0    beta1     beta2     sigma      rho
# 681 1.277031 5.112886 -3.648813 0.3889274 1.583667
# [1] 115698.1
# [1] 135510450
# beta0   beta1      beta2    sigma      rho
# 670 6.269326 1.24988 -0.3502704 2.368823 1.903893
# [1] 419109.5
# [1] 66234345


pdf("MeanFieldandExpMeanFieldforErr.pdf",height = 5, width=12.5)
for (k in 1:nrow(true.theta.err)){
  theta <- true.theta.err[k,]
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]];
  mu <- beta.0*int.im + beta.1*cov1.im + beta.2*cov2.im
  
  par(mfrow=c(1,2))
  plot(mu,main=paste0("mu for ",k))
  plot(exp(mu),paste0("exp(mu) for ",k))
}
dev.off()


# SBC: Parameters for FFT -------------------------------------------------
# What parameter values result in more than 10 FFT warnings.

err.vec <- rep(NA,200)
ii <- sum(!is.na(err.vec))
for (j in 1:4){
  for (l in 1:4){
    if (sum((run.out.final[[j]][[l]]$mess.ls$FFT)>10,na.rm=T)!=0){
      err.vec[(ii+1):(ii+sum((run.out.final[[j]][[l]]$mess.ls$FFT)>10,na.rm=T))] <- which((run.out.final[[j]][[l]]$mess.ls$FFT)>10)
      ii <- sum(!is.na(err.vec))
    }
  }
}
err.vec
err.vec.u <- unique(err.vec[!is.na(err.vec)])
err.vec.u
true.theta.err <- true.theta.final[err.vec.u,]

true.theta.err
# beta0    beta1     beta2    sigma      rho
# 289 3.514723 3.181896 -4.243833 2.255975 2.967328


nrow(true.theta.err)

# SBC: Mean Field for FFT -------------------------------------------------
# What does the mean field look like for the runs which resulted in more than 10 FFT warnings.
load("../REGPOLLGCP_CODE/GridMeshRegPolLGCPSSCov.rda")

max.mu <- rep(NA,nrow(true.theta.err))

for (k in 1:nrow(true.theta.err)){
  theta <- true.theta.err[k,]
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]];
  mu <- beta.0*int.im + beta.1*cov1.im + beta.2*cov2.im

  print("Values ")
  print(theta)
  print(max(mu$v))
  max.mu[k] <- max(mu$v)
  print(exp(max(mu$v)))
  print(mean(mu$v))
  print(median(mu$v))
  print(sum(mu$v>10)/length(mu$v))
  print(mean(exp(mu$v)))
}

# [1] "Values "
# beta0    beta1     beta2    sigma      rho
# 289 3.514723 3.181896 -4.243833 2.255975 2.967328
# [1] 14.62055
# [1] 2236796
# [1] 2.793633
# [1] 2.792573
# [1] 0.004992
# [1] 736.3619

sum(mu$v>12)
# [1] 30
# > exp(12)
# [1] 162754.8



# Time Error --------------------------------------------------------------
# Consider the data and mean field as well as parameter values that resulted in the time error. 
for (j in 1:4){
  for (l in 1:4){
    print(paste0("Grid ",j," and Mesh ",l))
    print(sum(!is.na(run.out.final[[j]][[l]]$mess.ls$warning)))
    print(which(!is.na(run.out.final[[j]][[l]]$mess.ls$warning)))
  }
}
# [1] "Grid 1 and Mesh 1"
# [1] 0
# integer(0)
# [1] "Grid 1 and Mesh 2"
# [1] 0
# integer(0)
# [1] "Grid 1 and Mesh 3"
# [1] 0
# integer(0)
# [1] "Grid 1 and Mesh 4"
# [1] 0
# integer(0)
# [1] "Grid 2 and Mesh 1"
# [1] 0
# integer(0)
# [1] "Grid 2 and Mesh 2"
# [1] 0
# integer(0)
# [1] "Grid 2 and Mesh 3"
# [1] 0
# integer(0)
# [1] "Grid 2 and Mesh 4"
# [1] 1
# [1] 290
# [1] "Grid 3 and Mesh 1"
# [1] 0
# integer(0)
# [1] "Grid 3 and Mesh 2"
# [1] 0
# integer(0)
# [1] "Grid 3 and Mesh 3"
# [1] 0
# integer(0)
# [1] "Grid 3 and Mesh 4"
# [1] 0
# integer(0)
# [1] "Grid 4 and Mesh 1"
# [1] 0
# integer(0)
# [1] "Grid 4 and Mesh 2"
# [1] 0
# integer(0)
# [1] "Grid 4 and Mesh 3"
# [1] 0
# integer(0)
# [1] "Grid 4 and Mesh 4"
# [1] 0
# integer(0)

run.out.final[[2]][[4]]$mess.ls$warning[290]
# [1] "TIME ERROR"

run.out.final[[2]][[4]]$est.df[290,]
# beta0  beta0.sd beta0.cil beta0.ciu      beta1 beta1.sd beta1.cil
# 290 1.739131 0.7191858 0.2759701  3.145655 -0.3499638 1.094689 -2.488902
# beta1.ciu     beta2 beta2.sd beta2.cil beta2.ciu   sigma  sigma.sd sigma.cil
# 290    1.8479 -3.806541 1.319446 -6.493419 -1.301712 1.21703 0.2923263  0.714029
# sigma.ciu      rho    rho.sd   rho.cil  rho.ciu sigma.mode  rho.mode
# 290   1.85571 1.035462 0.5323216 0.3737777 2.393963   1.156664 0.7240108

run.out.final[[2]][[4]]$run.df$time[290]
# [1] 268.042

theta <- true.theta.final[290,]
theta
# beta0    beta1     beta2     sigma      rho
# 290 -0.5053887 0.468092 -5.122585 0.3276106 1.026202


load("../REGPOLLGCP_CODE/GridMeshRegPolLGCPSSCov.rda")

max.mu <- rep(NA,nrow(theta))

for (k in 1:nrow(theta)){
  theta <- theta[k,]
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]];
  mu <- beta.0*int.im + beta.1*cov1.im + beta.2*cov2.im
  
  print("Values ",k)
  print(theta)
  print(max(mu$v))
  max.mu[k] <- max(mu$v)
  print(exp(max(mu$v)))
  print(mean(mu$v))
  print(median(mu$v))
  print(sum(mu$v>10)/length(mu$v))
  print(mean(exp(mu$v)))
}
# [1] "Values "
# beta0    beta1     beta2     sigma      rho
# 290 -0.5053887 0.468092 -5.122585 0.3276106 1.026202
# [1] 8.016146
# [1] 3029.479
# [1] -3.070026
# [1] -3.076711
# [1] 0
# [1] 1.918832

print(sum(mu$v>0)/length(mu$v))
# [1] 0.130704
print(sum(mu$v>0)/length(mu$v))

load("../REGPOLLGCP_OUTPUT/REGPOLGLGCP_OUTPUT_ERROR/temp_data33sbc_TIMEERROR1.rda")

for (j in 1:4){
  print(paste0("Grid ",j))
  print(max(data.sim$data[[j]]$count))
  print(min(data.sim$data[[j]]$count))
  print(mean(data.sim$data[[j]]$count))
  print(median(data.sim$data[[j]]$count))
  print(sd(data.sim$data[[j]]$count))
  print(sum(data.sim$data[[j]]$count==0)/nrow(data.sim$data[[j]]))
}
# [1] "Grid 1"
# [1] 6
# [1] 0
# [1] 0.39
# [1] 0
# [1] 0.8749603
# [1] 0.75
# [1] "Grid 2"
# [1] 5
# [1] 0
# [1] 0.0975
# [1] 0
# [1] 0.3979821
# [1] 0.9225
# [1] "Grid 3"
# [1] 4
# [1] 0
# [1] 0.0624
# [1] 0
# [1] 0.290243
# [1] 0.9456
# [1] "Grid 4"
# [1] 4
# [1] 0
# [1] 0.0156
# [1] 0
# [1] 0.1475308
# [1] 0.9864

max(data.sim$lambda$v)
# [1] 1333.495
min(data.sim$lambda$v)
# [1] 5.539234e-07
mean(data.sim$lambda$v)
# [1] 1.827851
median(data.sim$lambda$v)
# [1] 0.04743535
sd(data.sim$lambda$v)
# [1] 20.0928



# sessionInfo() -----------------------------------------------------------

sessionInfo()