# Parameters Causing Errors in SBC for Regular Polygon LGCP Grid Mesh

# Want to check the parameter values that resulted in errors for the Regular Polygon Grid-Mesh SBC simulation study.

# Author: Nadeen Khaleel

# Setwd and Load Libraries ------------------------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))


# Load SBC Output and Check Errors ----------------------------------------

load("../REGPOLLGCP_OUTPUT/GridMeshRegPolLGCPSBCSS.rda")

for (j in 1:4){
  print(paste0("Grid ",j))
  for (l in 1:4){
    print(paste0("Mesh ",l))
    err.tot.jl <- sum(!is.na(run.out.final[[j]][[l]]$mess.ls$error))
    if (err.tot.jl >0){
      data.ind <- which((!is.na(run.out.final[[j]][[l]]$mess.ls$error)))
      print("theta values for errors")
      for (i in 1:length(data.ind)){
        print(true.theta.final[data.ind[i],])
      }
    }
    
  }
}

# [1] "Grid 1"
# [1] "Mesh 1"
# [1] "theta values for errors"
# beta0    beta1     beta2     sigma      rho
# 161 5.617081 2.309399 -5.825009 0.5458502 1.825488
# beta0    beta1     beta2    sigma       rho
# 248 2.43553 2.870147 -3.241096 1.695291 0.8031148
# beta0      beta1     beta2    sigma      rho
# 394 6.698059 -0.7587876 0.1397281 1.587285 1.156853
# beta0    beta1     beta2     sigma      rho
# 410 5.188421 3.026106 -3.459869 0.7985544 2.375468
# beta0    beta1     beta2     sigma      rho
# 728 2.532312 4.444691 -2.411356 0.2822057 3.450761
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# beta0    beta1     beta2      sigma      rho
# 757 4.158236 3.381848 -5.707079 0.02073316 6.824135
# beta0    beta1     beta2     sigma      rho
# 943 5.1361 3.381803 -3.114801 0.2767622 4.758217
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0    beta1     beta2     sigma      rho
# 161 5.617081 2.309399 -5.825009 0.5458502 1.825488
# beta0    beta1     beta2    sigma       rho
# 248 2.43553 2.870147 -3.241096 1.695291 0.8031148
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# beta0    beta1     beta2     sigma      rho
# 943 5.1361 3.381803 -3.114801 0.2767622 4.758217
# [1] "Mesh 3"
# [1] "theta values for errors"
# beta0    beta1    beta2    sigma      rho
# 389 1.644509 4.707814 -1.65026 1.028786 1.669863
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# beta0   beta1     beta2     sigma      rho
# 857 3.923429 4.00785 -2.647516 0.4216525 1.085064
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0    beta1     beta2    sigma      rho
# 75 2.802943 4.619379 0.2206178 0.150357 4.699323
# beta0    beta1     beta2    sigma      rho
# 731 5.40092 3.136737 0.7298247 0.143701 3.787304
# beta0    beta1     beta2     sigma      rho
# 943 5.1361 3.381803 -3.114801 0.2767622 4.758217
# [1] "Grid 2"
# [1] "Mesh 1"
# [1] "Mesh 2"
# [1] "theta values for errors"
# beta0    beta1     beta2    sigma       rho
# 241 4.298671 -3.77786 0.7231732 2.017805 0.6469251
# beta0    beta1     beta2     sigma      rho
# 826 5.11461 3.841775 -2.332182 0.2029926 5.817945
# [1] "Mesh 3"
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0    beta1     beta2    sigma      rho
# 289 3.514723 3.181896 -4.243833 2.255975 2.967328
# [1] "Grid 3"
# [1] "Mesh 1"
# [1] "Mesh 2"
# [1] "Mesh 3"
# [1] "theta values for errors"
# beta0    beta1     beta2     sigma      rho
# 533 0.9158253 4.608514 -7.075652 0.6410554 11.42162
# beta0   beta1    beta2     sigma      rho
# 782 3.212454 4.15203 1.806071 0.8297671 7.355408
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0    beta1     beta2     sigma      rho
# 681 1.277031 5.112886 -3.648813 0.3889274 1.583667
# [1] "Grid 4"
# [1] "Mesh 1"
# [1] "Mesh 2"
# [1] "Mesh 3"
# [1] "Mesh 4"
# [1] "theta values for errors"
# beta0   beta1      beta2    sigma      rho
# 670 6.269326 1.24988 -0.3502704 2.368823 1.903893


# sessionInfo -------------------------------------------------------------

sessionInfo()
