
# Plotting for Regular Polygon --------------------------------------------

# In addition to SimulateRegPol_final.R in the REGPOLLGCP_CODE_TESTINGVALUES sub-directory this R script loads and plots the grids, covariates, gridded covariates and meshes for the LGCP Regular Polygon example for the Grid-Mesh Optimisation method.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

library("rstudioapi")
# Either setwd() to the source file location, or run the following:
setwd(dirname(getActiveDocumentContext()$path))

library(INLA)
library(spatstat)
library(sp)
library(sf)
library(maptools)


# Load Regular Polygon Data -----------------------------------------------

load("QuadratsRegPolLGCP.rda")
load("CoordsRegPolLGCP.rda")
load("MeshesRegPolLGCP.rda")
load("CovAggGridRegPolLGCP.rda")
load("GridMeshRegPolLGCPSSCov.rda")


# Create Gridded Covariates -----------------------------------------------

data.list <- vector(mode="list",length=length(quad.list))
for (i in 1:length(quad.list)){
  g <- quad.list[[i]]
  g.sp <- as(g,"SpatialPolygons")
  g.sp$cov1 <- cov1grid.list[[i]]
  g.sp$cov2 <- cov2grid.list[[i]]
  
  data.list[[i]] <- st_as_sf(g.sp)
}


# Plotting ----------------------------------------------------------------

# Quadrats and Centres
dim <- c("1010","2020","2525","5050")
for (i in 1:length(quad.list)){
  save.file <- paste0("QuadratRegPolLGCP",dim[i],".pdf")
  pdf(save.file,height = 15,w=15,pointsize = 14)
  plot(quad.list[[i]],main="")
  dev.off()
  save.file.p <- paste0("QuadratwPointsRegPolLGCP",dim[i],".pdf")
  pdf(save.file.p,height = 15,w=15,pointsize = 14)
  plot(quad.list[[i]],main="")
  points(coord.list[[i]],pch=19)
  dev.off()
}


# Covariates
dim <- c("1010","2020","2525","5050")
for (i in 1:length(quad.list)){
  save.file <- paste0("CovariatesRegPolLGCP",dim[i],".pdf")
  pdf(save.file,height = 15,w=15,pointsize = 14)
  plot(data.list[[i]]["cov1"],main="Covariate 1")
  plot(data.list[[i]]["cov2"],main="Covariate 2")
  dev.off()
}


# Meshes
dim <- c("1010","2020","2525","5050")
for (i in 1:length(quad.list)){
  save.file <- paste0("MeshRegPolLGCP",dim[i],".pdf")
  pdf(save.file,height = 15,w=15,pointsize = 14)
  plot(mesh.list[[i]],main="")
  dev.off()
  save.file.p <- paste0("MeshwPointsRegPolLGCP",dim[i],".pdf")
  pdf(save.file.p,height = 15,w=15,pointsize = 14)
  plot(mesh.list[[i]],main="")
  points(coord.list[[i]],col="red",pch=19)
  dev.off()
}


# Covariate Images

pdf("CovariatesRegPolLGCP.pdf",height=15,width=15,pointsize = 14)
plot(cov1.im,main="Covariate 1")
plot(cov2.im,main="Covariate 2")
dev.off()



# sessionInfo() -----------------------------------------------------------

sessionInfo()