
# Simulate and Plot LGCP on Regular Polygon -------------------------------

# Want to simulate and plot the LGCPs simulated from the final selection of values of the parameters, that will be used within the traditional simulation study.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

library("rstudioapi")
# Either setwd() to the source file location, or run the following:
setwd(dirname(getActiveDocumentContext()$path))

library(spatstat)
library(raster)
library(sf)
library(sp)
library(maptools)
library(rgdal)
library(lwgeom)
library(RandomFields)


# Set-Up ------------------------------------------------------------------
# Set-up the window and covariates

# Set-up window
W <- owin(c(0,5),c(0,5))

# Get Covariates and Grids
cov.name <- "GridMeshRegPolLGCPSSCov.rda"
load(cov.name)
quad.name <- "QuadratsRegPolLGCP.rda"
load(quad.name)
coord.file <- "CoordsRegPolLGCP.rda"
load(coord.file)

# Set Parameter Values
theta <- list("beta0"=2,"beta1"=1,"beta2"=-2,"sigma"=1,"rho"=1.5)
i.im <- int.im; c1.im <- cov1.im; c2.im <- cov2.im

beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]]; sigma <- theta[[4]]; rho <- theta[[5]];
# Generate fixed mean field
mu <- beta.0*i.im + beta.1*c1.im + beta.2*c2.im


# Simulate Data -----------------------------------------------------------
# Simulate the LGCPs and produce plots for the point patterns as well as the aggregated count data.

for (i in 1:3){
  set.seed(125*i+1)
  lgcp.ppp <- try(rLGCP(model="matern",mu,var=(sigma)^2,scale=rho/2,nu=1,win = W))
  
  pdf(paste0("RegPolSimulatedDataSet",i,".pdf"),h=20,w=20,pointsize = 14)
  
  plot(lgcp.ppp)
  
  g1 <- as.vector(unname(quadratcount(lgcp.ppp,tess=quad.list$quad1010)))
  g1.sp <- as(quad.list$quad1010[ord.list[[1]]$ind],"SpatialPolygons")
  g1.sf <- st_as_sf(g1.sp)
  g1.sf$count <- g1
  
  plot(g1.sf,main=paste0("Simulated Data ",i, " on 10x10 Grid"))
  
  g2 <- as.vector(unname(quadratcount(lgcp.ppp,tess=quad.list$quad2020)))
  g2.sp <- as(quad.list$quad2020[ord.list[[2]]$ind],"SpatialPolygons")
  g2.sf <- st_as_sf(g2.sp)
  g2.sf$count <- g2
  
  plot(g2.sf,main=paste0("Simulated Data ",i, " on 20x20 Grid"))
  
  g3 <- as.vector(unname(quadratcount(lgcp.ppp,tess=quad.list$quad2525)))
  g3.sp <- as(quad.list$quad2525[ord.list[[3]]$ind],"SpatialPolygons")
  g3.sf <- st_as_sf(g3.sp)
  g3.sf$count <- g3
  
  plot(g3.sf,main=paste0("Simulated Data ",i, " on 25x25 Grid"))
  
  g4 <- as.vector(unname(quadratcount(lgcp.ppp,tess=quad.list$quad5050)))
  g4.sp <- as(quad.list$quad5050[ord.list[[4]]$ind],"SpatialPolygons")
  g4.sf <- st_as_sf(g4.sp)
  g4.sf$count <- g4
  
  plot(g4.sf,main=paste0("Simulated Data ",i, " on 50x50 Grid"))
  
  
  dev.off()
  
} 



# sessionInfo() -----------------------------------------------------------

sessionInfo()