
# Testing Fixed Theta Values: Regular Polygon -----------------------------

# Quickly assessing the behaviour of the data simulation for different values of the fixed theta for the LGCP regular polygon Grid-Mesh Optimisation example.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

library("rstudioapi")
# Either setwd() to the source file location, or run the following:
setwd(dirname(getActiveDocumentContext()$path))

library(spatstat)
library(raster)
library(sf)
library(sp)
library(maptools)
library(rgdal)
library(lwgeom)
library(RandomFields)


# Set-up ------------------------------------------------------------------
# We will set up the window and covariates and then create a small function that will take these and user-provided parameter values to simulate lgcps over the window with the intention of testing the number of point simulated and the behaviour of the field.

W <- owin(c(0,5),c(0,5))

cov.name <- paste0("GridMeshRegPolLGCPSSCov.rda")
load(cov.name)
i.im <- int.im; c1.im <- cov1.im; c2.im <- cov2.im

# Function to simulate lgcps using the above covariates and window for a given set of parameter values, theta.
n.theta <- function(theta,n=10,i.im,c1.im,c2.im){
  beta.0 <- theta[[1]]; beta.1 <- theta[[2]]; beta.2 <- theta[[3]]; sigma <- theta[[4]]; rho <- theta[[5]];
  
  mu <- beta.0*i.im + beta.1*c1.im + beta.2*c2.im
  
  n.vec <- rep(NA,n)
  for (i in 1:n){
    lgcp.ppp <- try(rLGCP(model="matern",mu,var=(sigma)^2,scale=rho/2,nu=1,win = W))
    n.vec[i] <- lgcp.ppp$n
  }
  
  return(list("n"=n.vec,"mu"=mu$v))
}

# Testing Values ----------------------------------------------------------
# We will now use the set-up above to test different values for the parameters, checking the behaivour of the number of points simulated. Final choice results can be found under: theta12.

set.seed(125)
theta1 <- data.frame(beta0=1,beta1=2,beta2=-2,sigma=1,rho=1.5)
theta.n1 <- n.theta(theta=theta1,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n1$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 114.00 175.00 221.00 283.00 356.50 463.00 599.18 
quantile(theta.n1$mu)
# 0%         25%         50%         75%        100% 
# -4.69687943 -0.08458427  0.91146702  1.90919456  7.60445670 


theta2 <- data.frame(beta0=1,beta1=-2,beta2=2,sigma=1,rho=1.5)
theta.n2 <- n.theta(theta=theta2,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n2$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 160.90 222.00 272.75 349.50 433.50 524.00 730.09 
quantile(theta.n2$mu)
# 0%         25%         50%         75%        100% 
# -5.60445670  0.09080544  1.08853298  2.08458427  6.69687943


theta3 <- data.frame(beta0=1,beta1=-2,beta2=2,sigma=2,rho=1)
theta.n3 <- n.theta(theta=theta3,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n3$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 388.97  656.00  910.25 1310.50 1903.50 2593.30 6975.72 
quantile(theta.n3$mu)
# 0%         25%         50%         75%        100% 
# -5.60445670  0.09080544  1.08853298  2.08458427  6.69687943 


theta4 <- data.frame(beta0=1,beta1=-1,beta2=1,sigma=2,rho=1)
theta.n4 <- n.theta(theta=theta4,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n4$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 154.99  269.70  400.00  580.50  902.50 1341.20 3010.34 
quantile(theta.n4$mu)
# 0%        25%        50%        75%       100% 
# -2.3022283  0.5454027  1.0442665  1.5422921  3.8484397 

theta5 <- data.frame(beta0=1,beta1=-1,beta2=1,sigma=2,rho=1.5)
theta.n5 <- n.theta(theta=theta5,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n5$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 112.92  190.00  273.75  476.50  793.00 1319.70 3569.49 
quantile(theta.n5$mu)
# 0%        25%        50%        75%       100% 
# -2.3022283  0.5454027  1.0442665  1.5422921  3.8484397

theta6 <- data.frame(beta0=1,beta1=1,beta2=-1,sigma=2,rho=1.5)
theta.n6 <- n.theta(theta=theta6,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n6$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 95.99  182.00  270.00  458.50  742.50 1291.40 4309.33 
quantile(theta.n6$mu)
# 0%        25%        50%        75%       100% 
# -1.8484397  0.4577079  0.9557335  1.4545973  4.3022283 

theta7 <- data.frame(beta0=1,beta1=1,beta2=-1,sigma=1.5,rho=1.5)
theta.n7 <- n.theta(theta=theta7,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n7$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 67.97 114.90 160.75 218.00 325.00 453.30 884.09 
quantile(theta.n7$mu)
# 0%        25%        50%        75%       100% 
# -1.8484397  0.4577079  0.9557335  1.4545973  4.3022283 


theta8 <- data.frame(beta0=2,beta1=1,beta2=-1,sigma=1.5,rho=1.5)
theta.n8 <- n.theta(theta=theta8,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n8$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 188.97  307.90  418.75  573.00  837.50 1185.30 2313.39 
# 1%     10%     25%     50%     75%     90%     99% 
# 186.99  328.00  455.75  643.00  913.75 1303.20 2266.38 
quantile(theta.n8$mu)
# 0%        25%        50%        75%       100% 
# -0.8484397  1.4577079  1.9557335  2.4545973  5.3022283
# 0%        25%        50%        75%       100% 
# -0.8484397  1.4577079  1.9557335  2.4545973  5.3022283  
# 100% 
# 5.3022283 

theta9 <- data.frame(beta0=1,beta1=-1,beta2=1,sigma=1.5,rho=1.5)
theta.n9 <- n.theta(theta=theta9,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n9$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 77.00 122.90 164.75 231.00 347.25 489.50 861.12 
quantile(theta.n9$mu)
# 0%        25%        50%        75%       100% 
# -2.3022283  0.5454027  1.0442665  1.5422921  3.8484397 


theta10 <- data.frame(beta0=2,beta1=1,beta2=-2,sigma=1.5,rho=1.5)
theta.n10 <- n.theta(theta=theta10,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n10$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 131.99  266.80  383.75  528.50  732.00 1057.60 2083.57 
# 1%     10%     25%     50%     75%     90%     99% 
# 135.95  249.00  355.75  525.50  788.25 1111.50 2017.27 
quantile(theta.n10$mu)
# 0%        25%        50%        75%       100% 
# -3.3798112  0.6274499  1.4099340  2.1849055  6.2741259 

theta10a <- data.frame(beta0=2,beta1=1,beta2=-2,sigma=1.5,rho=1.5)
theta.n10a <- n.theta(theta=theta10a,n=1e3,i.im,c1.im,c2.im)
quantile(theta.n10a$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%     10%     25%     50%     75%     90%     99% 
# 167.99  259.00  351.75  509.00  746.50 1068.40 2016.62
# 1%     10%     25%     50%     75%     90%     99% 
# 161.00  269.80  376.25  525.00  777.50 1081.20 2507.77 
quantile(theta.n10a$mu)
# 0%        25%        50%        75%       100% 
# -3.3798112  0.6274499  1.4099340  2.1849055  6.2741259 


theta11 <- data.frame(beta0=1,beta1=1,beta2=-2,sigma=1.5,rho=1.5)
theta.n11 <- n.theta(theta=theta11,n=5e2,i.im,c1.im,c2.im)
quantile(theta.n11$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 56.96  87.90 127.75 188.00 274.50 378.10 888.14
quantile(theta.n11$mu)
# 0%        25%        50%        75%       100% 
# -4.3798112 -0.3725501  0.4099340  1.1849055  5.2741259 

theta11a <- data.frame(beta0=1,beta1=1,beta2=-2,sigma=1.5,rho=1.5)
theta.n11a <- n.theta(theta=theta11a,n=1e3,i.im,c1.im,c2.im)
quantile(theta.n11a$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99% 
# 53.99  98.00 133.00 203.00 288.00 390.00 723.12 
quantile(theta.n11a$mu)
# 0%        25%        50%        75%       100% 
# -4.3798112 -0.3725501  0.4099340  1.1849055  5.2741259 

theta12 <- data.frame(beta0=2,beta1=1,beta2=-2,sigma=1,rho=1.5)
theta.n12 <- n.theta(theta=theta12,n=1e3,i.im,c1.im,c2.im)
quantile(theta.n12$n,c(0.01,0.1,0.25,0.5,0.75,0.9,0.99))
# 1%    10%    25%    50%    75%    90%    99%  5e2
# 145.97 203.00 237.75 301.50 387.00 463.10 636.09  5e2
# 1%    10%    25%    50%    75%    90%    99% 
# 135.98 192.00 240.75 307.50 384.25 473.10 706.23 
quantile(theta.n12$mu)
# 0%        25%        50%        75%       100%  5e2
# -3.3798112  0.6274499  1.4099340  2.1849055  6.2741259



# sessionInfo() -----------------------------------------------------------

sessionInfo() 
