
# Prior Values Test for Rho -----------------------------------------------

# This script will calculate the average median or mean values for the covariance priors to assess what the behaviour for the simulated parameter for different values to take into considerations for the Grid-Mesh Optimisation data simulations.

# Author: Nadeen Khaleel

# Simulation Functions ----------------------------------------------------
# Functions to simulate for the range parameter, rho, considering the PC prior.

rho.sim <- function(n,rho.star){
  alpha.rho <- rho.star[2]; rho.0 <- rho.star[1]
  u1 <- runif(n,0,1)
  rho <- rho.0*log(alpha.rho)/log(u1)
}


# Simulations -------------------------------------------------------------
# Simulate rho for different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- seq(0.5,5,by=0.5); alpha.rho.vals <- seq(0.05,0.95,by=0.1)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


image(rho.0.vals,alpha.rho.vals,matrix(rho.medians,ncol=10))


# Lets consider, for interest values that allow the median rho simulated to be between 2 and 4
medianr.df <- median.df[median.df$medians>2,]
medianr.df <- medianr.df[medianr.df$medians<4,]
meanr.df <- mean.df[as.numeric(row.names(medianr.df)),]

sub.df <- medianr.df
sub.df$means <- meanr.df$means
sub.df

# sub.df
# rho.0 alpha.rho  medians     means
# 1    0.5      0.05 2.156777  48.00893
# 12   1.0      0.15 2.738260  26.40787
# 23   1.5      0.25 3.004571  30.98809
# 24   2.0      0.25 3.998968  45.64163
# 33   1.5      0.35 2.267743  29.85792
# 34   2.0      0.35 3.032305  32.77644
# 35   2.5      0.35 3.785585  53.89673
# 44   2.0      0.45 2.306479  20.83278
# 45   2.5      0.45 2.886307  30.24803
# 46   3.0      0.45 3.459587 138.60756
# 55   2.5      0.55 2.163975  24.09726
# 56   3.0      0.55 2.588677  26.24751
# 57   3.5      0.55 3.024701  27.98324
# 58   4.0      0.55 3.446250  34.46792
# 59   4.5      0.55 3.892204  65.59798
# 67   3.5      0.65 2.173471  21.26037
# 68   4.0      0.65 2.487429  20.84294
# 69   4.5      0.65 2.794668  33.32900
# 70   5.0      0.65 3.115450  29.44371
# 80   5.0      0.75 2.071463  28.20642


# Simulations: Take 2 -----------------------------------------------------
# Simulate rho for another group of different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- seq(0.05,0.5,by=0.01); alpha.rho.vals <- seq(0.05,0.95,by=0.1)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


image(rho.0.vals,alpha.rho.vals,matrix(rho.medians,ncol=10))

# Lets consider, for interest values that allow the median rho simulated to be between 0.25 and 4
medianr.df <- median.df[median.df$medians>0.25,]
medianr.df <- medianr.df[medianr.df$medians<0.4,]
meanr.df <- mean.df[as.numeric(row.names(medianr.df)),]

sub.df <- medianr.df
sub.df$means <- meanr.df$means
sub.df

# sub.df
#     rho.0 alpha.rho   medians     means
# 2    0.06      0.05 0.2590873 10.217808
# 3    0.07      0.05 0.3029427  2.786935
# 4    0.08      0.05 0.3451042  3.947185
# 5    0.09      0.05 0.3886491  3.532555
# 52   0.10      0.15 0.2735117  2.421760
# 53   0.11      0.15 0.3007609  3.230922
# 54   0.12      0.15 0.3282496  3.795286
# 55   0.13      0.15 0.3556106  5.133785
# 56   0.14      0.15 0.3839900  4.971467
# 101  0.13      0.25 0.2599981  2.244439
# 102  0.14      0.25 0.2796765  2.561793
# 103  0.15      0.25 0.2994893  3.425339
# 104  0.16      0.25 0.3201099  3.045922
# 105  0.17      0.25 0.3404377  4.041370
# 106  0.18      0.25 0.3597446  3.461611
# 107  0.19      0.25 0.3801230  4.771976
# 108  0.20      0.25 0.3997975  3.907133
# 151  0.17      0.35 0.2578586  2.394978
# 152  0.18      0.35 0.2717814  2.760767
# 153  0.19      0.35 0.2876440  2.477246
# 154  0.20      0.35 0.3025456  7.576328
# 155  0.21      0.35 0.3174764  3.817196
# 156  0.22      0.35 0.3330416  8.614199
# 157  0.23      0.35 0.3486440  4.285473
# 158  0.24      0.35 0.3645322  3.588166
# 159  0.25      0.35 0.3783245  3.821676
# 160  0.26      0.35 0.3932381  3.192514
# 202  0.22      0.45 0.2532395  2.092141
# 203  0.23      0.45 0.2655517  2.664408
# 204  0.24      0.45 0.2767598  4.180960
# 205  0.25      0.45 0.2881987  7.894537
# 206  0.26      0.45 0.2998584  3.439740
# 207  0.27      0.45 0.3109714  6.057301
# 208  0.28      0.45 0.3227437  2.915334
# 209  0.29      0.45 0.3331797  3.683159
# 210  0.30      0.45 0.3462932  3.783893
# 211  0.31      0.45 0.3560800  5.170757
# 212  0.32      0.45 0.3688751  3.941112
# 213  0.33      0.45 0.3798795  6.820252
# 214  0.34      0.45 0.3915605  5.440695
# 256  0.30      0.55 0.2592863  3.266173
# 257  0.31      0.55 0.2670617  2.548549
# 258  0.32      0.55 0.2764082  2.774415
# 259  0.33      0.55 0.2841422  2.336240
# 260  0.34      0.55 0.2935192  2.435180
# 261  0.35      0.55 0.3014889  2.955401
# 262  0.36      0.55 0.3105545  2.784094
# 263  0.37      0.55 0.3197652  2.878127
# 264  0.38      0.55 0.3271220  2.773157
# 265  0.39      0.55 0.3352677 13.764680
# 266  0.40      0.55 0.3458697  4.905398
# 267  0.41      0.55 0.3531345  3.229215
# 268  0.42      0.55 0.3629000  3.531822
# 269  0.43      0.55 0.3705799  3.447914
# 270  0.44      0.55 0.3796926  3.086311
# 271  0.45      0.55 0.3880986  5.234322
# 272  0.46      0.55 0.3966063  8.496799
# 313  0.41      0.65 0.2546627  3.105400
# 314  0.42      0.65 0.2615269  2.532960
# 315  0.43      0.65 0.2676234  2.682109
# 316  0.44      0.65 0.2728415  3.034259
# 317  0.45      0.65 0.2795278  2.886604
# 318  0.46      0.65 0.2855748  2.883630
# 319  0.47      0.65 0.2924999 18.782582
# 320  0.48      0.65 0.2984028  3.160463
# 321  0.49      0.65 0.3041220  2.834403
# 322  0.50      0.65 0.3110494  8.811785



# Simulations: Take 3 -----------------------------------------------------
# Simulate rho for another group of different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- seq(0.05,2,by=0.1); alpha.rho.vals <- seq(0.01,0.25,by=0.01)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


image(rho.0.vals,alpha.rho.vals,matrix(rho.medians,ncol=10))

# Lets consider, for interest values that allow the median rho simulated to be between 0.25 and 2.5
medianr.df <- median.df[median.df$medians>0.25,]
medianr.df <- medianr.df[medianr.df$medians<2.5,]
meanr.df <- mean.df[as.numeric(row.names(medianr.df)),]

sub.df <- medianr.df
sub.df$means <- meanr.df$means
sub.df

# sub.df
# rho.0 alpha.rho   medians      means
# 1    0.05      0.01 0.3317213   2.833515
# 2    0.15      0.01 0.9964936  10.918768
# 3    0.25      0.01 1.6651530  18.425902
# 4    0.35      0.01 2.3274933  21.454921
# 21   0.05      0.02 0.2817608   2.666718
# 22   0.15      0.02 0.8478624   7.292095
# 23   0.25      0.02 1.4107512  14.942315
# 24   0.35      0.02 1.9745146  28.925841
# 41   0.05      0.03 0.2536470   2.833745
# 42   0.15      0.03 0.7602398   7.472004
# 43   0.25      0.03 1.2638796  10.963609
# 44   0.35      0.03 1.7777906  16.066910
# 45   0.45      0.03 2.2761970  29.028486
# 62   0.15      0.04 0.6956236  15.000841
# 63   0.25      0.04 1.1618470  11.046849
# 64   0.35      0.04 1.6255356  17.173407
# 65   0.45      0.04 2.0891926  20.617802
# 82   0.15      0.05 0.6493695   7.182920
# 83   0.25      0.05 1.0815069  17.100246
# 84   0.35      0.05 1.5095714  13.194832
# 85   0.45      0.05 1.9471168  17.658851
# 86   0.55      0.05 2.3826319  34.599956
# 102  0.15      0.06 0.6080169   5.310154
# 103  0.25      0.06 1.0142271   9.767687
# 104  0.35      0.06 1.4215463  12.029109
# 105  0.45      0.06 1.8267050  15.734403
# 106  0.55      0.06 2.2367000  28.871823
# 122  0.15      0.07 0.5738330   5.046755
# 123  0.25      0.07 0.9604065  30.332688
# 124  0.35      0.07 1.3438347  14.209405
# 125  0.45      0.07 1.7244052  23.950450
# 126  0.55      0.07 2.1086945  21.420012
# 127  0.65      0.07 2.4956595  23.712265
# 142  0.15      0.08 0.5469115   7.279575
# 143  0.25      0.08 0.9137131  11.371910
# 144  0.35      0.08 1.2750738  10.591138
# 145  0.45      0.08 1.6423510  16.653708
# 146  0.55      0.08 2.0020210  29.565123
# 147  0.65      0.08 2.3711582  22.686942
# 162  0.15      0.09 0.5208547   4.276996
# 163  0.25      0.09 0.8715114  10.110202
# 164  0.35      0.09 1.2134826  11.953221
# 165  0.45      0.09 1.5668030  15.088199
# 166  0.55      0.09 1.9139275  17.586251
# 167  0.65      0.09 2.2598172  21.232238
# 182  0.15      0.10 0.4987564   4.955027
# 183  0.25      0.10 0.8287326  17.933424
# 184  0.35      0.10 1.1629854  10.659475
# 185  0.45      0.10 1.4952677  17.085301
# 186  0.55      0.10 1.8250105  16.055756
# 187  0.65      0.10 2.1539518  23.017052
# 188  0.75      0.10 2.4883194  40.990551
# 202  0.15      0.11 0.4768732   3.747451
# 203  0.25      0.11 0.7951076   8.146426
# 204  0.35      0.11 1.1142686  14.378883
# 205  0.45      0.11 1.4319350  14.683958
# 206  0.55      0.11 1.7501123  15.799770
# 207  0.65      0.11 2.0684363  19.105474
# 208  0.75      0.11 2.3891563  33.417277
# 222  0.15      0.12 0.4596268   5.597213
# 223  0.25      0.12 0.7658356   7.235950
# 224  0.35      0.12 1.0728080  12.517061
# 225  0.45      0.12 1.3777340  12.999612
# 226  0.55      0.12 1.6852469  25.704288
# 227  0.65      0.12 1.9914852  22.242602
# 228  0.75      0.12 2.2939281  19.395731
# 242  0.15      0.13 0.4418897  64.165161
# 243  0.25      0.13 0.7369789   8.755231
# 244  0.35      0.13 1.0321254   9.028086
# 245  0.45      0.13 1.3254956  12.393775
# 246  0.55      0.13 1.6207901  23.027707
# 247  0.65      0.13 1.9106789  18.564623
# 248  0.75      0.13 2.2087315  20.663618
# 262  0.15      0.14 0.4257315   4.436695
# 263  0.25      0.14 0.7100818   7.181881
# 264  0.35      0.14 0.9933357  20.562222
# 265  0.45      0.14 1.2766831  13.036429
# 266  0.55      0.14 1.5602790  15.561453
# 267  0.65      0.14 1.8441797  15.880318
# 268  0.75      0.14 2.1280107  18.126142
# 269  0.85      0.14 2.4117164  23.030818
# 282  0.15      0.15 0.4110791   3.682988
# 283  0.25      0.15 0.6846626   7.400291
# 284  0.35      0.15 0.9588670  10.013499
# 285  0.45      0.15 1.2341176  16.197498
# 286  0.55      0.15 1.5053454  22.081074
# 287  0.65      0.15 1.7819528  32.514033
# 288  0.75      0.15 2.0548979  18.064167
# 289  0.85      0.15 2.3293220  29.449815
# 302  0.15      0.16 0.3961129   3.331163
# 303  0.25      0.16 0.6600562   6.155367
# 304  0.35      0.16 0.9250974 114.204323
# 305  0.45      0.16 1.1894197  20.902067
# 306  0.55      0.16 1.4568952  20.827560
# 307  0.65      0.16 1.7231550  15.950662
# 308  0.75      0.16 1.9806427  17.932716
# 309  0.85      0.16 2.2514900  28.532432
# 322  0.15      0.17 0.3834798   4.064597
# 323  0.25      0.17 0.6377113   6.623875
# 324  0.35      0.17 0.8932264   8.829814
# 325  0.45      0.17 1.1495627  11.759049
# 326  0.55      0.17 1.4079584  87.248558
# 327  0.65      0.17 1.6621055  14.344617
# 328  0.75      0.17 1.9198513  17.935021
# 329  0.85      0.17 2.1709869  21.242978
# 330  0.95      0.17 2.4252266  29.117496
# 342  0.15      0.18 0.3706071   3.794274
# 343  0.25      0.18 0.6184479   7.585316
# 344  0.35      0.18 0.8656386  12.281601
# 345  0.45      0.18 1.1149465   9.983820
# 346  0.55      0.18 1.3600302  14.943745
# 347  0.65      0.18 1.6114385  15.245981
# 348  0.75      0.18 1.8578520  17.568234
# 349  0.85      0.18 2.1044337  36.789892
# 350  0.95      0.18 2.3533504  22.827680
# 362  0.15      0.19 0.3591106   3.170353
# 363  0.25      0.19 0.6004538  65.617514
# 364  0.35      0.19 0.8379929  37.042616
# 365  0.45      0.19 1.0769594  10.411851
# 366  0.55      0.19 1.3167169  12.287512
# 367  0.65      0.19 1.5547681  18.507544
# 368  0.75      0.19 1.7898843  33.422819
# 369  0.85      0.19 2.0387105  29.862692
# 370  0.95      0.19 2.2776699  32.689312
# 382  0.15      0.20 0.3488342   4.371270
# 383  0.25      0.20 0.5788511   5.190023
# 384  0.35      0.20 0.8108197  25.392567
# 385  0.45      0.20 1.0457854   9.561481
# 386  0.55      0.20 1.2751770  15.709051
# 387  0.65      0.20 1.5072251  20.364296
# 388  0.75      0.20 1.7432988  22.471461
# 389  0.85      0.20 1.9706335  20.105410
# 390  0.95      0.20 2.2044128  29.302306
# 391  1.05      0.20 2.4374058  23.035471
# 402  0.15      0.21 0.3375458   5.089546
# 403  0.25      0.21 0.5632324   6.543887
# 404  0.35      0.21 0.7890869   7.707778
# 405  0.45      0.21 1.0163134   9.827455
# 406  0.55      0.21 1.2406699  13.107019
# 407  0.65      0.21 1.4632693  19.645490
# 408  0.75      0.21 1.6876076  16.459804
# 409  0.85      0.21 1.9146456  19.582399
# 410  0.95      0.21 2.1417535  20.323089
# 411  1.05      0.21 2.3695470  19.570661
# 422  0.15      0.22 0.3275548   7.347861
# 423  0.25      0.22 0.5462366   4.755287
# 424  0.35      0.22 0.7654430   7.289871
# 425  0.45      0.22 0.9834658  15.730738
# 426  0.55      0.22 1.2025715  19.612379
# 427  0.65      0.22 1.4196823  14.744189
# 428  0.75      0.22 1.6389098  27.515782
# 429  0.85      0.22 1.8598451  44.051656
# 430  0.95      0.22 2.0773623  29.561462
# 431  1.05      0.22 2.2920115  20.177677
# 442  0.15      0.23 0.3179912   2.948457
# 443  0.25      0.23 0.5294509   4.848423
# 444  0.35      0.23 0.7442315   6.520554
# 445  0.45      0.23 0.9542385  13.204029
# 446  0.55      0.23 1.1669357  11.230970
# 447  0.65      0.23 1.3784260  14.010006
# 448  0.75      0.23 1.5874576  15.467987
# 449  0.85      0.23 1.7997451  23.781964
# 450  0.95      0.23 2.0166957  19.427356
# 451  1.05      0.23 2.2210726  20.843911
# 452  1.15      0.23 2.4377463  33.698234
# 462  0.15      0.24 0.3080034   5.930407
# 463  0.25      0.24 0.5159378   4.828483
# 464  0.35      0.24 0.7196862  12.065836
# 465  0.45      0.24 0.9296755  12.492544
# 466  0.55      0.24 1.1326590  10.638326
# 467  0.65      0.24 1.3397604  13.716870
# 468  0.75      0.24 1.5431813  20.731617
# 469  0.85      0.24 1.7511680  14.259057
# 470  0.95      0.24 1.9582999  25.577486
# 471  1.05      0.24 2.1615200  30.006350
# 472  1.15      0.24 2.3651720  41.557615
# 482  0.15      0.25 0.2999956   3.456258
# 483  0.25      0.25 0.5005802   4.376320
# 484  0.35      0.25 0.6990509   7.360627
# 485  0.45      0.25 0.9013523  44.688155
# 486  0.55      0.25 1.1007589  10.158290
# 487  0.65      0.25 1.3007171  12.446769
# 488  0.75      0.25 1.4981795  11.794699
# 489  0.85      0.25 1.6981345  75.964641
# 490  0.95      0.25 1.8987950  20.019299
# 491  1.05      0.25 2.1009550  25.237877
# 492  1.15      0.25 2.3005932  21.455164
# 493  1.25      0.25 2.4977026  23.505126


# Simulations: Take 4 -----------------------------------------------------
# Simulate rho for another group of different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- seq(0.5,5,by=0.5); alpha.rho.vals <- seq(0.75,0.95,by=0.05)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


image(rho.0.vals,alpha.rho.vals,matrix(rho.medians,ncol=10))

# Lets consider, for interest, values that allow the median rho simulated to be between 0.25 and 2.5
medianr.df <- median.df[median.df$medians>0.25,]
medianr.df <- medianr.df[medianr.df$medians<2.5,]
meanr.df <- mean.df[as.numeric(row.names(medianr.df)),]

sub.df <- medianr.df
sub.df$means <- meanr.df$means
sub.df

# sub.df
# rho.0 alpha.rho   medians     means
# 2    1.0      0.75 0.4143470  3.495830
# 3    1.5      0.75 0.6223915  6.915177
# 4    2.0      0.75 0.8289507  8.935110
# 5    2.5      0.75 1.0401271  9.113566
# 6    3.0      0.75 1.2424775 13.397114
# 7    3.5      0.75 1.4548888 32.234508
# 8    4.0      0.75 1.6570006 16.486151
# 9    4.5      0.75 1.8692206 18.937234
# 10   5.0      0.75 2.0759362 22.977185
# 12   1.0      0.80 0.3220449  3.115365
# 13   1.5      0.80 0.4828985  3.775845
# 14   2.0      0.80 0.6451155  5.368108
# 15   2.5      0.80 0.8057273  7.070063
# 16   3.0      0.80 0.9671508  9.477767
# 17   3.5      0.80 1.1270193 11.795393
# 18   4.0      0.80 1.2890995 31.032636
# 19   4.5      0.80 1.4463877 13.007374
# 20   5.0      0.80 1.6085355 35.186946
# 23   1.5      0.85 0.3513805  3.138781
# 24   2.0      0.85 0.4689587  4.169686
# 25   2.5      0.85 0.5861600  6.105686
# 26   3.0      0.85 0.7020063  9.023879
# 27   3.5      0.85 0.8188104  6.964862
# 28   4.0      0.85 0.9411206 10.462691
# 29   4.5      0.85 1.0543514 12.834267
# 30   5.0      0.85 1.1694070 13.289421
# 34   2.0      0.90 0.3034265  3.270939
# 35   2.5      0.90 0.3805841  3.718180
# 36   3.0      0.90 0.4557204  6.531422
# 37   3.5      0.90 0.5309667  8.103524
# 38   4.0      0.90 0.6088159  6.386777
# 39   4.5      0.90 0.6826250  8.062628
# 40   5.0      0.90 0.7600845  7.592489
# 47   3.5      0.95 0.2587935  2.618466
# 48   4.0      0.95 0.2956533  2.773288
# 49   4.5      0.95 0.3330019  3.366398
# 50   5.0      0.95 0.3697020  3.491711



# Simulations: Take 5 -----------------------------------------------------
# Simulate rho for another group of different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- seq(2,10,by=1); alpha.rho.vals <- seq(0.1,0.9,by=0.1)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


main.df <- mean.df
main.df$median <- median.df$medians
main.df


# Simulations: Take 6 -----------------------------------------------------
# Simulate rho for another group of different values and consider the median and mean values.

# Set-up ------------------------------------------------------------------

rho.0.vals <- c(0.35,1,4); alpha.rho.vals <- c(0.01,0.1,0.65)
rho.star <- as.matrix(unname(expand.grid(rho.0.vals,alpha.rho.vals)),ncol=2)

rho.sim.n.mean <- function(rho.star){mean(rho.sim(1e6,rho.star))}
rho.sim.n.median <- function(rho.star){median(rho.sim(1e6,rho.star))}
rho.means <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.mean(rho.star.vals[i,])},rho.star)
rho.means
rho.medians <- sapply(1:dim(rho.star)[1],function(i,rho.star.vals){rho.sim.n.median(rho.star.vals[i,])},rho.star)
rho.medians

mean.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],means=rho.means)
median.df <- data.frame(rho.0=rho.star[,1],alpha.rho=rho.star[,2],medians=rho.medians)


main.df <- mean.df
main.df$median <- median.df$medians
main.df


# rho.0 alpha.rho      means     median
# 1  0.35      0.01  68.006082  2.3237512
# 2  1.00      0.01  90.122606  6.6304181
# 3  4.00      0.01 276.154804 26.6521504
# 4  0.35      0.10  17.828626  1.1624494
# 5  1.00      0.10  76.914260  3.3167090
# 6  4.00      0.10 185.510091 13.2827784
# 7  0.35      0.65   2.466869  0.2173691
# 8  1.00      0.65   5.895860  0.6218169
# 9  4.00      0.65  27.255344  2.4887602

# rho.0 alpha.rho      means     median
# 1  0.35      0.01  25.522804  2.3232292
# 2  1.00      0.01  71.795302  6.6358400
# 3  4.00      0.01 270.292849 26.5702988
# 4  0.35      0.10  11.681866  1.1609574
# 5  1.00      0.10  30.594520  3.3206237
# 6  4.00      0.10 122.447697 13.2694785
# 7  0.35      0.65   1.985783  0.2176296
# 8  1.00      0.65   5.295973  0.6220614
# 9  4.00      0.65  33.680628  2.4818867



# sessionInfo() -----------------------------------------------------------

sessionInfo()