# Simulation Study Plots --------------------------------------------------

# R script to plot the data for the regular polygon INLA within MCMC simulation study.

# Author: Nadeen Khaleel

# Set Working Directory and Load Libraries --------------------------------

# Either setwd() to the source file location, or run the following:
library("rstudioapi")
setwd(dirname(getActiveDocumentContext()$path))

library(INLA)
library(spatstat)
library(sp)
library(raster)
library(maptools)
library(purrr)
library(stringr)
library(sf)
library(ggplot2)
library(tmap)


# Load Data Sets ----------------------------------------------------------

# Windows
W_1 <- owin(c(0,2.5),c(0,2.5)) # this will always have 100% data
W_2 <- owin(c(2.5,5),c(2.5,5)) # this will have 100% or 20% data and will also have different covariates


# Covariates
cov.name_1 <- "Window1Covariates.rda"
cov.name_2 <- "Window2Covariates.rda"

# Data
data.name_1 <- "Window1FullData.rda"
data.name_2 <- "Window2FullData.rda"
data.name_3 <- "Window2SparseData.rda"
data.name_4 <- "Window2DifferentBeta2Data.rda"
data.name_6 <- "Window2DifferentSignBeta2Data.rda"

# Meshes
mesh.name_1 <- "MeshWindow1.rda"
mesh.name_2 <- "MeshWindow2.rda"


# Plot Windows ------------------------------------------------------------

par(mfrow=c(1,1))
pdf("SimulationStudyWindows.pdf")
plot(W_1,xlim=c(0,5),ylim=c(0,5),main="",axes=T)
plot(W_2,add=T)
text(1.25,2.75,"W_1",cex=2)
text(3.75,2.25,"W_2",cex=2)
dev.off()


# Plot Covariates ---------------------------------------------------------

par(mfrow=c(1,2))

load(cov.name_1)
w1.c1 <- cov1.im
w1.c2 <- cov2.im
pdf("SimulationStudyWindow1Covariates.pdf")
plot(w1.c1,main="")
mtext("Covariate 1 for Window 1",side=3,line=-1,cex=2)
plot(w1.c2,main="")
mtext("Covariate 2 for Window 1",side=3,line=-1,cex=2)
dev.off()

load(cov.name_2)
w2.c1 <- cov1.im
w2.c2 <- cov2.im
pdf("SimulationStudyWindow2Covariates.pdf")
plot(w2.c1,main="")
mtext("Covariate 1 for Window 2",side=3,line=-5,cex=2)
plot(w2.c2,main="")
mtext("Covariate 2 for Window 2",side=3,line=-5,cex=2)
dev.off()


# Plot Data Sets ----------------------------------------------------------

par(mfrow=c(1,1))

M <- 25; N <- 25

# Window 1
g <- quadrats(W_1,M,N)
g.sp <- as(g,"SpatialPolygons")
ord <- sapply(1:length(g.sp),function(ii){unlist(centroid.owin(g.sp[ii]))})

m <- matrix(as.numeric(unlist(str_extract_all(names(g.sp),"\\d*\\d"))),ncol=2,byrow=TRUE)
ord.df <- data.frame(ind=1:g$n,row=m[,1],col=m[,2]) # col matches the raster definition of col=x, and row=y which makes sense visually from the plots as x<--> and y ^inc(^)
ord.df <- ord.df[order(ord.df$col),]

g.sp <- g.sp[ord.df$ind]
g.sf <- st_as_sf(g.sp)
g.cov1 <- g.sf
g.cov2 <- g.sf

load(data.name_1)
g.sf$cov1 <- count.df$cov1
g.cov1$Value <- count.df$cov1
g.cov1$Cov <- rep("Covariate 1",nrow(g.cov1))
g.sf$cov2 <- count.df$cov2
g.cov2$Value <- count.df$cov2
g.cov2$Cov <- rep("Covariate 2",nrow(g.cov2))
g.sf$count <- count.df$count

c1c2 <- ggplot(g.sf) + geom_point(aes(x=cov1,y=cov2)) + theme_bw() + xlab("Covariate 1") + ylab("Covariate 2") + ggtitle("Plot of Aggregated Covariates\n for Window 1") + theme(plot.title = element_text(size=20,hjust = 0.5),axis.title = element_text(size=17.5),axis.text = element_text(size=12.5))
ggsave(filename = "SimulationStudyWindow1FullCovariatesCorr.pdf",plot = c1c2, height = 5, width = 5)

g.sf.all <- rbind(g.cov1,g.cov2)
data1.cov <- tm_shape(g.sf.all) +
  tm_fill("Value",palette = "viridis",title="Values") +
  tm_facets(by = "Cov") + tm_layout(main.title = "Covariates for Window 1",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside.position = "right", legend.outside.size = 0.15, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data1.cov,height = 5, width=10,filename="SimulationStudyWindow1FullCovariates.pdf")

data1.count <- tm_shape(g.sf) +
  tm_fill("count",palette = "viridis",title="Count") +
  tm_layout(main.title = "Count for Data Set 1",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside = T,legend.outside.position = "right", legend.outside.size = 0.2, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data1.count, height = 5, width = 5,filename="SimulationStudyWindow1FullCount.pdf")

M <- 25; N <- 25

# Window 1
g <- quadrats(W_2,M,N)
g.sp <- as(g,"SpatialPolygons")
ord <- sapply(1:length(g.sp),function(ii){unlist(centroid.owin(g.sp[ii]))})

m <- matrix(as.numeric(unlist(str_extract_all(names(g.sp),"\\d*\\d"))),ncol=2,byrow=TRUE)
ord.df <- data.frame(ind=1:g$n,row=m[,1],col=m[,2]) # col matches the raster definition of col=x, and row=y which makes sense visually from the plots as x<--> and y ^inc(^)
ord.df <- ord.df[order(ord.df$col),]

g.sp <- g.sp[ord.df$ind]
g.sf.orig <- st_as_sf(g.sp)

# Full Data Set
load(data.name_2)
g.sf <- g.sf.orig
g.cov1 <- g.sf
g.cov2 <- g.sf

g.sf$cov1 <- count.df$cov1
g.cov1$Value <- count.df$cov1
g.cov1$Cov <- rep("Covariate 1",nrow(g.cov1))
g.sf$cov2 <- count.df$cov2
g.cov2$Value <- count.df$cov2
g.cov2$Cov <- rep("Covariate 2",nrow(g.cov2))
g.sf$count <- count.df$count

c1c2 <- ggplot(g.sf) + geom_point(aes(x=cov1,y=cov2)) + theme_bw() + xlab("Covariate 1") + ylab("Covariate 2") + ggtitle("Plot of Aggregated Covariates\n for Window 2") + theme(plot.title = element_text(size=20,hjust = 0.5),axis.title = element_text(size=17.5),axis.text = element_text(size=12.5))
ggsave(filename = "SimulationStudyWindow2FullCovariatesCorr.pdf",plot = c1c2, height = 5, width = 5)

g.sf.all <- rbind(g.cov1,g.cov2)
data2.cov <- tm_shape(g.sf.all) +
  tm_fill("Value",palette = "viridis",title="Values") +
  tm_facets(by = "Cov") + tm_layout(main.title = "Covariates for Window 2",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside.position = "right", legend.outside.size = 0.15, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data2.cov,height = 5, width=10,filename="SimulationStudyWindow2FullCovariates.pdf")

data2.count <- tm_shape(g.sf) +
  tm_fill("count",palette = "viridis",title="Count") +
  tm_layout(main.title = "Count for Data Set 2",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside = T,legend.outside.position = "right", legend.outside.size = 0.2, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data2.count, height = 5, width = 5,filename="SimulationStudyWindow2FullCount.pdf")

# Sparse Data Set
load(data.name_3)
g.sf <- g.sf.orig
g.cov1 <- g.sf
g.cov2 <- g.sf

g.sf$cov1 <- count.df$cov1
g.cov1$Value <- count.df$cov1
g.cov1$Cov <- rep("Covariate 1",nrow(g.cov1))
g.sf$cov2 <- count.df$cov2
g.cov2$Value <- count.df$cov2
g.cov2$Cov <- rep("Covariate 2",nrow(g.cov2))
g.sf$count <- count.df$count

c1c2 <- ggplot(g.sf) + geom_point(aes(x=cov1,y=cov2)) + theme_bw() + xlab("Covariate 1") + ylab("Covariate 2") + ggtitle("Plot of Aggregated Covariates\n for Window 2") + theme(plot.title = element_text(size=20,hjust = 0.5),axis.title = element_text(size=17.5),axis.text = element_text(size=12.5))
ggsave(filename = "SimulationStudyWindow2SparseCovariatesCorr.pdf",plot = c1c2, height = 5, width = 5)

g.sf.all <- rbind(g.cov1,g.cov2)
data3.cov <- tm_shape(g.sf.all) +
  tm_fill("Value",palette = "viridis",title="Values") +
  tm_facets(by = "Cov") + tm_layout(main.title = "Covariates for Window 2",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside.position = "right", legend.outside.size = 0.15, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data3.cov,height = 5, width=10,filename="SimulationStudyWindow2CovariatesSparse.pdf")

data3.count <- tm_shape(g.sf) +
  tm_fill("count",palette = "viridis",title="Count") +
  tm_layout(main.title = "Count for Data Set 3",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside = T,legend.outside.position = "right", legend.outside.size = 0.2, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data3.count, height = 5, width = 5,filename="SimulationStudyWindow2SparseCount.pdf")

# Diff Cov Data Set
load(data.name_4)
g.sf <- g.sf.orig
g.cov1 <- g.sf
g.cov2 <- g.sf

g.sf$cov1 <- count.df$cov1
g.cov1$Value <- count.df$cov1
g.cov1$Cov <- rep("Covariate 1",nrow(g.cov1))
g.sf$cov2 <- count.df$cov2
g.cov2$Value <- count.df$cov2
g.cov2$Cov <- rep("Covariate 2",nrow(g.cov2))
g.sf$count <- count.df$count

c1c2 <- ggplot(g.sf) + geom_point(aes(x=cov1,y=cov2)) + theme_bw() + xlab("Covariate 1") + ylab("Covariate 2") + ggtitle("Plot of Aggregated Covariates\n for Window 2") + theme(plot.title = element_text(size=20,hjust = 0.5),axis.title = element_text(size=17.5),axis.text = element_text(size=12.5))
ggsave(filename = "SimulationStudyWindow2CovCovariatesCorr.pdf",plot = c1c2, height = 5, width = 5)

g.sf.all <- rbind(g.cov1,g.cov2)
data4.cov <- tm_shape(g.sf.all) +
  tm_fill("Value",palette = "viridis",title="Values") +
  tm_facets(by = "Cov") + tm_layout(main.title = "Covariates for Window 2",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside.position = "right", legend.outside.size = 0.15, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data4.cov,height = 5, width=10,filename="SimulationStudyWindow2CovariatesCov.pdf")

data4.count <- tm_shape(g.sf) +
  tm_fill("count",palette = "viridis",title="Count") +
  tm_layout(main.title = "Count for Data Set 4",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside = T,legend.outside.position = "right", legend.outside.size = 0.2, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data4.count, height = 5, width = 5,filename="SimulationStudyWindow2CovCount.pdf")
# Some legend labels were too wide. These labels have been resized to 0.89, 0.77, 0.77, 0.77, 0.77. Increase legend.width (argument of tm_layout) to make the legend wider and therefore the labels larger.
# Size: 5 by 5 inches
# Warning message:
#   Currect projection of shape g.sf unknown. Long-lat (WGS84) is assumed. 

# Different Sign Cov
load(data.name_5)
g.sf <- g.sf.orig
g.cov1 <- g.sf
g.cov2 <- g.sf

g.sf$cov1 <- count.df$cov1
g.cov1$Value <- count.df$cov1
g.cov1$Cov <- rep("Covariate 1",nrow(g.cov1))
g.sf$cov2 <- count.df$cov2
g.cov2$Value <- count.df$cov2
g.cov2$Cov <- rep("Covariate 2",nrow(g.cov2))
g.sf$count <- count.df$count

c1c2 <- ggplot(g.sf) + geom_point(aes(x=cov1,y=cov2)) + theme_bw() + xlab("Covariate 1") + ylab("Covariate 2") + ggtitle("Plot of Aggregated Covariates\n for Window 2") + theme(plot.title = element_text(size=20,hjust = 0.5),axis.title = element_text(size=17.5),axis.text = element_text(size=12.5))
ggsave(filename = "SimulationStudyWindow2DSCovCovariatesCorr.pdf",plot = c1c2, height = 5, width = 5)

g.sf.all <- rbind(g.cov1,g.cov2)
data5.cov <- tm_shape(g.sf.all) +
  tm_fill("Value",palette = "viridis",title="Values") +
  tm_facets(by = "Cov") + tm_layout(main.title = "Covariates for Window 2",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside.position = "right", legend.outside.size = 0.15, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data5.cov,height = 5, width=10,filename="SimulationStudyWindow2CovariatesDSCov.pdf")
# Size: 10 by 5 inches
# Warning message:
#   Currect projection of shape g.sf.all unknown. Long-lat (WGS84) is assumed. 

data5.count <- tm_shape(g.sf) +
  tm_fill("count",palette = "viridis",title="Count") +
  tm_layout(main.title = "Count for Data Set 5",main.title.position = "center", main.title.size = 2, panel.label.size = 1.25,legend.outside = T,legend.outside.position = "right", legend.outside.size = 0.2, legend.title.size = 1.5, legend.text.size = 1,asp = 1)
tmap_save(data5.count, height = 5, width = 5,filename="SimulationStudyWindow2DSCovCount.pdf")
# Size: 5 by 5 inches
# Warning message:
#   Currect projection of shape g.sf unknown. Long-lat (WGS84) is assumed. 


dev.off()

# Plot Meshes -------------------------------------------------------------

library(INLA)

load(mesh.name_1)
pdf("SimulationStudyWindow1Mesh.pdf")
plot(mesh,main="")
title("Window 1: Mesh",cex=5)
dev.off()

load(mesh.name_2)
pdf("SimulationStudyWindow2Mesh.pdf")
plot(mesh,main="")
title("Window 2: Mesh",cex=5)
dev.off()



# sessionInfo() -----------------------------------------------------------

sessionInfo()