# INLA within MCMC Simulation Study: INLA Runs ----------------------------

# This R script contains the code for running the INLA algorithm to the data sets for the INLA within MCMC Simulation Study.

# Author: Nadeen Khaleel

# Temporary Directory
library(unixtools)
unixtools::set.tempdir("/local/")


# Libraries ---------------------------------------------------------------


library(INLA)
library(mvtnorm)
library(sp)
library(sf)
library(spatstat)
library(raster)
library(maptools)
library(stringr)
library(rgeos)


# Windows
W_1 <- owin(c(0,2.5),c(0,2.5)) # this will always have 100% data
W_2 <- owin(c(2.5,5),c(2.5,5)) # this will have 100% or 20% data and will also have different covariates

# Count Data
data.name_1 <- "Window1FullData.rda"
data.name_2 <- "Window2FullData.rda"
data.name_3 <- "Window2SparseData.rda"
data.name_4 <- "Window2DifferentBeta2Data.rda"
# data.name_5 <- "Window2DifferentBeta2SparseData.rda" # NEVER run
data.name_6 <- "Window2DifferentSignBeta2Data.rda"

# Meshes
mesh.name_1 <- "MeshWindow1.rda"
mesh.name_2 <- "MeshWindow2.rda"

sigma.star <- c(4,0.1); rho.star <- c(0.4,0.1)

# Window 1: Full 
load(data.name_1)
load(mesh.name_1)

spde <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[1],rho.star[2]),
                                      prior.sigma = c(sigma.star[1],sigma.star[2]))
data <- count.df # don't want any potential issues from re-writing parts of the input data set
s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

full1.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk),control.predictor=list(A=inla.stack.A(stk),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))
save(full1.fit,file="Window1FullINLA.rda")

rm(data)
rm(mesh)
rm(spde)


# Window 2

# Full
load(data.name_2)
load(mesh.name_2)

spde <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[1],rho.star[2]),
                            prior.sigma = c(sigma.star[1],sigma.star[2]))
data <- count.df # don't want any potential issues from re-writing parts of the input data set
s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

full2.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk),control.predictor=list(A=inla.stack.A(stk),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))
save(full2.fit,file="Window2FullINLA.rda")

rm(data)
rm(mesh)
rm(spde)


# Sparse
load(data.name_3)
load(mesh.name_2)

spde <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[1],rho.star[2]),
                            prior.sigma = c(sigma.star[1],sigma.star[2]))
data <- count.df # don't want any potential issues from re-writing parts of the input data set
s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

sparse.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk),control.predictor=list(A=inla.stack.A(stk),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))
save(sparse.fit,file="Window2SparseINLA.rda")

rm(data)
rm(mesh)
rm(spde)

# Cov (same sign)
load(data.name_4)
load(mesh.name_2)

spde <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[1],rho.star[2]),
                            prior.sigma = c(sigma.star[1],sigma.star[2]))
data <- count.df # don't want any potential issues from re-writing parts of the input data set
s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

cov.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk),control.predictor=list(A=inla.stack.A(stk),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))
save(cov.fit,file="Window2CovINLA.rda")

rm(data)
rm(mesh)
rm(spde)

# Cov (different sign)
load(data.name_6)
load(mesh.name_2)


spde <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[1],rho.star[2]),
                            prior.sigma = c(sigma.star[1],sigma.star[2]))
data <- count.df # don't want any potential issues from re-writing parts of the input data set
s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

dscov.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk),control.predictor=list(A=inla.stack.A(stk),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))
save(dscov.fit,file="Window2DSCovINLA.rda")

rm(data)
rm(mesh)
rm(spde)


print(sessionInfo())
#################################################################################################

#Define arrays for storing result
rm(list=ls()) # Must finish with this.

