# Balena MultiCity INLA Runs ---------------------------------------------

# This script runs the INLA functions for LA and NYC for Grid 3 and Mesh 3 on Balena, in order to use the same versions of the functions.

# Author: Nadeen Khaleel

# Loading Libraries and Functions -----------------------------------------

library(purrr)
library(INLA)
library(mvtnorm)
library(sp)
library(sf)
library(spatstat)
library(raster)
library(maptools)
library(stringr)
library(rgeos)
library(unixtools)
unixtools::set.tempdir("/local/")

# Loading Data ------------------------------------------------------------

# Los Angeles
LA.file <- "LA2015CT4872CountData_projFinalScale.rda"
LA.mesh <- "LAMesh4872_projFinalScale.rda"


# New York
NY.file <- "NY2015CT4748CountData_projFinalScale.rda"
NY.mesh <- "NYMesh4748_projFinalScale.rda"



# Set-Up ------------------------------------------------------------------

# Priors
rho.star <- list(c(0.4,0.1),c(0.4,0.1)); sigma.star <- list(c(2,0.1),c(2,0.1))

# Main Data Set of All (Two) Cities
data.list <- vector(mode="list",length=2)
names(data.list) <-  paste0(c("LA","NY"),"_City")
data.files <- c(LA.file,NY.file)
mesh.files <- c(LA.mesh,NY.mesh)

for (i in 1:2){
  load(data.files[i])
  count.df <- gta_countdf # Want to fit to Motor Vehicle Theft
  # Change names of Covariates "pop"->"cov1" and "inc"->"cov2" and "gta"->"count"
  colnames(count.df)[colnames(count.df)=="gta"] <- "count"
  
  # Want to scale the variables, 10,000 population and 100,000 income and create "cov1" <- "pop" and "cov2" <- "inc"
  count.df$cov1 <- count.df$pop/1e4
  count.df$cov2 <- count.df$inc/1e5
  count.df$area <- as.numeric(count.df$area)/1e8
  
  print(paste("City ",names(data.list)[i]))
  print(min(count.df$count))
  print(max(count.df$count))
  print(min(count.df$cov1))
  print(max(count.df$cov1))
  print(min(count.df$cov2))
  print(max(count.df$cov2))
  print(min(count.df$area))
  print(max(count.df$area))
  
  
  data.list[[i]]$count <- count.df
  
  load(mesh.files[i])
  data.list[[i]]$mesh <- mesh
  
  data.list[[i]]$spde.prior <- inla.spde2.pcmatern(mesh,alpha=2,prior.range = c(rho.star[[i]][1],rho.star[[i]][2]),prior.sigma = c(sigma.star[[i]][1],sigma.star[[i]][2]))
}

# i = 1 -> LA, i = 2 -> NYC

# Los Angeles
c <- 1
data <- data.list[[c]]$count
mesh <- data.list[[c]]$mesh
spde <- data.list[[c]]$spde.prior

s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk.la <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

la.gta.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk.la),control.predictor=list(A=inla.stack.A(stk.la),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))

save(stk.la,la.gta.fit,file="LAMVTINLA.rda")

rm(data)
rm(mesh)
rm(spde)

# New York
c <- 2
data <- data.list[[c]]$count
mesh <- data.list[[c]]$mesh
spde <- data.list[[c]]$spde.prior

s.index <- inla.spde.make.index("field",n.spde=spde$n.spde)
coords <- data[,c("x","y")]
coordinates(coords) <- ~ x + y
A <- inla.spde.make.A(mesh, loc=coords)
stk.ny <- inla.stack(data=list(resp=data$count),A=list(A,1),effects=list(c(s.index,list(int=1)),list(cov1=data$cov1,cov2=data$cov2,larea=log(data$area))),tag='est')

ny.gta.fit <- try(inla(resp ~ 0 + offset(larea) + int + cov1 + cov2 + f(field,model=spde), family="poisson", data=inla.stack.data(stk.ny),control.predictor=list(A=inla.stack.A(stk.ny),compute=TRUE),control.fixed=list(mean=list(int=0,cov1=0,cov2=0),prec=list(int=1/100,cov1=1/100,cov2=1/100)))) # ,control.compute = list(config=TRUE,cpo=TRUE,waic=TRUE,dic=TRUE)))

save(stk.ny,ny.gta.fit,file="NYCMVTINLA.rda")


#############
sessionInfo()

#############

rm(list=ls())
