
# Plotting Los Angeles and New York Data for MIwM -------------------------

# This R script produces plots of the crime data, grids, meshes and socio-economic variables for the 1km-by-1km grid and mesh resolutions that will be used for the INLA, Univariate and Multivariate INLA within MCMC algorithm implementations.

# Author: Nadeen Khaleel


# Setwd and Load Libraries ------------------------------------------------

library("rstudioapi")
# Either setwd() to the source file location, or run the following:
setwd(dirname(getActiveDocumentContext()$path))

library(INLA)
library(spatstat)
library(sp)
library(sf)
library(maptools)
library(tmap)
library(tmaptools)


# Los Angeles -------------------------------------------------------------

# Los Angeles: Load Data --------------------------------------------------

load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAQuad4872_projFinal.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LACoord4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAOrdDF4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAMesh4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LA2015CT4872SFCountData_projFinalScale.rda")


# Los Angeles: Create Gridded Covariates ----------------------------------

g <- quad.la
g.sp <- as(g,"SpatialPolygons")
g.sp <- g.sp[ord.df.la$ind,]
g.sp$pop <- sf_homcount$pop
g.sp$inc <- sf_homcount$inc
g.sp$hom <- sf_homcount$hom
g.sp$gta <- sf_gtacount$gta

grid.la <- st_as_sf(g.sp)


# Los Angeles: Plotting ---------------------------------------------------

# Quadrats and Centres
save.file <- paste0("QuadratLA4872.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(quad.la,main="")
dev.off()
save.file.p <- paste0("QuadratwPointsLA4872.pdf")
pdf(save.file.p,height = 15,w=15,pointsize = 14)
plot(quad.la,main="")
points(coord.final,pch=19,cex=0.75)
dev.off()



# Covariates

save.file <- paste0("GridCovariatesLA4872.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.la["pop"],main="Population")
plot(grid.la["inc"],main="Average Income")
dev.off()



# Meshes

save.file <- paste0("MeshLA4872.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(mesh,main="")
dev.off()
save.file.p <- paste0("MeshwPointsLA4872.pdf")
pdf(save.file.p,height = 15,w=15,pointsize = 14)
plot(mesh,main="")
points(st_coordinates(sf_homcount),col="red",pch=19,cex=0.5)
dev.off()


# Homicide

save.file <- paste0("GridHomLA4872.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.la["hom"],main="Homicide")
dev.off()


# MVT

save.file <- paste0("GridMVTLA4872.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.la["gta"],main="Motor Vehicle Theft")
dev.off()


rm(list=ls())

# New York ----------------------------------------------------------------

# New York: Load Data -----------------------------------------------------

load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYQuad4748_projFinal.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYCoord4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYOrdDF4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYMesh4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NY2015CT4748SFCountData_projFinalScale.rda")


# New York: Create Gridded Covariates -------------------------------------

g <- quad.ny
g.sp <- as(g,"SpatialPolygons")
g.sp <- g.sp[ord.df.ny$ind,]
g.sp$pop <- sf_homcount$pop
g.sp$inc <- sf_homcount$inc
g.sp$hom <- sf_homcount$hom
g.sp$gta <- sf_gtacount$gta

grid.ny <- st_as_sf(g.sp)


# New York: Plotting ------------------------------------------------------

# Quadrats and Centres
save.file <- paste0("QuadratNY4748.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(quad.ny,main="")
dev.off()
save.file.p <- paste0("QuadratwPointsNY4748.pdf")
pdf(save.file.p,height = 15,w=15,pointsize = 14)
plot(quad.ny,main="")
points(coord.final,pch=19,cex=0.75)
dev.off()



# Covariates

save.file <- paste0("GridCovariatesNY4748.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.ny["pop"],main="Population")
plot(grid.ny["inc"],main="Average Income")
dev.off()



# Meshes

save.file <- paste0("MeshNY4748.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(mesh,main="")
dev.off()
save.file.p <- paste0("MeshwPointsNY4748.pdf")
pdf(save.file.p,height = 15,w=15,pointsize = 14)
plot(mesh,main="")
points(st_coordinates(sf_homcount),col="red",pch=19,cex=0.5)
dev.off()


# Homicide

save.file <- paste0("GridHomNY4748.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.ny["hom"],main="Homicide")
dev.off()


# MVT

save.file <- paste0("GridMVTNY4748.pdf")
pdf(save.file,height = 15,w=15,pointsize = 14)
plot(grid.ny["gta"],main="Motor Vehicle Theft")
dev.off()




# Los Angeles + New York: Combined Plots ----------------------------------

# Re-load Los Angeles Data
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAQuad4872_projFinal.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LACoord4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAOrdDF4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LAMesh4872_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/LA/LA2015CT4872SFCountData_projFinalScale.rda")


g <- quad.la
g.sp <- as(g,"SpatialPolygons")
g.sp <- g.sp[ord.df.la$ind,]
g.sp$pop <- sf_homcount$pop
g.sp$inc <- sf_homcount$inc
g.sp$hom <- sf_homcount$hom
g.sp$gta <- sf_gtacount$gta

grid.la <- st_as_sf(g.sp)

# Re-load New York Data
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYQuad4748_projFinal.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYCoord4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYOrdDF4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NYMesh4748_projFinalScale.rda")
load("../../DATA/PROCESSED_DATA/CRIME/COUNT_DATA_FINAL/NYC/NY2015CT4748SFCountData_projFinalScale.rda")


g <- quad.ny
g.sp <- as(g,"SpatialPolygons")
g.sp <- g.sp[ord.df.ny$ind,]
g.sp$pop <- sf_homcount$pop
g.sp$inc <- sf_homcount$inc
g.sp$hom <- sf_homcount$hom
g.sp$gta <- sf_gtacount$gta

grid.ny <- st_as_sf(g.sp)


grid.la$city <- rep("LA",nrow(grid.la))
grid.ny$city <- rep("NYC",nrow(grid.ny))

grid.all <- rbind(grid.la,grid.ny)

hom.p <- tm_shape(grid.all) +
  tm_fill("hom",palette = "viridis",title="Homicide") +
  tm_facets(by = "city") + tm_layout(legend.outside.position = "right" , legend.outside.size = .2,asp = 1)

gta.p <- tm_shape(grid.all) +
  tm_fill("gta",palette = "viridis",title="MVT") +
  tm_facets(by = "city") + tm_layout(legend.outside.position = "right" , legend.outside.size = .2,asp = 1)

pop.p <- tm_shape(grid.all) +
  tm_fill("pop",palette = "viridis",title="Population") +
  tm_facets(by = "city") + tm_layout(legend.outside.position = "right" , legend.outside.size = .2,asp = 1)

inc.p <- tm_shape(grid.all) +
  tm_fill("inc",palette = "viridis",title="Average Income") +
  tm_facets(by = "city") + tm_layout(legend.outside.position = "right" , legend.outside.size = .2,asp = 1)


tmap_save(hom.p,filename="LAandNYGridHomicide.pdf")

tmap_save(gta.p,filename="LAandNYGridGTA.pdf")

tmap_save(pop.p,filename="LAandNYGridPop.pdf")

tmap_save(inc.p,filename="LAandNYGridInc.pdf")


# tmap() Crime Plots ------------------------------------------------------

true.la.hom <- tm_shape(grid.la) +
  tm_fill("gta",palette = "viridis",title="Homicide") + tm_layout(main.title="2015 LA Homicide",legend.title.size=1,legend.text.size = 1,asp = 1)
tmap_save(true.la.hom,filename="LAGrid4872Homicide.pdf")
true.la.gta <- tm_shape(grid.la) +
  tm_fill("gta",palette = "viridis",title="MVT") + tm_layout(main.title="2015 LA Motor Vehicle Theft",legend.title.size=1,legend.text.size = 1,asp = 1)
tmap_save(true.la.gta,filename="LAGrid4872GTA.pdf")


true.ny.hom <- tm_shape(grid.ny) +
  tm_fill("gta",palette = "viridis",title="Homicide") + tm_layout(main.title="2015 New York Homicide",legend.title.size=1,legend.text.size = 1,asp = 1)
tmap_save(true.ny.hom,filename="NYGrid4748Homicide.pdf")

true.ny.gta <- tm_shape(grid.ny) +
  tm_fill("gta",palette = "viridis",title="MVT") + tm_layout(main.title="2015 New York Motor Vehicle Theft",legend.title.size=1,legend.text.size = 1,asp = 1)
tmap_save(true.ny.gta,filename="NYGrid4748GTA.pdf")



# sessionInfo() -----------------------------------------------------------

sessionInfo()
