function [Xs, Ys, Zs] = Spherical2Cartesian(latsInDegrees, longsInDegrees)
% Convert latitudes and longitudes into Cartesian coordinates.
% Cartesian coordinates lie on the unit sphere. The origin of the coordinate
% system is at the center of the sphere. The positive x-axis passes through 0
% degrees longitude, the positive y-axis passes through +90 degrees longitude,
% and the positive z-axis passes through +90 degrees latitude. Latitude and
% longitude are given in degrees with latitudes of [-90, 90] and longitudes of
% (-180, 180]. Xs, Ys, and Zs are arrays of the same shape as the input. Refer
% to http://www.geomidpoint.com/calculation.html for more information.
%
%    usage: [Xs, Ys, Zs] = Spherical2Cartesian(latsInDegrees, longsInDegrees)

    cosLats = cosd(latsInDegrees);
    % Cache common sub-expression.

    Xs = cosLats .* cosd(longsInDegrees);
    Ys = cosLats .* sind(longsInDegrees);
    Zs = sind(latsInDegrees);
    % Apply coordinate transformation formulas.

end
