function distance =haversine(lat1,lon1,lat2,lon2)

% HAVERSINE     Computes the  haversine (great circle) distance in km
% between two points on the surface of the Earth. These points are
% specified as decimal latitudes and longitudes.
%
%   Examples
%       haversine(53.463056,-2.291389,53.483056,-2.200278) returns
%       6.4270 km
%
%   Inputs
%       latitudes and longitudes expressed in decimal degrees.
%
%   Notes
%       Based on an original by Ritchie Smith (2021). 
%       haversine (https://www.mathworks.com/matlabcentral/fileexchange/32883-haversine),
%       MATLAB Central File Exchange. Retrieved August 2, 2021.

lat = [lat1 lat2];
long = [lon1 lon2];

long=deg2rad(long);
lat=deg2rad(lat);

dlat=diff(lat);
dlong=diff(long);

a=sin(dlat/2).^2+cos(lat(1:end-1)).*cos(lat(2:end)).*sin(dlong/2).^2;
c=2*atan2(sqrt(a),sqrt(1-a));

R=6371;         % [km] Radius of the Earth
distance=R.*c;