%  Program: FUNCTION TO CONVERT GRID LOCATOR TO LATITUDE & LONGITUDE     %
%------------------------------------------------------------------------%
%  Purpose: Derive latitude and longitude from a six-digit grid locator  %
%           Input: grid locator as six-character string                  %
%           Output: latitude and longitude as decimals                   %
%------------------------------------------------------------------------%
%  MatLab:  R2019b                                                       %
%------------------------------------------------------------------------%
%  Creation / modification history:                                      %
%  2021-07-30 - v1.00 - C J Deacon - creation                            %
%  2021-12-20 - v1.00 - C J Deacon - cope with lower case subsquare      %
%------------------------------------------------------------------------%

function [lat,lon] = loc2latlong(locator)

% Correct ascii code if subsquare is lower case
ss1 = double(locator(5));
if ss1 >90
    ss1 = ss1 - 32;
end
ss2 = double(locator(6));
if ss2 >90
    ss2 = ss2 - 32;
end

% Longitude calculation using ascii code
field       =   (double(locator(1)) - 65) * 20;
square      =   (double(locator(3)) - 48) * 2;
subsquare   =   (ss1 - 65) * 2/24;
lon         =   -180 + field + square + subsquare + 1/24;

% Latitude calculation using ascii code
field       =   (double(locator(2)) - 65) * 10;
square      =   (double(locator(4)) - 48) * 1;
subsquare   =   (ss2 - 65) * 1/24;
lat         =   -90 + field + square + subsquare + 1/48;

end


