%------------------------------------------------------------------------%
%  Program: CREATE SPOT LIST FILE                                        %
%------------------------------------------------------------------------%
%  Purpose: Create file containing spot data per band                    %
%  Uses:    DXMaps.com downloaded spreadsheet                            %                                                                 %
%------------------------------------------------------------------------%
%  MatLab:  R2021b                                                       %
%------------------------------------------------------------------------%
%  Creation / modification history:                                      %
%  2021-07-29 - v1.00 - C J Deacon - creation                            %
%  2021-11-25 - v1.10 - C J Deacon - add locators to saved spot file     %
%  2021-12-14 - v1.20 - C J Deacon - skip spots with four-character locs %
%  2021-12-20 - v1.30 - C J Deacon - add read of WSPRnet data            %
%------------------------------------------------------------------------%

% - Clear memory -
close all; clear

% Select the desired sheet
% SheetName = '28 MHZ';
SheetName = '50 MHZ';
% SheetName = '70 MHZ';

% - Import DX spots from spreadsheet
[dummy,SpotList] = xlsread('.\ES 18Aug2018 cleaned extract plus WSPR.xlsx',SheetName);
numlines = length (SpotList);

spot = 0;

for line = 1: numlines

    % Parse station 1 and 2 text if both locators are six-character
    SpotText1 = char(SpotList(line,2));
    lbrac1 = find(SpotText1=='(');
    SpotText2 = char(SpotList(line,3));
    lbrac2 = find(SpotText2=='(');

    if length(SpotText1) >= (lbrac1 + 6) && length(SpotText2) >= (lbrac2 + 6)

        spot = spot + 1;

        loc1 = SpotText1(lbrac1+1 : lbrac1+6);
        [lat1,lon1] = loc2latlong(loc1);
        loc2 = SpotText2(lbrac2+1 : lbrac2+6);
        [lat2,lon2] = loc2latlong(loc2);

        % Save spot date/time
        SpotTime(spot) = datenum(char(SpotList(line,1)),'dd/mm/yyyy HH:MM:SS');

        % Save station 1 data
        SpotLoc1(spot) = string(loc1);
        SpotLat1(spot) = lat1;
        SpotLon1(spot) = lon1;

        % Save station 2 data
        SpotLoc2(spot) = string(loc2);
        SpotLat2(spot) = lat2;
        SpotLon2(spot) = lon2;

    end

end

disp('Saving extracted spot list...');

save (['./Spotlist ' SheetName '.mat'],'SpotTime','SpotLoc1','SpotLat1',...
    'SpotLon1','SpotLoc2','SpotLat2','SpotLon2');
