%------------------------------------------------------------------------%
%  Program: CREATE ES TOP FREQUENCY LIST FILE                                        %
%------------------------------------------------------------------------%
%  Purpose: Create file containing ionosonde ftEs data                   %
%  Uses:    ftEs data extract spreadsheet                            %                                                                 %
%------------------------------------------------------------------------%
%  MatLab:  R2021a                                                       %
%------------------------------------------------------------------------%
%  Creation / modification history:                                      %
%  2021-08-12 - v1.00 - C J Deacon - creation based on CREATE_SPOT_LIST  %
%------------------------------------------------------------------------%

% - Clear memory -
close all; clear

% - Import ftEs records spreadsheet
[ftEsDat,ftEsTimestr] = xlsread('.\2018 Ionosonde data ftEs extract.xlsx');
numlines = length (ftEsTimestr);

% - Convert ftEs record time strings to MATLAB times
for line = 1: numlines

ftEsTime(line) = datenum(char(ftEsTimestr(line)),'dd/mm/yyyy HH:MM:SS');

end

disp('Saving extracted ftEs data...');

save ('./ftEsData.mat','ftEsTime','ftEsDat');
