
%------------------------------------------------------------------------%
%  Program: PLOT COMBINED SEQUENCE OF SPOT MAPS ON W. EUROPE MAP         %
%------------------------------------------------------------------------%
%  Purpose: Plot ionosonde locations on European map                     %
%  Uses:                                                                 %
%------------------------------------------------------------------------%
%  MatLab:  R2021b                                                       %
%------------------------------------------------------------------------%
%  Creation / modification history:                                      %
%  2021-03-01 - v1.00 - C J Deacon - Creation from master map script     %
%------------------------------------------------------------------------%

% - Clear memory -
clear
close all hidden

% Define ionosonde locations, lat/long
Chilton = [51.57,-1.32];
Roquetes = [40.8,0.5];
Dourbes = [50.1,4.6];
Rome = [41.9,12.5];
Juliusruh = [54.6,13.4];
Pruhonice = [49.98,14.55];
Sopron = [47.63,16.72];

% Combine the ionosonde locations into a single array of lat/long
Ionosondes = [Chilton ; Roquetes ; Dourbes ; Rome ; Juliusruh ; ...
    Pruhonice ; Sopron];

% Create an array of ionosonde names
IonosNames = ["   Chilton" ; "   Roquetes" ; "   Dourbes" ; "   Rome" ; "   Juliusruh" ; ...
    "   Pruhonice" ; "   Sopron"];

% Define directory to save images
OutputDir  = './PLOTS';

% Set map boundaries
% Landscape format
latlim = [40 55];
lonlim = [-7.5 22.5];
% Square format
% latlim = [35 62.5];
% lonlim = [-10 30];

% PREPARE GRAPH SPACE
% Full screen format
% scrsz = get(0,'ScreenSize');
% Landscape format
scrsz = [1,1,1450,1080];
% Square format
% scrsz = [1,1,1080,1080];
figure('NumberTitle','off','Name','Spot Map','OuterPosition',scrsz);

% Create geographic axes using default basemap
geoaxes
hold on
geolimits(latlim,lonlim)
geolimits('manual')

% Add title
title("Ionosondes: Western Europe",'Fontsize', 28,...
    'FontWeight', 'bold', 'color', 'r' );

% Maximise plot size within figure and set axes font
ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset;
left = outerpos(1) + ti(1) + 0.025;
bottom = outerpos(2) + ti(2) + 0.030;
ax_width = outerpos(3) - ti(1) - ti(3) - 0.05;
ax_height = outerpos(4) - ti(2) - ti(4) - 0.05;
ax.Position = [left bottom ax_width ax_height];
%     left = outerpos(1) + ti(1) + 0.015;
%     bottom = outerpos(2) + ti(2)+ 0.025;
%     ax_width = outerpos(3) - ti(1) - ti(3) - 0.03;
%     ax_height = outerpos(4) - ti(2) - ti(4) - 0.03;
%     ax.Position = [left bottom ax_width ax_height];
ax.FontSize = 18;

% PLOT IONOSONDE LOCATIONS

geoscatter(Ionosondes(:,1), Ionosondes(:,2),1200, ...
    'filled', 'o', 'MarkerEdgeColor', 'black')

% Add ionosonde name next to each marker
for i = 1:7
    text(Ionosondes(i,1), Ionosondes(i,2), IonosNames(i), ...
        'HorizontalAlignment', 'left', 'FontSize', 24, ...
        'FontWeight', 'bold', 'color', 'r' );
end

% SAVE FIGURE
% Save as a meaningfully-named image
Filename = [OutputDir '/' 'Ionosondes' '.tif'];
saveas(gcf,Filename,'tif');

close

