% This function opens a csv file (file_name) and outputs pedestrian
% trajectories in a format which can be processed by other functions. 

function [X_traj_A,Y_traj_A,X_traj_B,Y_traj_B,n_A,n_B,T] = Read_In_Trajectories(file_name)

    M = readtable(file_name); 
    
    T = M{:,1}; % Time in seconds
    
    %% Check number of participants in each group (n_A,n_B)
    V = M.Properties.VariableNames; %By reading variable names
    lv = length(V); 
    
    GR = 'A';
    k = 1; 
    while GR== 'A'
        k = k+1; 
        v = V{k};
        GR = v(2); 
    end

    n_A = .5*(k-2); 
    n_B = .5*(lv-1-2*n_A);


    %% Collect trajectories in stack matrices (participants X time_points)
    X_traj_A = []; 
    X_traj_B = []; 
    Y_traj_A = []; 
    Y_traj_B = []; 

    for i1 = 1:n_A     
       X_traj_A(i1,:) = M{:,2*i1}';
       Y_traj_A(i1,:) = M{:,2*i1+1}';
    end


    for i1 = 1:n_B 
       X_traj_B(i1,:) = M{:,2*n_A + 2*i1}';
       Y_traj_B(i1,:) = M{:,2*n_A + 2*i1+1}'; 
    end
    
end
