clear

folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_2_SESSION_2_TRIAL_1.csv'); % Figure 3E
% file_name = strcat(folder_name,'SCENARIO_1_SESSION_2_TRIAL_5.csv'); % Figure 3D

[Xa,Ya,Xb,Yb,na,nb] = Read_In_Trajectories(file_name);


figure, hold on, box on, grid on 

   for i_person = 1:na
       f = find(abs(Xa(i_person,:))>0);
       plot(Xa(i_person,f),Ya(i_person,f),'Color','r','LineWidth',1.5);
   end
   for i_person = 1:nb
       f = find(abs(Xb(i_person,:))>0);
       plot(Xb(i_person,f),Yb(i_person,f),'Color','b','LineWidth',1.5);
   end
   
   
axis([-2.9 2.9, -2.9 2.9]);
plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
  
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')
    
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
   
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])

pbaspect([1 1 1]);
