folder_name = '.\Trajectories_Flip\'; 

%% Get Dominant Angle in Each Trial
theta_scenario_1 = nan(1,10); 
theta_scenario_2 = nan(1,10); 

for i_trial =1:5
    file_name = strcat(folder_name,'SCENARIO_1_SESSION_1_TRIAL_',num2str(i_trial),'.csv');
    theta_scenario_1(i_trial) = Fourier_Get_Dominant(file_name);
end

for i_trial =1:5
    file_name = strcat(folder_name,'SCENARIO_1_SESSION_2_TRIAL_',num2str(i_trial),'.csv');
    theta_scenario_1(i_trial+5) = Fourier_Get_Dominant(file_name);
end

for i_trial =1:2
    file_name = strcat(folder_name,'SCENARIO_2_SESSION_1_TRIAL_',num2str(i_trial),'.csv');
    theta_scenario_2(i_trial) = Fourier_Get_Dominant(file_name);
end

for i_trial =1:5
    file_name = strcat(folder_name,'SCENARIO_2_SESSION_2_TRIAL_',num2str(i_trial),'.csv');
    theta_scenario_2(i_trial+2) = Fourier_Get_Dominant(file_name);
end

%% Whisker Plot Figure
figure 
box on, grid on
plot([.5 2.5],[0 0],'--','color','k'), hold on 

boxplot([-theta_scenario_1; -theta_scenario_2]','Labels',{'unbiased','biased'}), hold on 

ylabel('$\theta_{\max}$ (deg)','interpreter','latex')
pbaspect([6 1 1])
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
set(gca,'YLim',[-7 7])

%% Compute Dominant Angle (as defined in Materials and Methods, Section VIIE)
function s = Fourier_Get_Dominant(file_name)

    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    fa = find(abs(Xa)<2.9 & abs(Ya)<2.9 & abs(Xa)>0 & abs(Ya)>0);
    fb = find(abs(Xb)<2.9 & abs(Yb)<2.9 & abs(Xb)>0 & abs(Yb)>0);
    
    Xa_vec = reshape(Xa(fa),1,length(fa)); 
    Ya_vec = reshape(Ya(fa),1,length(fa));
    Xb_vec = reshape(Xb(fb),1,length(fb)); 
    Yb_vec = reshape(Yb(fb),1,length(fb));
    
    lambda_vec = linspace(0,2.9,50); % Range of considered wavelengths
    theta_vec = linspace(-pi/2,pi/2,201); % Angles of inclination considered

    C1 = Fourier_Transform_Diff(Xa_vec,Ya_vec,Xb_vec,Yb_vec,lambda_vec,theta_vec);

    spec  = sqrt(nansum(C1.^2)); 
    [~,s] = max(spec); 

    s = 180*theta_vec(s)/pi; 
end

function c = Fourier_Transform_Diff(X1,Y1,X2,Y2,lambda,theta)

    n_theta = length(theta); 
    n_lambda = length(lambda); 
    
    for i1 = 1:n_lambda
        for i2 = 1:n_theta

            V1 = cos(theta(i2))*X1 + sin(theta(i2))*Y1; 
            V2 = cos(theta(i2))*X2 + sin(theta(i2))*Y2; 

            ft = sum(exp(1i*2*pi*V1/lambda(i1)))- sum(exp(1i*2*pi*V2/lambda(i1))); 

            c(i1,i2) = abs(ft); 
        end
    end

end
   
   
