function [X,GX] = Find_Collisions_Scenario_2(r0,folder_name)

    X = []; 
    GX = []; 
    
    z = 1; 
    
    %% Session 1
    for i_file = 1:2
        
        file_name = strcat(folder_name,'SCENARIO_2_SESSION_1_TRIAL_',num2str(i_file),'.csv');
        [Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);

        Ya(Ya==0) = 1000; 
        Yb(Yb==0) = -1000; 

        

        for i1 = 1:n_A
            for i2 = 1:n_B
                DX = Xa(i1,:)-Xb(i2,:); 
                DY = Ya(i1,:)-Yb(i2,:); 
                D = sqrt(DX.^2+DY.^2); 

                meet = find(D<r0& D>0,1);
                part = find(DY>0 & D<r0,1) ;

                if isempty(meet)==0 && isempty(part)==0             
                       X(z) = DX(meet); 
                       GX(z) = .5*(DX(part)-DX(meet)); 
                       z = z+1; 
                end
            end
        end
    end
    
    
  for i_file = 1:5
        
        file_name = strcat(folder_name,'SCENARIO_2_SESSION_2_TRIAL_',num2str(i_file),'.csv');
        [Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);


        Ya(Ya==0) = 1000; 
        Yb(Yb==0) = -1000; 

        for i1 = 1:n_A
            for i2 = 1:n_B
                DX = Xa(i1,:)-Xb(i2,:); 
                DY = Ya(i1,:)-Yb(i2,:); 
                D = sqrt(DX.^2+DY.^2); 
                touch(i1,i2) = min(D); 
                
                meet = find( D<r0& D>0,1);
                part = find(DY>0 & D<r0,1) ;

                if isempty(meet)==0 && isempty(part)==0             
                       X(z) = DX(meet); 
                       GX(z) = .5*(DX(part)-DX(meet)); 
                       z = z+1; 
                end

            end
        end
  end
      
  
end
