%% Collision intference parameters

r_coll =1; % Interaction diameter in meters

% Choose Scenario (1 - classic or 2 - chiral)
[X,GX] = Find_Collisions_Scenario_1(r_coll,'.\Trajectories_Flip\'); 
% [X,GX] = Find_Collisions_Scenario_2(r_coll,'\\myfiles\kab77\dos\Pedestrians\Data\Repository\Trajectories_Flip\'); 

% Delete spurious collisions (displacement larger than 0.6m for Scenario 1 )
f = find (abs(GX)>.3) ; %set to >.6 for chiral Scenario 2
GX(f) = []; 
X(f) = []; 


%% Binning 
n_bins = 51; % Number of bins for the statistics plot
dx = 2*r_coll/n_bins; % Bin width
x_hist = linspace(-r_coll+dx/2,r_coll-dx/2,n_bins); % Bin centres
[bin_gx_mean,bin_gx_sd] = bin_statistics(X,GX,r_coll,n_bins); % See below


%% Plotting
Plot_Shade(x_hist,bin_gx_mean,sqrt(bin_gx_sd),[1 .8 .8]), hold on 
plot(X,GX,'.','color',[.5 .4 .4],'MarkerSize',10), hold on 
plot(x_hist,bin_gx_mean,'r','LineWidth',3) 


xlabel('$x(\mbox{m})$','interpreter','latex')
ylabel('$G_x(\mbox{m})$','interpreter','latex')
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
box on 
grid on 
axis([-r_coll r_coll -.3 .3])
pbaspect([1.2 1 1])

function [bin_mean,bin_sd] = bin_statistics(x1,y1,r1,n_bins)

    dx  = 2*r1/n_bins; 
    bin_mean =zeros(1,n_bins); 
    bin_sd = zeros(1,n_bins);

    for i1 = 1:n_bins
        f = x1>=((i1-1)*dx-r1) & x1<(i1*dx-r1) ; 
        bin_mean(i1) = nanmean(y1(f)); 
        bin_sd(i1) = nanvar(y1(f)); 
        if isempty(y1(f))==1
            bin_mean(i1) = 0; 
            bin_sd(i1) = 0; 
        end
    end

    bin_sd = smooth(bin_sd)'; 
    bin_mean = smooth(bin_mean)'; 

end
