
function [Sa_av,Sb_av,SF_av,n_t] = Density_Bins(file_name,n,dx)

    z = 2.9/n; 
    x = linspace(-2.9 + z,2.9-z,n); 
    Sa = zeros(n,n); 
    Sb = zeros(n,n); 

    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    s = size(Ya); 
    t = s(2); 
    
    % Check number of people within the arena
    for i1 = 1:t
        n_t(i1) = .5*(length(find(abs(Ya(:,i1))<2.9 &abs(Ya(:,i1))>0 )) + length(find(abs(Yb(:,i1))<2.9 &abs(Yb(:,i1))>0 ))  );
    end
    
    % Determine start and end time 
    t_0 = find(n_t>10,1); 
    t_1 = find(n_t>10,1,'last'); 
    t_max = t_1-t_0;

    
    % Go through the grid and count people
    for i2 = 1:t_max   
        for n1 = 1:n
            for n2 = 1:n
                
               fa = find(  (( (Xa(:,i2+t_0)-x(n1)).^2 + (Ya(:,i2+t_0)-x(n2)).^2 )<.25*dx*dx) & abs(Ya(:,i2+t_0))>0  );
               Sa(n2,n1,i2) = length(fa); 
               
               fb = find(( ((Xb(:,i2+t_0)-x(n1)).^2 + (Yb(:,i2+t_0)-x(n2)).^2 )<.25*dx*dx) & abs(Yb(:,i2+t_0))>0  );
               Sb(n2,n1,i2) = length(fb);
               
            end
        end
    end
    
    
  
    SF = sign(Sa.*Sb); 

    Sa_av = nanmean(Sa,3); 
    Sb_av = nanmean(Sb,3); 
    SF_av = nanmean(SF,3);
end