n = 50; % Grid mesh
x = linspace(-2.9 + 2.9/n,2.9-2.9/n,n); 
r = 1; % Radius        

folder_name = '.\Trajectories_Flip\'; 
scenario = 6; 


Sa = zeros(n,n); 
Sb = zeros(n,n);
F = zeros(n,n);

for i_trial = 1:6
    [Sa_av,Sb_av,F_av] = Density_Bins(strcat(folder_name,'SCENARIO_',num2str(scenario),...
        '_SESSION_1_TRIAL_',num2str(i_trial),'.csv'),n,r);
    Sa = Sa + Sa_av; 
    Sb = Sb + Sb_av; 
    F = F + F_av; 
end

for i_trial = 1:5
    [Sa_av,Sb_av,F_av] = Density_Bins(strcat(folder_name,'SCENARIO_',num2str(scenario),...
        '_SESSION_2_TRIAL_',num2str(i_trial),'.csv'),n,r);
    Sa = Sa + Sa_av; 
    Sb = Sb + Sb_av; 
    F = F + F_av; 
end


Sa = Sa/11; 
Sb = Sb/11; 
F = F/11; 


Sa = Sa/(.25*pi*r^2);
Sb = Sb/(.25*pi*r^2);



%% Figure 1

figure

contour(x,x,Sa,.5:.25:2,'ShowText','on','color','r'), hold on 


set(gca,'YDir','normal')
cmocean('-gray')

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
axis([-2.9 2.9 -2.9 2.9])

box on 
plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
if scenario ==4
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',7,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',7,'Color','b')
elseif scenario==5
    plot(-[2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',3,'Color','r')
    plot(-[2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
elseif scenario ==6   
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot(linspace(-2.9,2.9,5),2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot(linspace(-2.9,2.9,5),-2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
end
    

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')


%% Figure 2

figure

contour(x,x,Sb,.5:.25:2,'ShowText','on','color','b'), hold on 

set(gca,'YDir','normal')
cmocean('-gray')

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
axis([-2.9 2.9 -2.9 2.9])

box on 
plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
if scenario ==4
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',7,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',7,'Color','b')
elseif scenario==5
    plot(-[2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',3,'Color','r')
    plot(-[2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
elseif scenario ==6   
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot(linspace(-2.9,2.9,5),2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot(linspace(-2.9,2.9,5),-2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
end
    
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')




%% Figure 3

figure

contour(x,x,F,0:.1:.5,'ShowText','on','color','k'), hold on 

set(gca,'YDir','normal')
cmocean('-gray')

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
axis([-2.9 2.9 -2.9 2.9])

box on 
plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
if scenario ==4
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',7,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',7,'Color','b')
elseif scenario==5
    plot(-[2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')
    plot( [-.5 .5],[2.9 2.9],'^','LineWidth',3,'Color','r')
    plot(-[2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
elseif scenario ==6   
    plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
    plot(linspace(-2.9,2.9,5),2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot(linspace(-2.9,2.9,5),-2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
    plot([2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')
end

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')






