clear

folder_name = '.\Trajectories_Raw\'; 



%% Session 1, Scenario 1
n_mean = zeros(160,5); 

for i_file = 1:5 
    n_t = []; 
    file_name = strcat(folder_name,'SCENARIO_1_SESSION_1_TRIAL_',num2str(i_file),'.csv'); 
    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    s = size(Ya); 
    t = s(2); 
    
    for i1 = 1:t
        n_t(i1) = (length(find(abs(Ya(:,i1))<2.9 &abs(Ya(:,i1))>0 )) + length(find(abs(Yb(:,i1))<2.9 &abs(Yb(:,i1))>0 ))  );
    end
    
   
    t_0 = find(n_t>20,1); 
    
    n_mean((100-t_0):(100+t-t_0-1),i_file) =  n_t(1:t);
    
end

m1_str = mean(n_mean,2);
s1_str = sqrt(var(n_mean,0,2));

%% Session 2, Scenario 1
n_mean = zeros(160,5); 

for i_file = 1:5
n_t = []; 
    file_name = strcat(folder_name,'SCENARIO_1_SESSION_2_TRIAL_',num2str(i_file),'.csv'); 
    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    s = size(Ya); 
    t = s(2); 
    
    for i1 = 1:t
        n_t(i1) = (length(find(abs(Ya(:,i1))<2.9 &abs(Ya(:,i1))>0 )) + length(find(abs(Yb(:,i1))<2.9 &abs(Yb(:,i1))>0 ))  );
    end
    
   
    t_0 = find(n_t>20,1); 
    n_mean((100-t_0):(100+t-t_0-1),i_file) =  n_t(1:t);
    
end

m2_str = mean(n_mean,2);
s2_str = sqrt(var(n_mean,0,2));



%% Session 1, Scenario 2
n_mean = zeros(160,2); 

for i_file = 1:2
    n_t = []; 
    file_name = strcat(folder_name,'SCENARIO_2_SESSION_1_TRIAL_',num2str(i_file),'.csv'); 
    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    s = size(Ya); 
    t = s(2); 
    
    for i1 = 1:t
        n_t(i1) = (length(find(abs(Ya(:,i1))<2.9 &abs(Ya(:,i1))>0 )) + length(find(abs(Yb(:,i1))<2.9 &abs(Yb(:,i1))>0 ))  );
    end
    
   
    t_0 = find(n_t>20,1); 
    
    n_mean((100-t_0):(100+t-t_0-1),i_file) =  n_t(1:t);
    
end

m1_chi = mean(n_mean,2);
s1_chi = sqrt(var(n_mean,0,2));


%% Session 2, Scenario 2
n_mean = zeros(160,5);

for i_file = 1:5
    n_t = []; 
    file_name = strcat(folder_name,'SCENARIO_2_SESSION_2_TRIAL_',num2str(i_file),'.csv'); 
    [Xa,Ya,Xb,Yb] = Read_In_Trajectories(file_name);

    s = size(Ya); 
    t = s(2); 
    
    for i1 = 1:t
        n_t(i1) = (length(find(abs(Ya(:,i1))<2.9 &abs(Ya(:,i1))>0 )) + length(find(abs(Yb(:,i1))<2.9 &abs(Yb(:,i1))>0 ))  );
    end
    
   
    t_0 = find(n_t>20,1); 
    
    n_mean((100-t_0):(100+t-t_0-1),i_file) =  n_t(1:t);
    
end

m2_chi = mean(n_mean,2);
s2_chi = sqrt(var(n_mean,0,2));

%% Plots

n1_chi = length(m1_chi); 
n2_chi = length(m2_chi); 

n1_str = length(m1_str); 
n2_str = length(m2_str); 


%% Session 1
figure, hold on, box on 

t = (1:n1_chi)/10 -10;
Plot_Shade(t,m1_chi',s1_chi',[1 .8 .8]), hold on 

t = (1:n1_str)/10 -10;
Plot_Shade(t,m1_str',s1_str',[.8 .8 .8]), hold on 

t = (1:n1_chi)/10 -10;
plot(t,m1_chi,'r','LineWidth',2);
t = (1:n1_str)/10 -10;
plot(t,m1_str,'k','LineWidth',2);

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
xlabel('$t~(\mbox{s})$','interpreter','latex')
ylabel('$n^+ + n^-$','interpreter','latex')
title('Session 1 (60 participants)','interpreter','latex')

axis([-5 20 0 50])
grid on, grid minor

pbaspect([2 1 1])

%% Session 2


figure, hold on, box on 



t = (1:n2_chi)/10 -10;
Plot_Shade(t,m2_chi',s2_chi',[1 .8 .8]), hold on 
t = (1:n2_str)/10 -10;
Plot_Shade(t,m2_str',s2_str',[.8 .8 .8]), hold on 

t = (1:n2_chi)/10 -10;
plot(t,m2_chi,'r','LineWidth',2);
t = (1:n2_str)/10 -10;
plot(t,m2_str,'k','LineWidth',2);

% 
% legend({'no bias','chiral',...
%     'Session 2 (72 participants), no bias','Session 2 (72 participants), chiral'},'interpreter','latex')

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
xlabel('$t~(\mbox{s})$','interpreter','latex')
ylabel('$n^+ + n^-$','interpreter','latex')
title('Session 2 (72 participants)','interpreter','latex')
axis([-5 20 0 50])
grid on, grid minor

 pbaspect([2 1 1])
