clear
folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_3_SESSION_1_TRIAL_1.csv'); 
[Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);

frame_no = 90; 


figure, hold on, box on 



%% Plot coloured background
patch([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],1*[1 .8 .8])

b_vec = [-3 -1 1 2 ];
x = [-2.9 2.9];

i1 = 1; 
for b = b_vec

 if i1>1 
     prev_y = y;
 end
 
 y = -x + b; 
 
    if mod(i1,2)==0
        patch([x fliplr(x)],[prev_y fliplr(y)],1*[.8 .8 1],'EdgeColor','none')
    end   
 
 i1 =i1+1;
end

%% Plot pedestrian positions
plot(Xb(:,frame_no),Yb(:,frame_no),'o','Color','r','MarkerFaceColor','r','MarkerSize',12)
plot(Xa(:,frame_no),Ya(:,frame_no),'o','Color','b','MarkerFaceColor','b','MarkerSize',12)

 


plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
pbaspect([1 1 1]);
axis([-2.9 2.9, -2.9 2.9]); 
    

set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')

