clear

folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_3_SESSION_1_TRIAL_1.csv'); 

% Fig 4B
v = 0;
theta = 0;
x0 = 0; 
ax_lim = 2.9; 
% 
% % Fig 4C
% v = 0.5; 
% theta = pi/4; 
% x0 = 4.5; 
% ax_lim = 5; 




[Xa,Ya,Xb,Yb,na,nb] = Read_In_Trajectories(file_name);
n_frames = length(Xa);
T= .1*(1:n_frames); 

figure, hold on, box on, grid on 

   for i_person = 1:na
       f = find(abs(Xa(i_person,:))>0);
       [X,Y] = frame_change(Xa(i_person,f),Ya(i_person,f),v,theta,x0,T(f));    
       plot(X,Y,'Color','r','LineWidth',1.5);
   end
   for i_person = 1:nb
       f = find(abs(Xb(i_person,:))>0);
       [X,Y] = frame_change(Xb(i_person,f),Yb(i_person,f),v,theta,x0,T(f)); 
       plot(X,Y,'Color','b','LineWidth',1.5); 
   end
   
   
axis([-ax_lim ax_lim, -ax_lim ax_lim]);
plot([-ax_lim ax_lim ax_lim -ax_lim -ax_lim],[-ax_lim -ax_lim ax_lim ax_lim -ax_lim],'LineWidth',3,'color','k')
  
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')
    
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
   
yticks([-ax_lim 0 ax_lim])
xticks([-ax_lim 0 ax_lim])

pbaspect([1 1 1]);


function [X_new_r,Y_new_r] = frame_change(X,Y,v,theta,x0,T)


       Y_new = Y - v*T + x0; 
       X_new = X - v*T + x0; 
       X_new_r = cos(theta)*X_new + sin(theta)*Y_new; 
       Y_new_r = -sin(theta)*X_new + cos(theta)*Y_new; 

end
