clear
folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_4_SESSION_1_TRIAL_1.csv'); 
[Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);


frame_no = 145;


figure, hold on, box on 



d_foci = .5*sqrt(2*2.9^2);
zero_x = 2.9 - .5*2.9;
zero_y = 2.9 - .5*2.9; 
Theta_vec = linspace(-pi,pi,100); 
b_vec =  [ 7 5 4.5 3.25 2.5 1.5 1 .25 ];

i1 = 1;
for b = b_vec


 if i1>1 
     prev_y = y;
     prev_x = x; 
 end
 
 
    a = sqrt(b^2+(d_foci)^2);  
        X = (a*cos(Theta_vec));
    Y = (b*sin(Theta_vec));
    
    
    rX = cos(.25*pi)*X +sin(.25*pi)*Y; 
    rY = - sin(.25*pi)*X +cos(.25*pi)*Y; 

 
     x = rX+zero_x; 
     y = rY+zero_y;

    
    if mod(i1,2)==1
        patch(x,y,1*[.8 .8 1],'EdgeColor','none')
    else
        patch(x,y,1*[1 .8 .8 ],'EdgeColor','none')

    end
 i1 =i1+1;
end


plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
plot([0 2.9],[2.9 0],'--','color','k')

plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')

plot( [-.5 .5],[2.9 2.9],'^','LineWidth',7,'Color','r')
plot([2.9 2.9],[-.5 .5],'>','LineWidth',7,'Color','b')

    
   
    
plot(Xa(:,frame_no),Ya(:,frame_no),'o','Color','r','MarkerFaceColor','r','MarkerSize',12)
plot(Xb(:,frame_no),Yb(:,frame_no),'o','Color','b','MarkerFaceColor','b','MarkerSize',12)




pbaspect([1 1 1]);
axis([-2.9 2.9, -2.9 2.9]); 
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')

