clear
folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_5_SESSION_1_TRIAL_4.csv'); 
[Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);


frame_no = 90;

figure, hold on, box on 


d_foci = .5*sqrt(2*2.9^2);
zero_x = -2.9 + .25*2.9;
zero_y = 2.9 - .25*2.9; 
Theta_vec = linspace(-pi/2,pi/2,100); 
patch([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],1*[.8 .8 1])

a_vec =  [0  .1  .4 .8 1.2 1.35 1.5 1.75 2.05]; 

i1 = 1; 
for a = a_vec


 if i1>1 
     prev_y = y;
     prev_x = x; 
 end
    b = sqrt((d_foci)^2 - a^2 ); 
    X1 = (a./cos(Theta_vec));
    Y1 = (b.*tan(Theta_vec));
    X2 = (-a./cos(Theta_vec));
    
    rX1 = cos(.25*pi)*X1 -sin(.25*pi)*Y1; 
    rX2 = cos(.25*pi)*X2 -sin(.25*pi)*Y1; 
    rY1 = sin(.25*pi)*X1 +cos(.25*pi)*Y1; 
    rY2 = sin(.25*pi)*X2 +cos(.25*pi)*Y1; 

 
 x = rX2+zero_x; 
 y = rY2+zero_y;
 
    f= find(abs(x)<5 & abs(y)<5); 
    x = x(f); 
    y = y(f); 
    
    if mod(i1,2)==0
        patch([x fliplr(prev_x) x(1)],[y fliplr(prev_y) y(1)],1*[1 .8 .8],'EdgeColor','none')
        
    end
    
   
 i1 =i1+1;
end

i1 = 1;


for a = a_vec


 if i1>1 
     prev_y = y;
     prev_x = x; 
 end
    b = sqrt((d_foci)^2 - a^2 ); 
    X1 = (a./cos(Theta_vec));
    Y1 = (b.*tan(Theta_vec));
    X2 = (-a./cos(Theta_vec));
    
    rX1 = cos(.25*pi)*X1 -sin(.25*pi)*Y1; 
    rX2 = cos(.25*pi)*X2 -sin(.25*pi)*Y1; 
    rY1 = sin(.25*pi)*X1 +cos(.25*pi)*Y1; 
    rY2 = sin(.25*pi)*X2 +cos(.25*pi)*Y1; 

 
 x = rX1+zero_x; 
 y = rY1+zero_y;
 
    f= find(abs(x)<5 & abs(y)<5); 
    x = x(f); 
    y = y(f); 
    
    if mod(i1,2)==0
        patch([prev_x fliplr(x) prev_x(1)],[prev_y fliplr(y) prev_y(1)],1*[1 .8 .8 ],'EdgeColor','none')
    end
 
 i1 =i1+1;
end

plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
plot(-[2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
plot([-.5 .5],[2.9 2.9],'-','LineWidth',5,'Color','white')

plot( [-.5 .5],[2.9 2.9],'^','LineWidth',3,'Color','r')
plot(-[2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')


plot(Xa(:,frame_no),Ya(:,frame_no),'o','Color','r','MarkerFaceColor','r','MarkerSize',12)
plot(Xb(:,frame_no),Yb(:,frame_no),'o','Color','b','MarkerFaceColor','b','MarkerSize',12)

pbaspect([1 1 1]);
axis([-2.9 2.9, -2.9 2.9]); 
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')

