clear
folder_name = '.\Trajectories_Flip\'; 
file_name = strcat(folder_name,'SCENARIO_6_SESSION_1_TRIAL_5.csv'); 
[Xa,Ya,Xb,Yb,n_A,n_B] = Read_In_Trajectories(file_name);

frame_no = 110;


figure, hold on, box on 


b_vec = [-10  -9   -7   -5.5   -4   -2.5   -.5  -0.0500];
n_b = length(b_vec); 
x = linspace(-2.9,2.9,100); 
x_f = 2.9; 
patch([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],1*[.8 .8 1])

for i1 = 1:n_b
    if i1>1 
     prev_y = y; 
    end
    b = b_vec(i1) ;
    y = -(.5/b)*(x-x_f).^2 + .5*b;
    
    if mod(i1,2)==0
        patch([x fliplr(x) x(1)],[max(prev_y,-2.9) fliplr(y),prev_y(1)],1*[1 .8 .8 ],'EdgeColor','none')
    end
    
end

plot([-2.9 2.9 2.9 -2.9 -2.9],[-2.9 -2.9 2.9 2.9 -2.9],'LineWidth',3,'color','k')
plot([2.9 2.9],[-.5 .5],'-','LineWidth',5,'Color','white')
plot(linspace(-2.9,2.9,5),2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
plot(linspace(-2.9,2.9,5),-2.9*ones(1,5),'-^','LineWidth',3,'Color','r')
plot([2.9 2.9],[-.5 .5],'>','LineWidth',5,'Color','b')


plot(Xa(:,frame_no),Ya(:,frame_no),'o','Color','r','MarkerFaceColor','r','MarkerSize',12)
plot(Xb(:,frame_no),Yb(:,frame_no),'o','Color','b','MarkerFaceColor','b','MarkerSize',12)


pbaspect([1 1 1]);
axis([-2.9 2.9, -2.9 2.9]); 
      
    
set(gca, 'FontSize', 15)
set(gca,'TickLabelInterpreter','latex')
yticks([-2.9 0 2.9])
xticks([-2.9 0 2.9])
xlabel('$x$ (m)','interpreter','latex')
ylabel('$y$ (m)','interpreter','latex')

