"""
Analyse a top level folder of psf scans. Should contain 2 folders, horiz and vert.
Each one should contain a series of folders, each containing z-stacks of edge images,
to recover resolution and field curvature.

"""
import os
import sys

import analyse_edge_zstacks

def analyse(containing_dir):
    for direction in ['vert', 'horiz']:
        try:
            containing_dir = os.path.join(path, direction)
            fnames = [f for f in os.listdir(containing_dir) if os.path.isdir(os.path.join(containing_dir, f))]
            
            for stacks in fnames:
                analyse_edge_zstacks.analyse_zstack(os.path.join(containing_dir, stacks))
        except Exception as e:
            print(e)
            pass

if __name__ == "__main__":
    try:
        paths = sys.argv[1:]
        print(paths)
        for path in paths:
            analyse(path)
    except:
        print("Usage: {} <folder> [<folder> ...]".format(sys.argv[0]))
        print("This script expects arguments that are folders, containing jpeg files of edge images.")
        print("This scripts creates a number of PDF plots based on said images, per folder.")