//
//  trajreader.h
//  
//
//  Created by Ian Thompson on 12/07/2012a
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#ifndef _trajreader_h
#define _trajreader_h

#include<iostream>
#include<fstream>
#include<cstdio>
#include<cmath>
#include<ctime>
#include<cstdlib> // for drand48() to go between 0 and 1
#include<cstring>
#include<string>
#include<sstream>
#include<unistd.h>

using namespace std;
//using namespace boost::xpressive;

#define pi 3.14159265 
#define e 2.71828183
#define SPECIES 1
#define DIMENSIONS 1
#define BROWNT 10000
#define V "V"
#define P "P"


class trajectory{    
public:
    
    trajectory(char filename[],int slices,double statep,int N,string reg,int numfiles_rank,int num,int rank);
    trajectory(trajectory *copy);
    void pullactivemiddleslice(double sval,int tps,int num,char cwd[],double statepoint);
	void convert_to_draw(char filename[]);
    void pullinactivemiddleslice(double sval,int tps,int num,char cwd[],double statepoint);    
    void calc_deltacofm();
    double totalactivity,dimension,Ntobs;
    double *activity;
    double *redpressure;
    double *volumes;
    double *energies;
    double *accepts;
	double *Sk,*sep_k,*kvectors;
	double *rho_r,max_rho_r;
    double **deltacofm;
    double ***positions;
    double ***displacements;
	double ***subsystem_occupancy;
    int **species;
    double **MSD;
    double **fkt;
    double **fktsq;
    double **chi4;
    double **averagegr,**averagesr; 
    int numslices,numbins,particles;
    int fileposition,jobid;
    double statepoint,trajenergy,trajvolume;
    string regime;
	bool IDEAL_GAS_GR;
    
    void copytraj(trajectory *copy);
    void rebuildtrajectory();
    double getsquare(double x, double y, double z);
    int inputtraj(int time, int tpsequil,double s,int filepos,int rank);
    double getdisplacement(int slice,int particle);
	void convert_to_points(double diameter);
	void convert_to_clumps();
	void resize_clump(double clump_volume);
    void get_gr(double binsize,int numbins);
	void get_rho_r(int nbins,double binwidth);
	void get_max_rho_r(int nbins);
    void get_sepr(double binsize,int numbins);
	void get_S_k(int klength);
    void get_sep_k(int klength ,double *kvectors);
	void HU_box_counting(double *sys_sizes,int num_sizes);
};

int **alloc_2d_int(int rows, int cols) {
    int *data = (int *)malloc(rows*cols*sizeof(int));
    int **array= (int **)malloc(rows*sizeof(int*));
    for (int i=0; i<rows; i++)
        array[i] = &(data[cols*i]);
    
    for(int j=0;j<rows;j++){
        for(int k=0;k<cols;k++){
            array[j][k]=0;
        }
    }
    
    return array;
}

double **alloc_2d_double(int rows, int cols) {
    double *data = (double *)malloc(rows*cols*sizeof(double));
    double **array= (double **)malloc(rows*sizeof(double*));
    for (int i=0; i<rows; i++)
        array[i] = &(data[cols*i]);
    
    for(int j=0;j<rows;j++){
        for(int k=0;k<cols;k++){
            array[j][k]=0.0;
        }
    }
    
    return array;
}

double ***alloc_3d_double(int channels, int rows, int cols){
    int i,j,k;
    double *data = (double *)malloc(rows*cols*channels*sizeof(double));
    double **array= (double **)malloc(rows*channels*sizeof(double*));
    double ***block= (double ***)malloc(channels*sizeof(double**));
    for(i=0;i<(rows*channels);i++){
        array[i]=&(data[cols*i]);
    }
    for (i=0; i<channels; i++){
        block[i] = &(array[rows*i]);
    }
    
    for(i=0;i<channels;i++){
        for(j=0;j<rows;j++){
            for(k=0;k<cols;k++){
                block[i][j][k]=0.0;
            }
        }
    }
    
    
    return block;
}

int* delete_int_ptr(int *ptr){
		delete[] ptr;
		return NULL;
}
double* delete_dbl_ptr(double *ptr){
		delete[] ptr;
		return NULL;
}
char* delete_char_ptr(char *ptr){
		delete[] ptr;
		return NULL;
}

int delete_2d_int(int **array) {
    free(array[0]);
    free(array);
    return 0;
}

double delete_2d_double(double **array) {
    free(array[0]);
    free(array);
    return 0;
}

double delete_3d_double(double ***array) {
    free(array[0][0]);
    free(array[0]);
    free(array);
    return 0;
}
           
void delete_traj(trajectory *traj){
    if(traj->activity)delete traj->activity;
    if(traj->redpressure)delete traj->redpressure;
    if(traj->volumes)delete traj->volumes;
    if(traj->energies)delete traj->energies;
    if(traj->accepts)delete traj->accepts;
	if(traj->Sk)delete traj->Sk;
	if(traj->kvectors)delete traj->kvectors;
	if(traj->sep_k)delete traj->sep_k;
	if(traj->rho_r)delete traj->rho_r;
	if(traj->averagegr)delete_2d_double(traj->averagegr);
	if(traj->averagesr)delete_2d_double(traj->averagesr);
    delete_3d_double(traj->positions);
    delete_3d_double(traj->displacements);
    delete_2d_int(traj->species);
    delete_2d_double(traj->deltacofm);
    delete_2d_double(traj->MSD);
    delete_2d_double(traj->fkt);
    delete_2d_double(traj->fktsq);
    delete_2d_double(traj->chi4);
    delete traj;
}

char **alloc_2d_char(int rows, int cols){
    char *data = (char *)malloc(rows*cols*sizeof(char));
    char **array= (char **)malloc(rows*sizeof(char*));
    for(int i=0;i<rows;i++){
        array[i]=&(data[cols*i]);
    }
    return array;
}
  
void average_volumes(trajectory **inputs, int length, int slices,double *avvolume, double *avvolume_sq){
	double avvol,avvol2,v;
	avvol=avvol2=0.0;
	for(int traj=0;traj<length;traj++){
		   for(int slice=slices/4;slice<(slices*3)/4;slice++){
				v=inputs[traj]->volumes[slice];//+(double)inputs[traj]->particles; 
				avvol+=v;
				avvol2+=(v*v);
		   }
	}
	avvol=avvol/((double)slices*0.5*(double)length);
	avvol2=avvol2/((double)slices*0.5*(double)length);
	*avvolume=avvol;
	*avvolume_sq=avvol2;
}

void init_trajreader(char *argv[],int *particles,int *slices,double *s,int *TPSmoves,double *statepoint){
    std::stringstream convertpart(argv[2]);
    convertpart>>*particles;
    std::stringstream convertslices(argv[3]);
    convertslices>>*slices;
    std::stringstream convertsval(argv[4]);
    convertsval>>*s;    
    std::stringstream convertTPS(argv[5]);
    convertTPS>>*TPSmoves;
    std::stringstream convertstate(argv[6]);
    convertstate>>*statepoint;
}

void trajectory::convert_to_draw(char filename[]){
	ofstream outfile;
	int skip=3;
	double halfdim,pos,prev,diff,lastpos;
	char path[1000];
	strcpy(path,"DRAW");
	strcat(path,filename);
	strcat(path,".xyz");
	outfile.open(path);
	outfile<<ceil((double)numslices/(double)skip)<<'\t'<<particles<<endl;
	lastpos=0.0;
	for(int sl=0;sl<numslices;sl+=skip){
			halfdim=(volumes[sl]/2.0);
			//diff=halfdim-fabs(lastpos);
		//	if(lastpos>=0)diff=halfdim-lastpos;
			diff=halfdim-lastpos;
			outfile<<diff<<'\t'<<volumes[sl]<<endl;
			for(int p=0;p<particles;p++){
				if(p==0){
					    pos=positions[sl][p][0]+halfdim;
						outfile<<0<<'\t'<<pos<<'\t'<<0.0<<endl;	
						prev=positions[sl][p][0];
				}
				else{
					pos=positions[sl][p][0]-prev;
					outfile<<0<<'\t'<<pos<<'\t'<<0.0<<endl;	
					prev=positions[sl][p][0];
					if(p==(particles-1))lastpos=positions[sl][p][0];
				}
			}
	}
	outfile.close();
}

void sort_trajectories(double uplimit, double lowerlimit, trajectory **inputs, int length, trajectory **activelist, int *activelength, trajectory **inactivelist, int *inactivelength){
    int i,activeindex,inactiveindex;
    double currentactivity;
    inactiveindex=activeindex=0;
 
    for(i=0;i<length;i++){
        currentactivity=inputs[i]->totalactivity;
        if(currentactivity>uplimit){
		//std::cout<<"copying active"<<std::endl;
	    activelist[activeindex]=new trajectory((inputs[i]));
            activeindex++;
        }
        if(currentactivity<lowerlimit){
	  	//std::cout<<"copying inactive"<<std::endl;
            inactivelist[inactiveindex]=new trajectory((inputs[i]));
            inactiveindex++;
        }
    }
    *inactivelength=inactiveindex;
    *activelength=activeindex;
}

double** averagepositions(trajectory **inputs, int length, int slices,int particles){
    double **avpos,total_slices=0.0;
    avpos=alloc_2d_double(particles,2);
    for(int p=0;p<particles;p++){
	    for(int i=0;i<2;i++)avpos[p][i]=0.0;
    }
    for(int i=0;i<length;i++){
        for(int slice=0;slice<inputs[i]->numslices;slice++){
			total_slices+=1.0;
            for(int p=0;p<particles;p++){
		    avpos[p][1]+=(inputs[i]->positions[slice][p][0]*inputs[i]->positions[slice][p][0]);
		    avpos[p][0]+=inputs[i]->positions[slice][p][0];
            }
        }
    }
    for(int p=0;p<particles;p++){
	    avpos[p][0]=avpos[p][0]/total_slices;
	    avpos[p][1]=avpos[p][1]/total_slices;
	    avpos[p][1]=avpos[p][1]-(avpos[p][0]*avpos[p][0]);
    }
    return avpos;
}

double** reducefkttrajs(trajectory **inputs, int length, int slices){
    int i,slice,type;
    double **finalfkt;
    finalfkt=alloc_2d_double(slices,SPECIES);
    
    for(i=0;i<length;i++){
        for(slice=0;slice<slices;slice++){
            for(type=0;type<SPECIES;type++){
                finalfkt[slice][type]+=inputs[i]->fkt[slice][type];
            }
        }
    }
    for(slice=0;slice<slices;slice++){
        for(type=0;type<SPECIES;type++){
            finalfkt[slice][type]=finalfkt[slice][type]/(double)length;
        }
    }
    return finalfkt;
}

double** reduceMSDtrajs(trajectory **inputs, int length, int slices){
    int i,slice,type;
    double **finalMSD;
    finalMSD=alloc_2d_double(slices,SPECIES);
    
    for(i=0;i<length;i++){
        for(slice=0;slice<slices;slice++){
            for(type=0;type<SPECIES;type++){
                finalMSD[slice][type]+=inputs[i]->MSD[slice][type];
            }
        }
    }
    for(slice=0;slice<slices;slice++){
        for(type=0;type<SPECIES;type++){
            finalMSD[slice][type]=finalMSD[slice][type]/(double)length;
        }
    }
    return finalMSD;
}

double* reduceKtrajs(trajectory **inputs, int length, int slices){
    double *finalK;
    finalK=new double[slices];

    for(int slice=0;slice<slices;slice++){
	    finalK[slice]=0.0;
	    for(int i=0;i<length;i++){
            	finalK[slice]+=inputs[i]->activity[slice];
        }
    }
    for(int slice=0;slice<slices;slice++) finalK[slice]=finalK[slice]/(double)length;
    return finalK;
}

double* reducevoltrajs(trajectory **inputs, int length, int slices){
    double *finalvol;
    finalvol=new double[slices];
    for(int slice=0;slice<slices;slice++){
		finalvol[slice]=0.0; 
    	for(int i=0;i<length;i++){
            finalvol[slice]+=inputs[i]->volumes[slice];
        }
        finalvol[slice]=finalvol[slice]/(double)length;
	    //cout<<finalvol[slice]<<endl;
    }
    return finalvol;
}

double getaverageK(trajectory **inputs,int length){
    double averageK;
    averageK=0;
    for(int i=0;i<length;i++){
        averageK+=inputs[i]->totalactivity;
    }
    averageK=averageK/(double)length;
    return averageK;
}

double getaveragevol(trajectory **inputs,int length){
    double averagevol;
    averagevol=0;
    for(int i=0;i<length;i++){
        averagevol+=inputs[i]->trajvolume;
    }
    averagevol=averagevol/(double)length;
    return averagevol;
}

double* gettotalKlist(trajectory **inputs,int length){
    double *totK;
    int i;
    totK=new double[length];
    for(i=0;i<length;i++){
        totK[i]=inputs[i]->totalactivity;
    }
    return totK;
}

double getmedianK(double *totK,int length, double *minK,double *maxK){
    double medK, sortedK[length];
    int i;
    for(i=0;i<length;i++)sortedK[i]=10000;
    for(i=0;i<length;i++){
        if(totK[i]<sortedK[0])sortedK[0]=totK[i];
    }
    for(int j=1;j<length;j++){
        for(int i=0;i<length;i++){
            if(totK[i]<sortedK[j] && totK[i]>sortedK[j-1])sortedK[j]=totK[i];
        }
    }
    int medindex=floor(length/2.0);
    medK=sortedK[medindex];
    *minK=sortedK[0];
    *maxK=sortedK[length-1];
    return medK;
}

char** gettrajfiles(int *numfiles,char cwd[], char sstr[],char TPSstr[],int rank){
    int i,j,lines;
    char **files;
    char command[600], expression[300],line[300],lsfile[20],rankstr[5];
	strcpy(lsfile,"lsfile");
	snprintf(rankstr,5,"R%i",rank);
	strcat(lsfile,rankstr);
    strcpy(command,"cd ");
    strcat(command,cwd);
    strcat(command,"; ls ");
    
    strcpy(expression,"trajectory");
    strcat(expression,sstr);
    strcat(expression,TPSstr);
    strcat(expression,"*");
    strcat(expression,rankstr);
    //Some stuff that sets s value etc
    
    strcat(command,expression);
	strcat(command," > ");
    strcat(command,lsfile);
    system(command);
    
    std::ifstream infile;
    infile.open(lsfile);
    //fgets piped into each row of a 2d array using my alloc function.
    lines=0;
    while(!infile.eof()){
        infile.getline(line,300);
        lines++;
    }
    *numfiles=lines-1;
    files=alloc_2d_char(lines,300);
    infile.clear();
    infile.seekg(0);
    for(i=0;i<lines;i++){
        infile.getline(&(files[i][0]),300);
    }
    infile.close();
	strcpy(command,"rm ");
	strcat(command,lsfile);
    system(command);
    return files;
}

trajectory::trajectory(trajectory *copy){
    int i,spec,part,dim;
	IDEAL_GAS_GR=copy->IDEAL_GAS_GR;
    particles=copy->particles;
    Ntobs=copy->Ntobs;
    totalactivity=copy->totalactivity;
    fileposition=copy->fileposition;
    jobid=copy->jobid;
    numslices=copy->numslices;
    statepoint=copy->statepoint;
    trajvolume=copy->trajvolume;
    trajenergy=copy->trajenergy;
    regime=copy->regime;
    activity=new double[numslices];
    energies=new double[numslices];
    redpressure=new double[numslices];
    volumes=new double[numslices];
    accepts=new double[numslices];
    deltacofm=alloc_2d_double(numslices,DIMENSIONS);
    positions=alloc_3d_double(numslices,particles,DIMENSIONS);
    displacements=alloc_3d_double(numslices,particles,DIMENSIONS);
    species=alloc_2d_int(numslices,particles);
    MSD=alloc_2d_double(numslices,SPECIES);
    fkt=alloc_2d_double(numslices,SPECIES);
    fktsq=alloc_2d_double(numslices,SPECIES);
    chi4=alloc_2d_double(numslices,SPECIES);
	Sk=NULL;
	averagegr=NULL;
	averagesr=NULL;
	sep_k=NULL;
	kvectors=NULL;
	rho_r=NULL;
	subsystem_occupancy=NULL;
    
    for(i=0;i<numslices;i++){
	activity[i]=copy->activity[i];
        energies[i]=copy->energies[i];
        redpressure[i]=copy->redpressure[i];
        accepts[i]=copy->accepts[i];
        for(dim=0;dim<DIMENSIONS;dim++){
		deltacofm[i][dim]=copy->deltacofm[i][dim];
	}
	volumes[i]=copy->volumes[i];
        for(spec=0;spec<SPECIES;spec++){
            MSD[i][spec]=copy->MSD[i][spec];
            fkt[i][spec]=copy->fkt[i][spec];
        }
        for(part=0;part<particles;part++){
            species[i][part]=copy->species[i][part];
            for(dim=0;dim<DIMENSIONS;dim++){
		positions[i][part][dim]=copy->positions[i][part][dim];
                displacements[i][part][dim]=copy->displacements[i][part][dim];
            }
        }
    }
}

double get_Skmin(trajectory **inputs,int length){
	double Skmin=0.0;
	for(int traj=0;traj<length;traj++)Skmin+=inputs[traj]->Sk[0];
	Skmin/=(double)length;
	return Skmin;
}

void running_average_K(trajectory **inputs, int length, int slices, int stride){
	double avK,avK_array[slices];
	for(int traj=0;traj<length;traj++){
		for(int t=stride;t<(slices-stride);t++){
			avK=0.0;
			for(int delta=-stride;delta<=stride;delta++)avK+=inputs[traj]->activity[t+delta];
			avK=avK/(((double)stride*2.0)+1.0);
			avK_array[t]=avK;
		}
		for(int t=stride;t<(slices-stride);t++)inputs[traj]->activity[t]=avK_array[t];
	}
}

void running_average_volume(trajectory **inputs, int length, int slices, int stride){
	double av,av_array[slices];
	for(int traj=0;traj<length;traj++){
		for(int t=stride;t<(slices-stride);t++){
			av=0.0;
			for(int delta=-stride;delta<=stride;delta++)av+=inputs[traj]->volumes[t+delta];
			av/=(((double)stride*2.0)+1.0);
			av_array[t]=av;
		}
		for(int t=stride;t<(slices-stride);t++)inputs[traj]->volumes[t]=av_array[t];
	}
}

void get_KKtcorrelation(double *Ktcorrel,trajectory **inputs,int length,int slices){
	double av_Kt[slices/2],av_Kt2[slices/2],av_Kt_Kt_prime[slices/2], avKt,avKt2,av_Kt_prime,av_Kt_prime2,root_prime_var,top,bottom;
	int t_prime=slices/2;
	for(int t=0;t<slices/2;t++)	av_Kt[t]=av_Kt2[t]=0.0;
	for(int traj=0;traj<length;traj++){
		for(int t=0;t<slices/2;t++){
			av_Kt[t]+=inputs[traj]->activity[t_prime+t];
			av_Kt2[t]+=(inputs[traj]->activity[t_prime+t]*inputs[traj]->activity[t_prime+t]);
			av_Kt[t]+=inputs[traj]->activity[t_prime-t];
			av_Kt2[t]+=(inputs[traj]->activity[t_prime-t]*inputs[traj]->activity[t_prime-t]);
		}
	}
	for(int t=0;t<slices/2;t++){
		av_Kt[t]=av_Kt[t]/((double)length*2.0);
		av_Kt2[t]=av_Kt2[t]/((double)length*2.0);
	}
	av_Kt_prime=av_Kt_prime2=0.0;
	for(int traj=0;traj<length;traj++){
		av_Kt_prime+=inputs[traj]->activity[t_prime];
		av_Kt_prime2+=(inputs[traj]->activity[t_prime]*inputs[traj]->activity[t_prime]);
	}
	av_Kt_prime/=(double)length;
	av_Kt_prime2/=(double)length;
	for(int t=0;t<slices/2;t++){
		av_Kt_Kt_prime[t]=0.0;
		for(int traj=0;traj<length;traj++){
			av_Kt_Kt_prime[t]+=inputs[traj]->activity[t_prime+t]*inputs[traj]->activity[t_prime];
			av_Kt_Kt_prime[t]+=inputs[traj]->activity[t_prime-t]*inputs[traj]->activity[t_prime];
		}
		av_Kt_Kt_prime[t]/=(2.0*(double)length);
	}
	for(int t=0;t<slices/2;t++)Ktcorrel[t]=(av_Kt_Kt_prime[t]-(av_Kt_prime*av_Kt[t]))/(av_Kt_prime2-(av_Kt_prime*av_Kt_prime));
	/*
	root_prime_var=sqrt(av_Kt_prime2-(av_Kt_prime*av_Kt_prime));
	for(int t=0;t<slices/2;t++){
		Ktcorrel[t]=0.0;
		for(int traj=0;traj<length;traj++){
			top=(inputs[traj]->activity[t_prime-t]-av_Kt[t]);
			top+=(inputs[traj]->activity[t_prime+t]-av_Kt[t]);
			top/=2.0;
			top*=(inputs[traj]->activity[t_prime]-av_Kt_prime);
			bottom=sqrt(av_Kt2[t]-(av_Kt[t]*av_Kt[t]));
			bottom*=root_prime_var;
			Ktcorrel[t]+=(top/bottom);
		}
		Ktcorrel[t]/=(double)length;
	}*/
}

//t' is fixed reference 
// [ <V(t')V(t)>-<V(t')><V(t)> ]/[ <V(t')^2>-<V(t')>^2 ]
void get_VVtcorrelation(double *Vtcorrel,trajectory **inputs,int length,int slices){
	double av_Vt[slices/2],av_Vt2[slices/2],av_Vt_Vt_prime[slices/2], avVt,avVt2,av_Vt_prime,av_Vt_prime2,root_prime_var,top,bottom;
	int t_prime=slices/2;
	for(int t=0;t<slices/2;t++)av_Vt[t]=av_Vt2[t]=0.0;
	for(int traj=0;traj<length;traj++){
		for(int t=0;t<slices/2;t++){
			av_Vt[t]+=inputs[traj]->volumes[t_prime+t];
			av_Vt[t]+=inputs[traj]->volumes[t_prime-t];
			av_Vt2[t]+=(inputs[traj]->volumes[t_prime+t]*inputs[traj]->volumes[t_prime+t]);
			av_Vt2[t]+=(inputs[traj]->volumes[t_prime-t]*inputs[traj]->volumes[t_prime-t]);
		}
	}
	for(int t=0;t<slices/2;t++){
		av_Vt[t]=av_Vt[t]/((double)length*2.0);
		av_Vt2[t]=av_Vt2[t]/((double)length*2.0);
	}
	av_Vt_prime=av_Vt_prime2=0.0;
	for(int traj=0;traj<length;traj++){
			av_Vt_prime+=inputs[traj]->volumes[t_prime];
			av_Vt_prime2+=(inputs[traj]->volumes[t_prime]*inputs[traj]->volumes[t_prime]);
	}
	av_Vt_prime/=(double)length;
	av_Vt_prime2/=(double)length;
	for(int t=0;t<slices/2;t++){
		av_Vt_Vt_prime[t]=0.0;
		for(int traj=0;traj<length;traj++){
			av_Vt_Vt_prime[t]+=inputs[traj]->volumes[t_prime+t]*inputs[traj]->volumes[t_prime];
			av_Vt_Vt_prime[t]+=inputs[traj]->volumes[t_prime-t]*inputs[traj]->volumes[t_prime];
		}
		av_Vt_Vt_prime[t]/=(2.0*(double)length);
	}
	for(int t=0;t<slices/2;t++)Vtcorrel[t]=(av_Vt_Vt_prime[t]-(av_Vt_prime*av_Vt[t]))/(av_Vt_prime2-(av_Vt_prime*av_Vt_prime));
/*	root_prime_var=sqrt(av_Vt_prime2-(av_Vt_prime*av_Vt_prime));
	for(int t=0;t<slices/2;t++){
		Vtcorrel[t]=0.0;
		for(int traj=0;traj<length;traj++){
			top=(inputs[traj]->volumes[t_prime-t]-av_Vt[t]);
			top+=(inputs[traj]->volumes[t_prime+t]-av_Vt[t]);
			top/=2.0;
			top*=(inputs[traj]->volumes[t_prime]-av_Vt_prime);
			bottom=sqrt(av_Vt2[t]-(av_Vt[t]*av_Vt[t]));
			bottom*=root_prime_var;
			Vtcorrel[t]+=(top/bottom);
		}
		Vtcorrel[t]/=(double)length;
	}*/
}

double** get_KVtcorrelation(trajectory **inputs,int length,int slices){
	double **Vtcorrel;
	double varKV[slices];
//	int counter[slices];
	Vtcorrel=alloc_2d_double(slices,2);;
	double avVt,avkt,avkV,avktprime,Vtktprime,avVtktprime;
	int origin=floor((double)slices/2.0);
	for(int t=0;t<slices;t++){
	//	counter[t]=0;
		avkt=avVt=avkV=0.0;
		for(int traj=0;traj<length;traj++){
			avkV+=(inputs[traj]->activity[t]*inputs[traj]->volumes[t]);
			avkt+=inputs[traj]->activity[t];
			avVt+=inputs[traj]->volumes[t];
		}
		avkV=avkV/(double)length;
		avkt=avkt/(double)length;
		avVt=avVt/(double)length;
		varKV[t]=avkV-(avkt*avVt);
		Vtcorrel[t][0]=(double)t;
	}
	for(int t=0;t<slices;t++){
		avVt=0.0;
		for(int traj=0;traj<length;traj++)avVt+=inputs[traj]->volumes[t];
		avVt/=(double)length;
		for(int tprime=0;tprime<slices;tprime++){
			Vtktprime=0.0;
			avktprime=0.0;
			for(int traj=0;traj<length;traj++){
				Vtktprime+=((inputs[traj]->volumes[t])*(inputs[traj]->activity[tprime]));
				avktprime+=inputs[traj]->activity[tprime];
			}
			avVtktprime=Vtktprime/(double)length;
			avktprime/=(double)length;
			Vtcorrel[abs(t-tprime)][1]+=(avVtktprime-(avVt*avktprime));
	//		counter[abs(t-tprime)]++;
		}
	}
	Vtcorrel[0][1]=Vtcorrel[0][1]/(double)slices;
	for(int t=1;t<slices;t++)Vtcorrel[t][1]=Vtcorrel[t][1]/(2.0*((double)slices-(double)t));
 	for(int t=0;t<slices;t++)Vtcorrel[t][1]=Vtcorrel[t][1]/varKV[t];	
	return Vtcorrel;
}

double get_dKds_correlation(trajectory **inputs,int length,int slices){
	//This is double integral dt dt' over 0->tobs of  <V(t)k(t')>-<V(t)><k(t')>
	//the origin is t' is midpoint of traj
	double avkt,avktprime,ktktprime,avktktprime,sum;
	int origin=floor((double)slices/2.0);
	sum=0.0;
	for(int t=0;t<slices;t++){
		avkt=0.0;
		for(int traj=0;traj<length;traj++)avkt+=inputs[traj]->activity[t];
		avkt/=(double)length;
		for(int tprime=0;tprime<slices;tprime++){
			ktktprime=0.0;
			avktprime=0.0;
			for(int traj=0;traj<length;traj++){
				ktktprime+=((inputs[traj]->activity[t])*(inputs[traj]->activity[tprime]));
				avktprime+=inputs[traj]->activity[tprime];
			}
			avktktprime=ktktprime/(double)length;
			avktprime/=(double)length;
			sum+=(avktktprime-(avkt*avktprime));
		}
	}

	return -sum;
}

void get_rank_compressibilities(int particles, double avvolume,double avvolume_sq,double *compressibility_points,double *compressibility_rods,double *variance_volumes){
	double variance;
	variance=avvolume_sq-(avvolume*avvolume);
	*variance_volumes=variance;
	*compressibility_points=((double)particles*variance)/(avvolume*avvolume);
	*compressibility_rods=((double)particles*variance)/((avvolume*avvolume)+(2.0*avvolume*(double)particles)+((double)particles*(double)particles));
}

double get_dVds_correlation(trajectory **inputs,int length,int slices){
	//This is double integral dt dt' over 0->tobs of  <V(t)k(t')>-<V(t)><k(t')>
	double avVt,avktprime,Vtktprime,avVtktprime,sum;
	int origin=floor((double)slices/2.0);
	sum=0.0;
	for(int t=0;t<slices;t++){
		avVt=0.0;
		for(int traj=0;traj<length;traj++)avVt+=inputs[traj]->volumes[t];
		avVt=avVt/(double)length;
		for(int tprime=0;tprime<slices;tprime++){
			Vtktprime=0.0;
			avktprime=0.0;
			for(int traj=0;traj<length;traj++){
				Vtktprime+=((inputs[traj]->volumes[t])*(inputs[traj]->activity[tprime]));
				avktprime+=inputs[traj]->activity[tprime];
			}
			avVtktprime=Vtktprime/(double)length;
			avktprime=avktprime/(double)length;
			sum+=(avVtktprime-(avVt*avktprime));
		}
	}
	return -sum;
}

void trajectory::pullactivemiddleslice(double sval,int tps,int num,char cwd[],double statepoint){
	int midpoint;
	std::ofstream outfile;
	char filename[400],sstr[20],tpsstr[20],jidstr[20],numstr[20];
	double dummy;

	midpoint=floor(numslices/2);
	if(sval==666)strcpy(sstr,"sall");
	if(sval!=666)snprintf(sstr,20,"s%.3f",sval);
	if(tps==666)strcpy(tpsstr,"TPSall");
	if(tps!=666)snprintf(tpsstr,20,"TPS%i",tps);
	snprintf(jidstr,20,"JID%i",jobid);
	snprintf(numstr,20,"N%i",num);
	strcpy(filename,cwd);
	strcat(filename,"/../configs/activeconfig");
	strcat(filename,sstr);
	strcat(filename,tpsstr);
	strcat(filename,jidstr);
	strcat(filename,numstr);
	outfile.open(filename);
	outfile<<totalactivity;
	outfile<<'\t'<<(volumes[midpoint]);
	outfile<<std::endl;
	for(int part=0;part<particles;part++){
		for(int dim=0;dim<DIMENSIONS;dim++){
			outfile<<positions[midpoint][part][dim]<<'\t';
		}
		outfile<<"1.0"<<std::endl;
	}
	outfile.close();
}

void trajectory::pullinactivemiddleslice(double sval,int tps,int num,char cwd[],double statepoint){
	int midpoint;
	std::ofstream outfile;
	char filename[400],sstr[20],tpsstr[20],jidstr[20],numstr[20];
	double dummy;

	midpoint=floor(numslices/2);
	
	if(sval==666)strcpy(sstr,"sall");
	if(sval!=666)snprintf(sstr,20,"s%.3f",sval);
	if(tps==666)strcpy(tpsstr,"TPSall");
	if(tps!=666)snprintf(tpsstr,20,"TPS%i",tps);
	snprintf(jidstr,20,"JID%i",jobid);
	snprintf(numstr,20,"N%i",num);
	strcpy(filename,cwd);
	strcat(filename,"/../configs/inactiveconfig");
	strcat(filename,sstr);
	strcat(filename,tpsstr);
	strcat(filename,jidstr);
	strcat(filename,numstr);
	outfile.open(filename);
	outfile<<totalactivity;
	outfile<<'\t'<<(volumes[midpoint]);
	outfile<<std::endl;
	for(int part=0;part<particles;part++){
		for(int dim=0;dim<DIMENSIONS;dim++){
			outfile<<positions[midpoint][part][dim]<<'\t';
		}
		outfile<<"1.0"<<std::endl;
	}
	outfile.close();
}

trajectory::trajectory(char filename[],int slices,double statep,int N,string reg,int numfiles_rank,int num,int rank){
    int i,spec,part,dim,slice,repeat;
    double nums[10];

	IDEAL_GAS_GR=false; //Ubntil converted to points
    particles=N;
    Ntobs=(double)particles*(double)slices;
    regime=reg; 
    std::string s (filename);
    i=0;
    
    //jobid=nums[8];
	jobid=(rank*numfiles_rank)+num;
    numslices=slices;
    
    statepoint=statep;
    activity=new double[numslices];
    energies=new double[numslices];
    redpressure=new double[numslices];
    volumes=new double[numslices];
    accepts=new double[numslices];
    deltacofm=alloc_2d_double(numslices,DIMENSIONS);
    positions=alloc_3d_double(numslices,particles,DIMENSIONS);
    displacements=alloc_3d_double(numslices,particles,DIMENSIONS);
    species=alloc_2d_int(numslices,particles);
    MSD=alloc_2d_double(numslices,SPECIES);
    fkt=alloc_2d_double(numslices,SPECIES);
    fktsq=alloc_2d_double(numslices,SPECIES);
    chi4=alloc_2d_double(numslices,SPECIES);
	Sk=NULL;
	averagegr=NULL;
	averagesr=NULL;
	sep_k=NULL;
	kvectors=NULL;
	rho_r=NULL;
	subsystem_occupancy=NULL;
    
    std::ifstream infile;
    char path[300];
    strcpy(path,filename);
    //std::cout <<"Getting trajectory data from "<<path<<std::endl;
    
    infile.open(path);
    if(!infile.good()){
	    std::cout<<"Could not open file"<<path<<std::endl;
        exit(1);
    }
    do{
        repeat=0;
        try{
            infile.precision(8);
	    infile >> totalactivity;
	    infile >> trajvolume;
	    infile >> trajenergy;
            for(slice=0;slice<numslices;slice++){
                infile >> activity[slice];
				infile >> volumes[slice];
                for(i=0;i<particles;i++){
                    infile >> positions[slice][i][0];
                    infile >> displacements[slice][i][0];
		    		infile >> species[slice][i];
		    		species[slice][i]=0;
                }
            }
        }
        catch(std::ifstream::failure except){
		std::cout<<"exception of type "<< except.what()<<" at loadstate 1"<<std::endl;
            if(infile.eof()){
                infile.clear();
                infile.seekg(0);
                repeat=1;
		std::cout<<" pointer moved to start"<<std::endl;
            }
            else if(infile.fail()){
		    std::cout<<"Failed to read file!!"<<std::endl;
                exit(1);
            }
        }
    }while(repeat==1);
    infile.close(); 
    //std::cout<<"File "<<filename<<" read in"<<std::endl;
    calc_deltacofm();
}

void trajectory::calc_deltacofm(){
	for(int slice=0;slice<numslices;slice++){
		for(int dim=0;dim<DIMENSIONS;dim++){
			deltacofm[slice][dim]=0.0;
			for(int part=0;part<particles;part++){
				deltacofm[slice][dim]+=displacements[slice][part][dim];
			}
			deltacofm[slice][dim]=deltacofm[slice][dim]/(double)particles;
		}
	}
}

void trajectory::get_gr(double binsize, int numbins){
	double disp,totalgr,particle_dist,sum,normalise;
	double **gr;
	int bin,slice;
	
	gr=alloc_2d_double(numslices/2,numbins);
	//cout<<"gr Numbins is "<<numbins<<endl;	
	for(int slicecount=0;slicecount<numslices/2;slicecount++){
		slice=slicecount+(numslices/4);
//		cout<<"slicecount is "<<slicecount<<"Slice is "<<slice<<endl;
		for(int i=0;i<numbins;i++){gr[slicecount][i]=0.0;}
		for(int p1=0;p1<particles;p1++){
			for(int p2=0;p2<particles;p2++){
			       if(p1!=p2){
			       		disp=positions[slice][p1][0]-positions[slice][p2][0];	       
						if(disp>(0.5*volumes[slice]))disp=disp-volumes[slice];
						if(disp<(-0.5*volumes[slice]))disp=disp+volumes[slice];
						if(disp<0)disp=-1.0*disp;
						bin=floor(disp/binsize);
						//cout<<"p1 "<<p1<<" p2 "<<p2<<" bin is "<<bin<<" out of "<<numbins<<" volume "<<volumes[slice]<<" disp/binsize "<<(disp/binsize)<<endl;
						gr[slicecount][bin]++;
			       }
			}
		}
		//Normalise by line density from eqn state
		if(!IDEAL_GAS_GR){
			for(int i=0;i<numbins;i++){
				gr[slicecount][i]/=((double)particles*2.0);//2.0 because symmetric around 0
				if(regime=="P")gr[slicecount][i]/=(binsize/((1.0/statepoint)+1.0));
				if(regime=="V")gr[slicecount][i]/=(binsize*statepoint);
			}
		}
		else{
			for(int i=0;i<numbins;i++)gr[slicecount][i]/=((double)particles*2.0);//2.0 because symmetric around 0
			if(regime=="V"){
			sum=0.0;
				for(int i=0;i<numbins;i++)sum+=gr[slicecount][i]*binsize;
				normalise=volumes[slice]/(2.0*sum);
				for(int i=0;i<numbins;i++)gr[slicecount][i]*=normalise;
			}
			if(regime=="P"){
				for(int i=0;i<numbins;i++)gr[slicecount][i]=gr[slicecount][i]/(statepoint*binsize);
			}
		}
	}
	
	averagegr=alloc_2d_double(numbins,2);
	totalgr=0.0;
	for(bin=0;bin<numbins;bin++){
		averagegr[bin][0]=((double)bin*binsize)+(binsize/2.0);
		averagegr[bin][1]=0.0;
		for(slice=0;slice<numslices/2;slice++){
			averagegr[bin][1]+=gr[slice][bin];
			totalgr+=gr[slice][bin];
		}
		//if(averagegr[bin][1]!=0)averagegr[bin][1]=averagegr[bin][1]/(binsize*totalgr);
	}
	for(bin=0;bin<numbins;bin++){
		averagegr[bin][1]=averagegr[bin][1]/((double)numslices/2.0);
	}
	//delete big gr array
	delete_2d_double(gr);
}

void trajectory::get_sepr(double binsize, int numbins){
	double disp,totalsr,bin_normalise;
	double **sr;
	int bin,ptemp,slice;
	
	bin_normalise=2.0*particles*binsize;
	sr=alloc_2d_double(numslices/2,numbins);
	//cout<<"s(r) numbins is "<<numbins<<endl;	
	for(int slicecount=0;slicecount<numslices/2;slicecount++){
		slice=slicecount+(numslices/4);
		for(int i=0;i<numbins;i++){sr[slicecount][i]=0.0;}
		for(int p1=0;p1<particles;p1++){
			for(int p2=p1-1;p2<=p1+1;p2++){	//Count separations over neighbpurs  
				ptemp=p2;
				if(p2<0)p2=particles-1;
				if(p2==particles)p2=0;
				if(p1!=p2){
			       	disp=positions[slice][p1][0]-positions[slice][p2][0];	       
					if(disp>(0.5*volumes[slice]))disp-=volumes[slice];
					if(disp<(-0.5*volumes[slice]))disp+=volumes[slice];
					if(!IDEAL_GAS_GR){
						if(disp>0)disp-=1.0;
						if(disp<0)disp+=1.0;
					}
					disp=fabs(disp);
					bin=floor(disp/binsize);
					//cout<<"bin is "<<bin<<" out of "<<numbins<<" volume "<<volumes[slice]<<" disp/binsize "<<(disp/binsize)<<endl;
					sr[slicecount][bin]+=1.0;
			       }
			       p2=ptemp; 
			}
		}
		for(int i=0;i<numbins;i++){
			sr[slicecount][i]=sr[slicecount][i]/bin_normalise;  // bcos im counting each free volume element twice 
			//if(regime=="P")sr[slice][i]=sr[slice][i]/(binsize/((1.0/statepoint)+1.0));
			//if(regime=="V")sr[slice][i]=sr[slice][i]/(binsize*statepoint);
		}
	}
	averagesr=alloc_2d_double(numbins,2);
	totalsr=0.0;
	for(bin=0;bin<numbins;bin++){
		averagesr[bin][0]=((double)bin*binsize)+(binsize/2.0);
		averagesr[bin][1]=0.0;
		for(slice=0;slice<numslices/2;slice++){
			averagesr[bin][1]+=sr[slice][bin];
			totalsr+=sr[slice][bin];
		}
		averagesr[bin][1]=averagesr[bin][1]/((double)numslices*0.5);
	}
	
	double trap=0.0;
	for(bin=0;bin<numbins;bin++){
	//	trap+=averagesr[bin][1]*binsize;
		trap+=averagesr[bin][0]*averagesr[bin][1];
	}
	//cout <<"TRAP AREA is "<<trap<<endl;
	
	/*ofstream outfile;
	outfile.open("sr");
	for(int i=0;i<numbins;i++){
		outfile<<averagesr[i][0]<<"\t"<<averagesr[i][1]<<"\t"<<sr[50][i]<<endl;
	}
	outfile.close();*/
	delete_2d_double(sr);
}

void trajectory::convert_to_points(double diameter){
	double gap,halfvol,temp_pos[particles];
	IDEAL_GAS_GR=true;
	temp_pos[0]=0.0;
	for(int slice=0;slice<numslices;slice++){
		halfvol=volumes[slice]/2.0;
		for(int p=1;p<particles;p++){
			gap=positions[slice][p][0]-positions[slice][p-1][0];
		//	if(gap<0)gap=gap*-1.0;
			if(gap>halfvol)gap=volumes[slice]-gap;	
			if(gap<(-1.0*halfvol))gap=volumes[slice]+gap;	
			if(gap<0)gap=gap*-1.0;
			gap=gap-diameter;
		//	if(gap<0)cout<<"OUCH!!!!"<<endl;
			temp_pos[p]=temp_pos[p-1]+gap;
		}
		volumes[slice]=volumes[slice]-((double)particles*diameter);
		halfvol=volumes[slice]/2.0;
		for(int p=0;p<particles;p++){
//			if(temp_pos[p]>halfvol)temp_pos[p]-=volumes[slice];
//			if(temp_pos[p]<(-1.0*halfvol))temp_pos[p]+=volumes[slice];
			positions[slice][p][0]=temp_pos[p];
		}
	}
}

void trajectory::resize_clump(double clump_volume){
	double halfvol=clump_volume/2.0;
	for(int slice=0;slice<numslices;slice++){
	volumes[slice]=clump_volume;
	//volumes[slice]=clump_volume;
	for(int p=0;p<particles;p++){
			//THIS might never happen if all boxes are becoming bigger unifromly
//			if(positions[slice][p][0]>halfvol)positions[slice][p][0]-=volumes[slice];
//			if(positions[slice][p][0]<-halfvol)positions[slice][p][0]+=volumes[slice];
	}
	}
}

void trajectory::get_rho_r(int nbins,double binwidth){
	double gap,maxgap,halfvol,distance,origin,sum,normalise;
	int plast,firstrod,lastrod,slice,bin,halfbin;
	double avvolume=0.0;
	halfbin=nbins;
	rho_r=new double[(2*nbins)];
	for(int i=0;i<(2*nbins);i++)rho_r[i]=0.0;
	for(int sl=0;sl<numslices/2;sl++){
	slice=sl+(numslices/4);
	maxgap=0.0;
	avvolume+=volumes[slice];
	halfvol=volumes[slice]/2.0;
	for(int p=0;p<particles;p++){
		plast=p-1;
		if(plast<0)plast+=particles;
		gap=(positions[slice][p][0]-positions[slice][plast][0]);
		if(gap>volumes[slice]/2.0)gap=gap-volumes[slice];
		if(gap<volumes[slice]/-2.0)gap=gap+volumes[slice];
		if(gap<0)gap=gap*-1.0;
		if(gap>maxgap){
				firstrod=p;
				lastrod=plast;
				maxgap=gap;
		}
	}
	origin=positions[slice][firstrod][0]-(maxgap/2.0);
	origin+=(drand48()-0.5)*maxgap;
	origin+=halfvol;
	if(origin<-halfvol)origin+=volumes[slice];
	if(origin>halfvol)origin-=volumes[slice];

	for(int p=0;p<particles;p++){
		distance=positions[slice][p][0]-origin;
		if(distance<-halfvol)distance+=volumes[slice];
		if(distance>halfvol)distance-=volumes[slice];
		bin=floor(distance/binwidth);
		rho_r[bin+halfbin]++;
	}
	}
	avvolume=avvolume/((double)numslices*0.5);
	for(int i=0;i<(2*nbins);i++)rho_r[i]/=((double)numslices*0.5);
		if(!IDEAL_GAS_GR){
			for(int i=0;i<(2*nbins);i++){
				if(regime=="P")rho_r[i]/=(binwidth/((1.0/statepoint)+1.0));
				if(regime=="V")rho_r[i]/=(binwidth);
			}
		}
		if(IDEAL_GAS_GR){
			sum=0.0;
			for(int i=0;i<2*nbins;i++)sum+=rho_r[i]*binwidth;
			normalise=avvolume/(sum);
			for(int i=0;i<2*nbins;i++)rho_r[i]*=normalise;
		}
}

void trajectory::get_max_rho_r(int nbins){
	max_rho_r=0.0;
	for(int i=(nbins/2);i<(2*nbins)-(nbins/2);i++)if(rho_r[i]>max_rho_r)max_rho_r=rho_r[i];
}

void trajectory::convert_to_clumps(){
	double temp_pos[particles],gaps[particles],gap,maxgap,halfvol;
	int pnext,part,firstrod,lastrod,plast,slice,old_particles,new_particles;
	int omit_num=1;
	old_particles=particles;
	new_particles=particles-(2*omit_num);;
	for(int sl=0;sl<numslices;sl++){
	slice=sl;
	maxgap=0.0;
	for(int p=0;p<old_particles;p++){
		plast=p-1;
		if(plast<0)plast+=old_particles;
		gap=(positions[slice][p][0]-positions[slice][plast][0]);
		if(gap>volumes[slice]/2.0)gap=gap-volumes[slice];
		if(gap<volumes[slice]/-2.0)gap=gap+volumes[slice];
		if(gap<0)gap=gap*-1.0;
		gaps[p]=gap;//gap between p and p-1 so gaps[firstrod]=maxgap
		if(gap>maxgap){
				firstrod=p;
				lastrod=plast;
				maxgap=gap;
		}
	}
	for(int p=0;p<new_particles;p++){
			part=firstrod+p+omit_num;
			if(part>=old_particles)part-=old_particles;
			if(p==0){
					temp_pos[p]=(0.5*gaps[part]);
					volumes[slice]=0.5*gaps[part];
			}
			else{
				   	temp_pos[p]=temp_pos[p-1]+gaps[part];//pos of prev particle + gap between prev and this
					volumes[slice]+=gaps[part];
			}
	}
	part++;
	if(part>=old_particles)part-=old_particles;
	volumes[slice]+=0.5*gaps[part];
	halfvol=volumes[slice]/2.0;
	//volumes[slice]=clump_volume;
	for(int p=0;p<new_particles;p++){
			if(temp_pos[p]>halfvol)temp_pos[p]-=volumes[slice];
			positions[slice][p][0]=temp_pos[p];
	}
/*	if(slice==50){
		for(int p=0;p<new_particles;p++){
			plast=p-1;if(plast<0)plast+=new_particles;
			gap=positions[slice][p][0]-positions[slice][plast][0];
			if(gap<-halfvol)gap+=volumes[slice];
			if(gap>halfvol)gap-=volumes[slice];
			outfile<<p<<" "<<gap<<" "<<positions[slice][p][0]<<endl;
		}
	}*/
	}
	particles=new_particles;
}

void trajectory::HU_box_counting(double *sys_sizes,int num_sizes){
	double gap,maxgap,subsystem_middle,subsystem_size,subsystem_start,subsystem_end,occupancy,swap,region;
	int pnext,midslice,repeats,firstrod,lastrod,slice;
	repeats=50;
	subsystem_occupancy=alloc_3d_double(numslices/2,num_sizes,2);
	for(int i=0;i<num_sizes;i++)for(int j=0;j<2;j++)for(int sl=0;sl<numslices/2;sl++)subsystem_occupancy[sl][i][j]=0.0;
	for(int sl=0;sl<numslices/2;sl++){
	slice=(numslices/4)+sl;
	maxgap=0.0;
	for(int p=0;p<particles;p++){
		pnext=p+1;
		if(pnext==particles)pnext=0;
		gap=(positions[slice][p][0]-positions[slice][pnext][0]);
		if(gap>volumes[slice]/2.0)gap=gap-volumes[slice];
		if(gap<0)gap=gap*-1.0;
		if(gap>maxgap){
				firstrod=pnext;
				lastrod=p;
				maxgap=gap;
		}
	}
	region=volumes[slice]-maxgap;
	for(int i=0;i<num_sizes;i++){
		subsystem_size=sys_sizes[i];
		for(int j=0;j<repeats;j++){
			do{
				subsystem_middle=(drand48()*region)+positions[slice][firstrod][0];
				if(subsystem_middle>volumes[slice]/2.0)subsystem_middle-=volumes[slice];
				if(subsystem_middle<-0.5*volumes[slice])subsystem_middle+=volumes[slice];
				subsystem_start=subsystem_middle-(subsystem_size/2.0);
				if(subsystem_start>volumes[slice]/2.0)subsystem_start-=volumes[slice];
				if(subsystem_start<-0.5*volumes[slice])subsystem_start+=volumes[slice];
				subsystem_end=subsystem_middle+(subsystem_size/2.0);
				if(subsystem_end>0.5*volumes[slice])subsystem_end-=volumes[slice];
				if(subsystem_end<-0.5*volumes[slice])subsystem_end+=volumes[slice];
			}while(subsystem_start<positions[slice][firstrod][0] || subsystem_end>positions[slice][lastrod][0]);
			occupancy=0.0;
			if(subsystem_start<subsystem_end){
				for(int p=0;p<particles;p++)if(positions[slice][p][0]>subsystem_start && positions[slice][p][0]<subsystem_end)occupancy+=1.0;
			}
			else{
				for(int p=0;p<particles;p++)if( (positions[slice][p][0]>subsystem_start&&positions[slice][p][0]<volumes[slice]*0.5) || (positions[slice][p][0]<subsystem_end))occupancy+=1.0;
			}
			subsystem_occupancy[sl][i][0]+=occupancy;
			subsystem_occupancy[sl][i][1]+=occupancy*occupancy;
		}
		subsystem_occupancy[sl][i][0]=subsystem_occupancy[sl][i][0]/(double)repeats;
		subsystem_occupancy[sl][i][1]=subsystem_occupancy[sl][i][1]/(double)repeats;
	}
	}
}

void trajectory::get_S_k(int klength){
	double distance,kvector,particle_dist;
	Sk=new double[klength]; 
	kvectors=new double[klength];
	for(int kindex=0;kindex<klength;kindex++){
		Sk[kindex]=0.0;
		kvectors[kindex]=0.0;
		for(int slice=numslices/4;slice<(3*numslices)/4;slice++){//Only take middle slices	
			kvector=(2.0*pi*((double)kindex+1.0))/(volumes[slice]);
			kvectors[kindex]+=kvector;
			for(int p1=0;p1<particles;p1++){
				for(int p2=p1;p2<particles;p2++){	//Count separations over neighbpurs  
				       	distance=positions[slice][p1][0]-positions[slice][p2][0];	       
						if(distance>(0.5*volumes[slice]))distance-=volumes[slice];
						if(distance<(-0.5*volumes[slice]))distance+=volumes[slice];
						if(p1!=p2)Sk[kindex]+=2.0*(cos(kvector*distance));
						if(p1==p2)Sk[kindex]+=cos(kvector*distance);
					}
				}
	//		Sk[kindex]=Sk[kindex]*((double)particles/volumes[slice]);//S(k)=1+rho* F.T.[g(r)]
		}
		
		Sk[kindex]=Sk[kindex]/((double)particles*((double)numslices/2.0));//Averaged by 1/N and number of slices looked at.
		kvectors[kindex]/=((double)numslices/2.0);
	}
}

void trajectory::get_sep_k(int klength,double *kvectors){
	double disp,particle_dist;
	int ptemp;
	sep_k=new double[klength]; 
	for(int kindex=0;kindex<klength;kindex++){
		sep_k[kindex]=0.0;
		for(int slice=numslices/4;slice<(3*numslices)/4;slice++){//Only take middle slices	
			for(int p1=0;p1<particles;p1++){
				for(int p2=p1-1;p2<=p1+1;p2++){	//Count separations over neighbpurs  
					ptemp=p2;
					if(p2<0)p2=particles-1;
					if(p2==particles)p2=0;
					if(p1!=p2){
				       	disp=positions[slice][p1][0]-positions[slice][p2][0];	       
						if(disp>(0.5*volumes[slice]))disp-=volumes[slice];
						if(disp<(-0.5*volumes[slice]))disp+=volumes[slice];
						if(disp>0)disp-=1.0;
						if(disp<0)disp+=1.0;
						disp=fabs(disp);
						if(IDEAL_GAS_GR){
							particle_dist=(double)p1-(double)p2;
							if(particle_dist<0)particle_dist*=-1.0;
							if(particle_dist>(double)particles*0.5){
									particle_dist=(double)particles-particle_dist;
							}
							disp=disp-particle_dist;
						}
						sep_k[kindex]+=(cos(kvectors[kindex]*disp));
					}
					p2=ptemp;		
				}
			}
		}
		sep_k[kindex]=sep_k[kindex]/(2.0*((double)numslices/2.0));
	}
}

void trajectory::copytraj(trajectory *copy){
        int i,spec,part,dim;
       
       	statepoint=copy->statepoint;
		numslices=copy->numslices;
        for(i=0;i<numslices;i++){
            activity[i]=copy->activity[i];
            energies[i]=copy->energies[i];
            redpressure[i]=copy->redpressure[i];
            accepts[i]=copy->accepts[i];
            for(dim=0;dim<DIMENSIONS;dim++)deltacofm[i][dim]=copy->deltacofm[i][dim];
	    volumes[i]=copy->volumes[i];
            for(spec=0;spec<SPECIES;spec++){
                MSD[i][spec]=copy->MSD[i][spec];
                fkt[i][spec]=copy->fkt[i][spec];
            }
            for(part=0;part<particles;part++){
                species[i][part]=copy->species[i][part];
                for(dim=0;dim<DIMENSIONS;dim++){
                    positions[i][part][dim]=copy->positions[i][part][dim];
                    displacements[i][part][dim]=copy->displacements[i][part][dim];
                }
            }
        }
}
        
double trajectory::getdisplacement(int slice,int particle){
    double d;
    for(int dim=0;dim<DIMENSIONS;dim++){
    	d=displacements[slice][particle][dim]-deltacofm[slice][dim];
    }
    return d; 
}
           
void trajectory::rebuildtrajectory(){
   int i,dim,type,spec,stateindex,midpoint;
   double numparts[SPECIES];
   double saveddisp[particles],kvec,meandisplacement[SPECIES],tempfkt,tempfktsq,diam,sumfkt[SPECIES],sumfktsq[SPECIES],slicedisparray[DIMENSIONS],dispi,msdi;
   //saveddisp conts displacement for each individual particle, savedmsd is same for msd
   spec=SPECIES;
   numparts[0]=(double)particles;
   midpoint=floor(numslices/2);
   kvec=2*pi;
   diam=1.0;
   for(i=0;i<particles;i++){
         saveddisp[i]=0.0;
   }
   for(type=0;type<SPECIES;type++){
       fkt[0][type]=1.0;
       fktsq[0][type]=0.0;
       MSD[0][type]=0.0;
   }
   for(stateindex=1;stateindex<numslices;stateindex++){
       for(type=0;type<SPECIES;type++){
           meandisplacement[type]=0.0;
           sumfkt[type]=0.0;
           sumfktsq[type]=0.0;
       }
       for(i=0;i<particles;i++){
           type=species[stateindex][i];
           dispi=getdisplacement(stateindex,i);
           saveddisp[i]+=dispi;
           msdi=(saveddisp[i]*saveddisp[i]);
           meandisplacement[type]=meandisplacement[type]+msdi;
	   dispi=sqrt(msdi);
           if(dispi!=0){
               tempfkt=sin(dispi*kvec); 
               tempfkt=tempfkt/(kvec*dispi);
           }
           if(dispi==0)tempfkt=1;
           tempfktsq=tempfkt*tempfkt;
           sumfktsq[0]+=tempfktsq;
           sumfkt[0]=sumfkt[0]+tempfkt;
           //if(type<0)std::cout <<"type is "<<type<<" tempfkt is "<<tempfkt<<" msd is "<<msdi<<" for i="<<i<<std::endl;
       }
       for(type=0;type<SPECIES;type++){
           meandisplacement[type]=meandisplacement[type]/numparts[type]; 
           meandisplacement[type]=meandisplacement[type]/(diam*diam);
           MSD[stateindex][type]=meandisplacement[type];
           fkt[stateindex][type]=(sumfkt[type]/numparts[type]);
           fktsq[stateindex][type]=(sumfktsq[type]/numparts[type]);
           chi4[stateindex][type]=fktsq[stateindex][type]-(fkt[stateindex][type]*fkt[stateindex][type]);
           //SO here chi4 is the Variance of fkt in all directions one for each type of particle. No normalising with N either. Poss shoudl be 1/N * <N*Var(fkt)>. but this should be in collectdata where I average over trajectories.
       }       
       //  if(stateindex==50)std::cout <<"fkt "<< fkt[stateindex][0]<< " fktsq "<<fktsq[stateindex][0]<<" chi4 "<<chi4[stateindex][0]<<std::endl;
   }
}



double trajectory::getsquare(double x, double y, double z){
   double square;
   square=(x*x)+(y*y)+(z*z);
   return square;
}

double* make_filter(int slices, int width){
	double *temp=new double[width];
	for(int i=0;i<width;i++){
			temp[i]=1.0;
		//temp[i]=gaussian((double)i,((double)slices*0.5),width);//Gaussian with sd=width/2
	}
	return temp;
}

#endif
