#!/bin/csh -f


#set xbox = 200   ## box size (x,y) in units of particle diameter
#set ybox = 47 
set rod_y = 3   ## overall zoom factor
#rod_y is rod length rod_x is sacle/2=rod fatness

## BE VERY CAREFUL IF YOU WANT TO EDIT BELOW THIS POINT !! ##

if ( $#argv < 1 ) then
  echo need an inputfile
  exit 1
endif

set file = $1

set xbox = `awk 'NR == 1 {print $1;}' $file`
set ybox = `awk 'NR == 1 {print $2;}' $file`
#@ xbox = $xbox * 2 
@ xbox = $xbox  
@ ybox = $ybox + 30
echo "xbox=" $xbox
echo "ybox="$ybox

awk -f - -v xbox=$xbox -v ybox=$ybox -v rod_y=$rod_y $file > $file:r.ps << \TAG
BEGIN { 
  #rod_x = rod_y/2.0; 
  rod_x=rod_y*3.0;
  lx = xbox*rod_x ; ly = ybox*rod_y; 
  offx = rod_x ; offy = rod_y;
  lyhalf=ly/2.0; lyhalf=lyhalf+offy;
  rod_height = rod_y - 2;

  print "%!PS-Adobe-2.0 EPSF-2.0"
  print "%%BoundingBox: 0 0",lx+(2*rod_x),ly; 
  print "/tr{translate}def"
  print "/c {" #draw a circle
  print "0 0",rod_y,"0 360 arc"
  print "setrgbcolor"
  print "fill"
  print "0 0",rod_y,"0 360 arc"
  print "0.00 setgray"
  print "stroke"
  print "} def"#finish circle
  print "/r {"#draw a rod
  print "newpath"
  print -rod_x/2.0," ",-rod_height" moveto"
  print rod_x" 0 rlineto"
  print "0 ",rod_height," rlineto"
  print -rod_x," 0 rlineto"
  print "closepath"
  print "setrgbcolor"
  print "fill"
  print "0.00000000001 setlinewidth"
  print "newpath"
  print -rod_x/2.0," ",-rod_height" moveto"
  print rod_x" 0 rlineto"
  print "0 ",rod_height," rlineto"
  print -rod_x," 0 rlineto"
  print "closepath"
  print "stroke"
  print "} def"   #finish rod
  #print "/b {"#draw a box
  #print "newpath"
#  print "5 setlinewidth" 
#  print -rod_x/2.0," ",-rod_height," moveto"
#  print rod_x" 0 rlineto"
#  print "0 ",rod_height," rlineto"
#  print -rod_x," 0 rlineto"
#  print "closepath"
#  print "setrgbcolor"
#  print "} def"   #finish box
  print "0 setlinewidth" 
  print "0 setgray"
  print "stroke"
  print "0 setlinewidth" 
  #print "newpath"
  #print offx,offy,"moveto"
  #print offx,offy+ly,"lineto"
  #print offx+lx,offy+ly,"lineto"
  #print offx+lx,offy,"lineto"
  #print "closepath"
  print "0 setlinewidth"
  print "0 setgray"
  print "stroke"
  print "0",lyhalf,"translate" 

}

NF==2 && NR>1 { print rod_x,"0","tr";
ny=$1*rod_y; print "0",ny,"tr","0.75 0.16 0.26","r";#Move and draw top boundary in diff colour
len=$2*rod_y;print "0",-len,"tr"; #move back down y direction
 ny=$1*rod_y; print "0","0","tr","0.75 0.16 0.26","r";#draw first boundary
}

#Move in y direction and draw a rod				        
NF==3 { nx=$1*rod_x; ny=$2*rod_y; print "0",ny,"tr","0.387 0.543 0.676","r"; #print "0 0","tr","0.0 0.0 1.0","b";
xx=nx; yy=ny; }

END {
  print "showpage"
}
\TAG

#pstopdf $file:r.ps
