import numpy as np

class Vector():
    def __init__(self, origin, orientation):
        self.origin = origin
        self.orientation = orientation

    def __str__(self):
        return f"Vector[{self.origin}, {self.orientation}]"

    def __repr__(self):
        return self.__str__()
    
class Orientation():
    def __init__(self, yaw, pitch, roll):
        self.yaw = yaw
        self.pitch = pitch
        self.roll = roll

    def to_array(self):
        return np.array([self.yaw, self.pitch, self.roll])
    
    def from_array(array):
        return Orientation(array[0], array[1], array[2])

    def __str__(self):
        return f"Orientation[{self.yaw}, {self.pitch}, {self.roll}]"

    def __repr__(self):
        return self.__str__()
    
class Marker():
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

    def to_array(self):
        return np.array([self.x, self.y, self.z])
    
    def __str__(self):
        return f"Marker[{self.x}, {self.y}, {self.z}]"

    def __repr__(self):
        return self.__str__()
    
    def from_array(array):
        return Marker(array[0], array[1], array[2])
    
    def marker_from_frame(frame, key):
        x = frame.loc[f"{key} X"]
        y = frame.loc[f"{key} Y"]
        z = frame.loc[f"{key} Z"]
        return Marker(x, y, z)
    
    def rotate_about_point(self, axis, yaw, pitch, roll = 0):
        yaw_rad = np.deg2rad(yaw)
        pitch_rad = np.deg2rad(pitch)
        roll_rad = np.deg2rad(roll)

        rot_arr = np.array([
            [ (np.cos(yaw_rad) * np.cos(pitch_rad)), (np.cos(yaw_rad) * np.sin(pitch_rad) * np.sin(roll_rad)) - (np.sin(yaw_rad) * np.cos(roll_rad)), (np.cos(yaw_rad) * np.sin(pitch_rad) * np.cos(roll_rad)) + (np.sin(yaw_rad) * np.sin(roll_rad)) ],
            [ (np.sin(yaw_rad) * np.cos(pitch_rad)), (np.sin(yaw_rad) * np.sin(pitch_rad) * np.sin(roll_rad)) + (np.cos(yaw_rad) * np.cos(roll_rad)), (np.sin(yaw_rad) * np.sin(pitch_rad) * np.cos(roll_rad)) - (np.cos(yaw_rad) * np.sin(roll_rad)) ],
            [ -np.sin(pitch_rad), np.cos(pitch_rad) * np.sin(roll_rad), np.cos(pitch_rad) * np.cos(roll_rad) ]
        ])

        rotated = np.dot(rot_arr, self.to_array())
        return Marker.from_array(axis.to_array() + rotated)