from pandas import DataFrame, read_csv
from os.path import isfile

class TrialData():
    def __init__(self, key: str, metadata: dict, data: DataFrame = None):
        self.key = key
        self.metadata = metadata
        self.data = data

    def set_data(self, data: DataFrame):
        self.data = data

    def from_file(file_path: str):
        if isfile(file_path):
            return TrialData({}, read_csv(file_path))
        raise Exception(f"File '{file_path}' does not exist.")
