import sys
from os.path import  realpath
script_root = realpath(__file__)
sys.path.insert(1, script_root)

from os.path import isfile
import datetime as dt
from dependencies.TrialData import TrialData
import copy

class Trial:
    def __init__(self, sequence_start, path, start_time, end_time, target_id, y, x, sub_target_id, stroop = False):
        self.data: TrialData = None
        self.path = path
        file_timestamp = self.path.split("_")[-1]
        file_timestamp = dt.datetime.fromisoformat(file_timestamp[:19].replace(".", ":") + file_timestamp[19:])
        self.sequence_start = sequence_start
        # if abs((file_timestamp - self.sequence_start).total_seconds()) > 1:
        #     print(f"Estimated sequence start time ({self.sequence_start}) is not close to file creation ({file_timestamp})")
        self.recording = "N/A"
        self.start_time = start_time
        self.start_offset = (start_time - self.sequence_start).total_seconds()
        self.end_time = end_time
        self.end_offset = (end_time - self.sequence_start).total_seconds()
        self.target_id = target_id
        self.y = y
        self.x = x
        self.sub_target_id = sub_target_id
        self.stroop = stroop
    
    # Set data extracted from mocap recording
    def set_data(self, data, recording):
        self.data = copy.deepcopy(data)
        self.recording = recording

    def __str__(self):
        return f"startTime: {self.start_time} ({self.start_offset}s), endTime: {self.end_time} ({self.end_offset}s), TargetId: {self.target_id}, YPos: {self.y}, XPos: {self.x}, Sequence Start: {self.sequence_start}, Recording: {self.recording}, Data: {None if self.data is None else self.data.keys}"
    
    def __repr__(self):
        return f"({self})"

    # Create Trials from logs detailing led activations
    def load_trials_from_LED_activation_logs(file_path):
        trials = []
        stroop_starts = []
        stroop_file = file_path[:-4] + "_Stroop.txt"
        if isfile(stroop_file):
            with open(stroop_file, 'r') as stroop_csv_file:
                previous_clear = ""
                while (True):
                    line = stroop_csv_file.readline()
                    if line == "":
                        break
                    line = line[:-1].split(",") # remove trailing newline and split by comma
                    if line[1] == "SHOW":
                        show_time = dt.datetime.fromisoformat(line[0][:19].replace(".", ":") + line[0][19:])
                        if previous_clear == "" or (show_time - previous_clear).total_seconds() > 10: # only greater than 10 if started a new recording/sequence
                            stroop_starts.append(show_time - dt.timedelta(milliseconds=5000))
                    elif line[1] == "CLEAR":
                        previous_clear = dt.datetime.fromisoformat(line[0][:19].replace(".", ":") + line[0][19:])
            file_timestamp = stroop_file.split("_")[-2]
            file_timestamp = dt.datetime.fromisoformat(file_timestamp[:19].replace(".", ":") + file_timestamp[19:])
            # print(f"Stroop File Created: {file_timestamp}, Stroop starts: {stroop_starts}")
        with open(file_path, 'r') as csv_file:
            file_name = file_path.split("/")[-1][:-4]
            previous_time = ""
            sequence_start = 0
            start_time = ""
            while (True):
                line = csv_file.readline()
                if line == "":
                    break
                line = line[:-1].split(",") # remove trailing newline and split by comma
                if line[1] == "ON":
                    start_time = dt.datetime.fromisoformat(line[0][:19].replace(".", ":") + line[0][19:]) - dt.timedelta(milliseconds=400)
                    if previous_time == "" or (start_time - previous_time).total_seconds() > 10: # only greater than 10 if started a new recording/sequence
                        if len(stroop_starts) > 0:
                            sequence_start = stroop_starts.pop(0)
                        else:
                            sequence_start = start_time - dt.timedelta(milliseconds=5000)
                elif line[1] == "OFF":
                    previous_time = dt.datetime.fromisoformat(line[0][:19].replace(".", ":") + line[0][19:]) + dt.timedelta(milliseconds=400)
                    trials.append(
                        Trial(
                            sequence_start,
                            file_name,
                            start_time,
                            dt.datetime.fromisoformat(line[0][:19].replace(".", ":") + line[0][19:]) + dt.timedelta(milliseconds=400),
                            line[2],
                            line[3],
                            line[4],
                            line[5],
                            isfile(stroop_file)
                        )
                    )
                    # print(trials[-1])
        return trials