require(reshape2)

toUtime <- function(df, crellin=T, tsep=T) {
  strf <- "%Y-%m-%dT%H:%M:%S"
  if(!tsep)
    strf <- "%Y-%m-%d %H:%M:%S"
  amount <- 0  
  for(i in c(1:nrow(df))) {
    amount <- as.numeric(as.POSIXct(df$time[i], strf, tz="UTC"))
    if(crellin)
      amount <- amount + 3600 #BST update
    df$utime[i] <- amount
  }
  return(df)
}

trl <- read.csv('./trl_xively_living_room.csv', head=F)
colnames(trl) <- c("var","time","value")
levels(trl$time) <- sapply(levels(trl$time), function(x) substring(x,1,nchar(x)-1))
trl$utime <- 0
trl <- toUtime(trl)

trl.cast <- dcast  