toUtime <- function(df, crellin=T, tsep=T) {
  strf <- "%Y-%m-%dT%H:%M:%S"
  if(!tsep)
    strf <- "%Y-%m-%d %H:%M:%S"
  amount <- 0  
  for(i in c(1:nrow(df))) {
    amount <- as.numeric(as.POSIXct(df$time[i], strf, tz="UTC"))
    if(crellin)
      amount <- amount + 3600 #BST update
    df$utime[i] <- amount - amount%%60 # floor to nearest minute
  }
  return(df)
}

fi <- commandArgs(T)[1]
fo <- paste("./tf/", substr(fi,1,nchar(fi)-4),"_tf.csv", sep="")

fi.file <- read.csv(fi,head=F)
colnames(fi.file) <- c("var","time","value")
levels(fi.file) <- sapply(levels(fi.file), function(x) substring(x,1,nchar(x)-1))
fi.file$utime <- 0
fi.file <- toUtime(fi.file)
write.table(fi.file, fo, quote=F, sep=",")
