#!/bin/bash
# args are: input file name (without dir), gt file, room factor name

ROOM=(Bedroom "Living Room" "Spare Room" Kitchen "Utility Room" Bedroom Kitchen "Living Room" "Main bedroom" Kitchen "Living room" "Spare room" Study)
GT=(8 8 8 7 7 5 5 5 1 1 1 1 1)
i=0
for f in *.csv; do 
    if [[ "$f" == "mi.csv" ]]; then continue; fi
    if [[ "$f" == "sn_kitchen.csv" ]]; then let i++; continue; fi
    #Rscript preprocess.R $1
    #Rscript feature_calculator.R $1 $2 "$3" $1
    echo "Running on $f"
    Rscript preprocess.R $f
    Rscript feature_calculator.R $f ../gt/${GT[$i]}.csv "${ROOM[i]}" $f
    sed -i '1s/_\?X[0-4]_//g' $f #remove the Xs from the headers
    let i++
done
