require(reshape2)


toUtime <- function(df) {
  strf <- "%Y-%m-%dT%H:%M:%S"  
  amount <- 0  
  for(i in c(1:nrow(df))) {
    df$UStart[i] <- as.numeric(as.POSIXct(df$Start[i], strf, tz="UTC"))
    df$UEnd[i] <- as.numeric(as.POSIXct(df$End[i], strf, tz="UTC"))    
  }
  return(df)
}

sensor.data <- read.csv(commandArgs(T)[1], head=T)
s.wide <- dcast(sensor.data, utime ~ var, mean)
write.table(s.wide, file=commandArgs(T)[2],quote=F,sep=",",row.names=F)
