require(randomForest)
split <- c(0.7,0.15,0.15)
data <- read.csv(commandArgs(T)[1], head=T)
if("Digital_Inputs" %in% names(data)) data$maDigital_Inputs <- as.factor(data$maDigital_Inputs)
#data <- read.csv("../trl_kitchen.csv", head=T)
#column selection
sensors <- c("Temperature", "Sound", "Light", "Humidity", "CO2", "Digital")#, "pressure", "Mains", "Digital")
nv <- c()
for(i in sensors) nv <- c(nv,grep(i,names(data)))
nv <- c(nv, ncol(data))
data <- data[,nv]
set.seed(42)
nobs <- nrow(data)
sample <- train <- sample(nrow(data), split[1]*nobs)
validate <- sample(setdiff(seq_len(nrow(data)), train), split[2]*nobs)
test <- setdiff(setdiff(seq_len(nrow(data)), train), validate)
input <- colnames(data)[c(-1,-ncol(data))]
target <- "event"
rf <- randomForest(formula = as.factor(event) ~ .,
             data = data[sample, c(input, target)],
             ntree = 500, mtry = 4, importance = TRUE, replace = FALSE, na.action = na.omit)
rn <- round(importance(rf), 2)
#rn[order(rn[,3], decreasing=TRUE),]
write.table(rn[,4], commandArgs(T)[2],append=TRUE,row.names=TRUE,sep=",",quote=FALSE,col.names=FALSE)
