require(ggplot2)
require(reshape2)

#data <- read.csv(commandArgs(TRUE)[1], head=T)
data <- read.csv('./trl_kitchen.csv', head=T)
fm <- data[, c(1:7,24)]
#fm <- data
fmelt <- melt(fm, id.vars = c("utime"))
fmelt$utime <- as.POSIXct(fmelt$utime, origin="1970-01-01")
levels(fmelt$variable) <- c("Temp (C)", "Sound (dB)", "CO2 (ppm)", "Light (lux/100)", "Humidity (%)", "PIR", "Event")
p <- ggplot(fmelt, aes(x=utime, y=value))
cairo_pdf("./tkitchen.pdf", height=7, width=8)
print(
      p + geom_line() + facet_grid(variable ~ ., scale="free") + xlab("Day") + theme(strip.text.y = element_text(size=7))
)
dev.off()
