#Input args: wide.csv file
mask.digital <- function(d, pattern) {
    d$Digital_Inputs[d$Digital_Inputs %in% pattern] <- 1
    d$Digital_Inputs[d$Digital_Inputs != 1] <- 0
    return(d)
}

data <- read.csv(paste("./wide/",commandArgs(T)[1],sep=""))
#Change digital states to digital inputs
colnames(data) <- gsub(".States", "_Inputs", colnames(data))
#1 or 5 conversions
one.five <- c("trl_living_room.csv", "trl_bedroom.csv", "trl_study.csv", "lgt_bedroom.csv", "parents_utility_room.csv")
if(commandArgs(T)[1] %in% one.five) data <- mask.digital(data, c(5))
#2,3,6,7 conversions
multi.convertees <- c("parents_kitchen.csv")
if(commandArgs(T)[1] %in% multi.convertees) data <- mask.digital(data, c(2,3,6,7))
#digital states removals
digi.remove <- c("sn_kitchen.csv")
if(commandArgs(T)[1] %in% digi.remove) data <- data[,-grep("_Inputs", names(data))]
#sound removals
sound.remove <- c("lgt_bedroom.csv", "parents_kitchen.csv")
if(commandArgs(T)[1] %in% sound.remove) data <- data[,-grep("Sound_level", names(data))]
#save to THIS dir
write.table(data, commandArgs(T)[1], quote=F, sep=",", row.names=F)
