require(boot)
require(reshape2)
require(ggplot2)
cf <- function(data, indices, sds) {
  #identify which means we'll be using
  return(mean(rnorm(length(indices), data[indices], sds[indices])))
}

data <- read.csv('./sensor_values.csv', head=FALSE)
colnames(data) <- c("Variable", "MeanDecreaseGini")
data <- data[order(-data$MeanDecreaseGini),]
sensors <- c("Temperature", "Sound", "Light", "Humidity", "CO2", "Digital")#, "pressure", "Mains", "Digital")
#cost <- c(1.5,100,0.12,5,200)
cost <- c(200,5,1,100,2)
s.class <- rep(NA,nrow(data))
for(x in sensors)
  s.class[grep(x, data$Variable, value=FALSE)] <- x #label classes
data <- data.frame(data, sensor=as.factor(s.class))
data <- data[complete.cases(data),]
p <- ggplot(data, aes(x=sensor, y=MeanDecreaseGini))
cairo_pdf("./grand_mean.pdf", height=2, width=4.5)
print(
p + stat_summary(fun.data="mean_cl_boot", geom="bar", fill="skyblue", colour="black") + 
  stat_summary(fun.data="mean_cl_boot", geom="errorbar", colour="red", width=.1) + xlab("Sensor")
)
dev.off()
ggsave(file="grand_mean.eps", height=2, width=4)
# lev <- levels(data$sensor)
# mb <- data.frame()
# means <- aggregate(data$MeanDecreaseGini, FUN=mean, by=list(data$Variable, data$sensor))
# sds <- aggregate(data$MeanDecreaseGini, FUN=function(x) sd(x)/sqrt(length(x)), by=list(data$Variable, data$sensor))
# for(l in lev) {
#   bd <- means$x[means$Group.2 == l]
#   sdi <- sds$x[sds$Group.2 == l]
#   bt <- boot(bd, statistic=cf, R=1000,sds=sdi)
#   bci <- boot.ci(bt)
#   mb <- rbind(mb, data.frame(sensor=l, mean=bci$t0, lci=bci$normal[2], uci=bci$normal[3]))
# }
