require(ggplot2)

data <- read.csv('./sensor_values.csv', head=FALSE)
colnames(data) <- c("Variable", "MeanDecreaseGini")
data <- data[order(-data$MeanDecreaseGini),]
sensors <- c("Temperature", "Sound", "Light", "Humidity", "CO2", "Digital")#, "pressure", "Mains", "Digital")
#cost <- c(1.5,100,0.12,5,200)
cost <- c(200,5,1,100,2,2)
s.class <- rep(NA,nrow(data))
for(x in sensors)
  s.class[grep(x, data$Variable, value=FALSE)] <- x #label classes
data <- data.frame(data, sensor=as.factor(s.class))
data <- data[complete.cases(data),]
#reorder and select top 10
top.ten <- c('maDigital_Inputs', 'Humidity', 'maHumidity', 'maTemperature', 'Sound_level', 'Light_level', 'CO2_concentration', 'maLight_level', 'maCO2_concentration', 'maSound_level')
data <- data[data$Variable %in% top.ten,]
#data <- data[order(-MeanDecreaseGini),][1:10,]
p <- ggplot(data, aes(x=reorder(Variable, MeanDecreaseGini), y=MeanDecreaseGini))
cairo_pdf("./features.pdf", height=6, width=5)
print(
p + stat_summary(fun.data = "mean_cl_boot", colour="red", geom="crossbar", width=0.3) + 
  theme(axis.text.x = element_text(angle=90, hjust=1)) + xlab("Feature")
)
dev.off()
tab <- data.frame(aggregate(data$MeanDecreaseGini,by=list("sensor"=data$sensor),mean), cost=cost)
colnames(tab) <- c("sensor", "value", "cost")
tab$value <- round(tab$value)
write.table(tab, './sensor_cost_value.csv', row.names=FALSE, quote=FALSE, sep=",")
