require(ggplot2)
library(scales)
mi <- read.csv('./mi.csv')

av <- aggregate(mi[,4:5], FUN=mean, by=list(mi$v1,mi$v2))
avAlt <- data.frame(av$Group.2, av$Group.1, av$uc2)
colnames(avAlt) <- c("Group.1", "Group.2", "uc1")
avtot <- rbind(av[,-4], avAlt)
tab <- xtabs(uc1 ~ Group.1 + Group.2, avtot)
tab <- tab[,order(colnames(tab))]
tab <- tab[order(-rank(rownames(tab))),]
dft <- as.data.frame(as.table(tab))
dft$Freq[dft$Freq == 0.0] <- NA
p <- ggplot(dft, aes(x=Group.1, y=Group.2))
cairo_pdf(filename="./uc.pdf", height=4, width=6)
print(
p  + geom_tile(aes(fill=Freq), colour="white") + geom_text(aes(label=round(Freq,2)), colour="white") + 
  scale_fill_gradient2(low=muted("white"), high=muted("steelblue"), name="UC", na.value="white") +
  theme(axis.title.x = element_blank(), axis.title.y=element_blank(), axis.text.x = element_text(angle=330, hjust=0))
)
dev.off()