require(ggplot2)
data <- read.csv('./mss.csv', head=TRUE)
#data <- data[data$W < 5000 & data$W > 50 & data$c < 20,]
data <- data[data$W == 500 & data$c == 5,]
#data$W <- as.factor(data$W)
p <- ggplot(data, aes(x=sensor,y=quantity))
cairo_pdf("./mss_grid.pdf", height=2, width=4)
print(
p + geom_bar(stat="identity") + facet_grid(W ~ c, scale="free", labeller = label_both)
)
dev.off()
ggsave(file="./mss_grid.eps", height=2, width=4)
