
toUtime <- function(df, crellin=T, tsep=T) {
  strf <- "%Y-%m-%dT%H:%M:%S"
  if(!tsep)
    strf <- "%Y-%m-%d %H:%M:%S"
  amount <- 0  
  for(i in c(1:nrow(df))) {
    amount <- as.numeric(as.POSIXct(df$time[i], strf, tz="UTC"))
    if(crellin)
      amount <- amount + 3600 #BST update
    df$utime[i] <- amount - amount%%60 # floor to nearest minute
  }
  return(df)
}

catDate <- function(df, start) {
  start <- as.numeric(as.POSIXct(start, "%Y-%m-%d %H:%M:%S", tz="BST"))
  df <- data.frame(utime=0,df)
  df$utime[1] <- start
  for(i in c(2:nrow(df))) {
    diff <- as.numeric(difftime(strptime(df[i,3], "%H:%M:%S"),strptime(df[i-1,3], "%H:%M:%S")))
    if(diff < 0)
      diff <- diff + 24
    df$utime[i] <- df$utime[i-1] + 60*diff    
  }
  df$utime <- sapply(df$utime, function(x) (x - x%%60) + 3600)
  return(df)
}

cr.data <- read.csv(commandArgs(T)[1], head=T)
outfile <- commandArgs(T)[2]
#remove Units columns
cr.data <- cr.data[,substr(colnames(cr.data),1,5) != "Units"]
#remove idiot timestamps
cr.data <- cr.data[as.character(cr.data[,2]) < "24:00:00" & as.character(cr.data[,2]) >= "00:00:00",]
s.year <- "2013"
s.month <- substr(colnames(cr.data)[1],5,6)
s.day <- substr(colnames(cr.data)[1],2,3)
cr.data <- catDate(cr.data, paste(paste(s.year,s.month,s.day,sep="-"), cr.data[1,2]))
#write file out
write.table(cr.data[,c(-2,-3)], file=outfile, quote=F,sep=",",row.names=F)