%This function is a simplified version of pulsePIVScaleAndCorrect_f2 which
%does not correct for the sweeping ultrasound beam.

%The UIV code gives the correlation averaged displacement field at
%successive phases throughout the pulse cycle. This function then
%calculates the velocity fields from those displacements. This includes a
%speed=distance/time calculation.

%For full details see "Ultrasound Imaging Velocimetry with interleaved
%images for improved pulsatile arterial flow measurements: a new correction
%method, experimental and in vivo validation", J Royal Soc Interface, 2017

%K H Fraser, C Poelma 2016

function [VxC, VyC]=pulsePIVScaleAndCorrect_noacceleration(delta, depth, Vx, Vy, int, fluid,period,split)
%for normal PIV delta=lines (the number of lines used in the whole image)
%for interlaced PIV delta=dleta (the number of lines between the images)
%int=0 normal PIV
%int=1 interlaced PIV
%Vx, Vy are DISPLACEMENTS between the image pairs - they are not
%velocities!!
% 
deltaT=(delta)*(2*depth/1540+23.488e-6); %in s
if int==1
    timestep=(2*128+(delta-1))*(2*depth/1540+23.488e-6);
    totalTime=timestep*period;
    dt=totalTime./split;
else
    dt=deltaT;
end
xpix=0.001*38/128;
VxM=Vx.*xpix; %convert x displacement from pix to m
VxM=VxM./deltaT; %convert m displacement to velocity
if fluid=='water'
    ypix=3.7425e-5/2;
elseif fluid=='glyce'
    ypix=2.3653e-05
end
VyM=Vy.*ypix; %convert y displacement from pix to m
VyM=VyM./deltaT; %convert m displacement to velocity

VxC=VxM;
VyC=VyM;
